/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.plugin.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.IDictionaryService;
import org.adempiere.plugin.utils.AbstractActivator;
import org.adempiere.plugin.utils.Version;
import org.adempiere.util.ServerContext;
import org.compiere.Adempiere;
import org.compiere.model.MSession;
import org.compiere.model.Query;
import org.compiere.model.ServerStateChangeEvent;
import org.compiere.model.ServerStateChangeListener;
import org.compiere.model.X_AD_Package_Imp;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Incremental2PackActivator
extends AbstractActivator {
    protected static final CLogger logger = CLogger.getCLogger((String)Incremental2PackActivator.class.getName());

    public void start(BundleContext context) throws Exception {
        this.context = context;
        if (logger.isLoggable(Level.INFO)) {
            logger.info(String.valueOf(this.getName()) + " " + this.getVersion() + " starting...");
        }
        this.serviceTracker = new ServiceTracker(context, IDictionaryService.class.getName(), (ServiceTrackerCustomizer)this);
        this.serviceTracker.open();
        this.start();
        if (logger.isLoggable(Level.INFO)) {
            logger.info(String.valueOf(this.getName()) + " " + this.getVersion() + " ready.");
        }
    }

    @Override
    public String getName() {
        return this.context.getBundle().getSymbolicName();
    }

    public String getVersion() {
        String version = (String)this.context.getBundle().getHeaders().get("Bundle-Version");
        String[] components = version.split("[.]");
        StringBuilder versionBuilder = new StringBuilder(components[0]);
        if (components.length >= 3) {
            versionBuilder.append(".").append(components[1]).append(".").append(components[2]);
        } else if (components.length == 2) {
            versionBuilder.append(".").append(components[1]).append(".0");
        } else {
            versionBuilder.append(".0.0");
        }
        return versionBuilder.toString();
    }

    public String getDescription() {
        return this.getName();
    }

    private void installPackage() {
        String where = "Name=? AND PK_Status = 'Completed successfully'";
        Query q = new Query(Env.getCtx(), "AD_Package_Imp", where.toString(), null);
        q.setParameters(new Object[]{this.getName()});
        List pkgs = q.list();
        ArrayList<String> installedVersions = new ArrayList<String>();
        if (pkgs != null && !pkgs.isEmpty()) {
            for (X_AD_Package_Imp pkg : pkgs) {
                String packageVersionPart = pkg.getPK_Version();
                String[] part = packageVersionPart.split("[.]");
                if (part.length > 3 && (packageVersionPart.indexOf(".v") > 0 || packageVersionPart.indexOf(".qualifier") > 0)) {
                    packageVersionPart = String.valueOf(part[0]) + "." + part[1] + "." + part[2];
                }
                installedVersions.add(packageVersionPart);
            }
        }
        this.packIn(installedVersions);
        this.afterPackIn();
    }

    protected void packIn(List<String> installedVersions) {
        block20: {
            ArrayList<TwoPackEntry> list;
            block19: {
                list = new ArrayList<TwoPackEntry>();
                Enumeration urls = this.context.getBundle().findEntries("/META-INF", "2Pack_*.zip", false);
                while (urls.hasMoreElements()) {
                    URL u = (URL)urls.nextElement();
                    String version = this.extractVersionString(u);
                    list.add(new TwoPackEntry(u, version));
                }
                X_AD_Package_Imp firstImp = (X_AD_Package_Imp)new Query(Env.getCtx(), "AD_Package_Imp", "Name=? AND PK_Version=? AND PK_Status=?", null).setParameters(new Object[]{this.getName(), "0.0.0", "Completed successfully"}).setClient_ID().first();
                if (firstImp == null) {
                    Trx trx = Trx.get((String)Trx.createTrxName(), (boolean)true);
                    trx.setDisplayName(String.valueOf(this.getClass().getName()) + "_packIn");
                    try {
                        try {
                            Env.getCtx().put("#AD_Client_ID", (Object)0);
                            firstImp = new X_AD_Package_Imp(Env.getCtx(), 0, trx.getTrxName());
                            firstImp.setName(this.getName());
                            firstImp.setPK_Version("0.0.0");
                            firstImp.setPK_Status("Completed successfully");
                            firstImp.setProcessed(true);
                            firstImp.saveEx();
                            if (list.size() > 0 && installedVersions.size() > 0) {
                                ArrayList<TwoPackEntry> newList = new ArrayList<TwoPackEntry>();
                                for (TwoPackEntry entry : list) {
                                    boolean patch = false;
                                    for (String v : installedVersions) {
                                        Version v1;
                                        Version v2 = new Version(v);
                                        int c = v2.compareTo(v1 = new Version(entry.version));
                                        if (c == 0) {
                                            patch = false;
                                            break;
                                        }
                                        if (c <= 0) continue;
                                        patch = true;
                                    }
                                    if (patch) {
                                        logger.log(Level.WARNING, "Patch Meta Data for " + this.getName() + " " + entry.version + " ...");
                                        X_AD_Package_Imp pi = new X_AD_Package_Imp(Env.getCtx(), 0, trx.getTrxName());
                                        pi.setName(this.getName());
                                        pi.setPK_Version(entry.version);
                                        pi.setPK_Status("Completed successfully");
                                        pi.setProcessed(true);
                                        pi.saveEx();
                                        continue;
                                    }
                                    newList.add(entry);
                                }
                                list = newList;
                            }
                            trx.commit(true);
                        }
                        catch (Exception e) {
                            trx.rollback();
                            logger.log(Level.WARNING, e.getLocalizedMessage(), (Throwable)e);
                            trx.close();
                            break block19;
                        }
                    }
                    catch (Throwable throwable) {
                        trx.close();
                        throw throwable;
                    }
                    trx.close();
                }
            }
            Collections.sort(list, new Comparator<TwoPackEntry>(){

                @Override
                public int compare(TwoPackEntry o1, TwoPackEntry o2) {
                    return new Version(o1.version).compareTo(new Version(o2.version));
                }
            });
            try {
                try {
                    if (this.getDBLock()) {
                        for (TwoPackEntry entry : list) {
                            if (installedVersions.contains(entry.version) || this.packIn(entry.url)) continue;
                            break block20;
                        }
                        break block20;
                    }
                    logger.log(Level.WARNING, "Could not acquire the DB lock to install:" + this.getName());
                }
                catch (AdempiereSystemError e) {
                    e.printStackTrace();
                    this.releaseLock();
                }
            }
            finally {
                this.releaseLock();
            }
        }
    }

    private String extractVersionString(URL u) {
        String p = u.getPath();
        int upos = p.lastIndexOf("2Pack_");
        int dpos = p.lastIndexOf(".");
        String v = p.substring(upos + "2Pack_".length(), dpos);
        return v;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean packIn(URL packout) {
        FileOutputStream zipstream;
        block17: {
            if (packout == null) return true;
            if (this.service == null) return true;
            MSession.get((Properties)Env.getCtx(), (boolean)true);
            String path = packout.getPath();
            String suffix = "_" + path.substring(path.lastIndexOf("2Pack_"));
            logger.log(Level.WARNING, "Installing " + this.getName() + " " + path + " ...");
            zipstream = null;
            try {
                InputStream stream = packout.openStream();
                File zipfile = File.createTempFile(String.valueOf(this.getName()) + "_", suffix);
                zipstream = new FileOutputStream(zipfile);
                byte[] buffer = new byte[1024];
                while (true) {
                    int read;
                    if ((read = stream.read(buffer)) == -1) {
                        if (this.merge(zipfile, this.extractVersionString(packout))) break block17;
                        if (zipstream == null) return false;
                        break;
                    }
                    zipstream.write(buffer, 0, read);
                }
            }
            catch (Throwable e) {
                try {
                    logger.log(Level.WARNING, "Pack in failed.", e);
                    return false;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (zipstream != null) {
                        try {
                            zipstream.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            try {
                zipstream.close();
                return false;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        if (zipstream != null) {
            try {
                zipstream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        logger.log(Level.WARNING, String.valueOf(this.getName()) + " " + packout.getPath() + " installed");
        return true;
    }

    protected BundleContext getContext() {
        return this.context;
    }

    protected void setContext(BundleContext context) {
        this.context = context;
    }

    public void stop(BundleContext context) throws Exception {
        this.stop();
        this.serviceTracker.close();
        this.context = null;
        if (logger.isLoggable(Level.INFO)) {
            logger.info(String.valueOf(context.getBundle().getSymbolicName()) + " " + (String)context.getBundle().getHeaders().get("Bundle-Version") + " stopped.");
        }
    }

    protected void afterPackIn() {
    }

    protected void start() {
    }

    protected void stop() {
    }

    public IDictionaryService addingService(ServiceReference<IDictionaryService> reference) {
        this.service = (IDictionaryService)this.context.getService(reference);
        if (Adempiere.getThreadPoolExecutor() != null) {
            Adempiere.getThreadPoolExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    try {
                        Thread.currentThread().setContextClassLoader(Incremental2PackActivator.class.getClassLoader());
                        Incremental2PackActivator.this.setupPackInContext();
                        Incremental2PackActivator.this.installPackage();
                    }
                    finally {
                        ServerContext.dispose();
                        Incremental2PackActivator.this.service = null;
                        Thread.currentThread().setContextClassLoader(cl);
                    }
                }
            });
        } else {
            Adempiere.addServerStateChangeListener((ServerStateChangeListener)new ServerStateChangeListener(){

                public void stateChange(ServerStateChangeEvent event) {
                    if (event.getEventType() == 0 && Incremental2PackActivator.this.service != null) {
                        ClassLoader cl = Thread.currentThread().getContextClassLoader();
                        try {
                            Thread.currentThread().setContextClassLoader(Incremental2PackActivator.class.getClassLoader());
                            Incremental2PackActivator.this.setupPackInContext();
                            Incremental2PackActivator.this.installPackage();
                        }
                        finally {
                            ServerContext.dispose();
                            Incremental2PackActivator.this.service = null;
                            Thread.currentThread().setContextClassLoader(cl);
                        }
                    }
                }
            });
        }
        return null;
    }

    public void modifiedService(ServiceReference<IDictionaryService> reference, IDictionaryService service) {
    }

    public void removedService(ServiceReference<IDictionaryService> reference, IDictionaryService service) {
    }

    protected void setupPackInContext() {
        Properties serverContext = new Properties();
        serverContext.setProperty("#AD_Client_ID", "0");
        ServerContext.setCurrentInstance((Properties)serverContext);
    }

    private static class TwoPackEntry {
        private URL url;
        private String version;

        private TwoPackEntry(URL url, String version) {
            this.url = url;
            this.version = version;
        }
    }
}

