/*
 * Decompiled with CFR 0.152.
 */
package jpiere.plugin.matrixwindow.form;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jpiere.plugin.matrixwindow.base.IMatrixWindowCallout;
import jpiere.plugin.matrixwindow.base.IMatrixWindowCalloutFactory;
import org.adempiere.base.Service;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.event.ValueChangeListener;
import org.adempiere.webui.panel.CustomForm;
import org.compiere.model.GridField;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.zkoss.zul.ListModelMap;

public class JPMatrixDataBinder
implements ValueChangeListener {
    private static final CLogger logger = CLogger.getCLogger(JPMatrixDataBinder.class);
    private ListModelMap<Object, Object> viewModel;
    private ListModelMap<Object, Object> convetionTable;
    private HashMap<Integer, PO> tableModel;
    private HashMap<Integer, PO> dirtyModel;
    private HashMap<Integer, GridField> columnGridFieldMap;
    private HashMap<Integer, WEditor> columnEditorMap;
    private CustomForm form;

    public JPMatrixDataBinder(ListModelMap<Object, Object> listModel, ListModelMap<Object, Object> convetionTable, HashMap<Integer, PO> tableModel, HashMap<Integer, PO> dirtyModel, CustomForm form) {
        this.viewModel = listModel;
        this.convetionTable = convetionTable;
        this.tableModel = tableModel;
        this.dirtyModel = dirtyModel;
        this.form = form;
    }

    public ListModelMap<Object, Object> getViewModel() {
        return this.viewModel;
    }

    public ListModelMap<Object, Object> getConvetionTable() {
        return this.convetionTable;
    }

    public HashMap<Integer, PO> getTableModel() {
        return this.tableModel;
    }

    public HashMap<Integer, PO> getDirtyModel() {
        return this.dirtyModel;
    }

    public void setColumnGridFieldMap(HashMap<Integer, GridField> columnGridFieldMap) {
        this.columnGridFieldMap = columnGridFieldMap;
    }

    public HashMap<Integer, GridField> getColumnGridFieldMap() {
        return this.columnGridFieldMap;
    }

    public void setColumnEditorMap(HashMap<Integer, WEditor> columnEditorMap) {
        this.columnEditorMap = columnEditorMap;
    }

    public HashMap<Integer, WEditor> getColumnEditorMap() {
        return this.columnEditorMap;
    }

    public void valueChange(ValueChangeEvent e) {
        Object newValue = e.getNewValue();
        Object source = e.getSource();
        if (source instanceof WEditor) {
            WEditor editor = (WEditor)source;
            String[] yx = editor.getComponent().getId().split("_");
            int y = Integer.valueOf(yx[0]);
            int x = Integer.valueOf(yx[1]);
            Map.Entry viewModelRow = this.viewModel.getElementAt(y);
            TreeMap viewModelRowData = (TreeMap)viewModelRow.getValue();
            Object oldValue = viewModelRowData.get(x);
            viewModelRowData.put(x, newValue);
            editor.getGridField().setValue(newValue, false);
            Map.Entry conversionTableRow = this.convetionTable.getElementAt(y);
            TreeMap conversionTableRowData = (TreeMap)conversionTableRow.getValue();
            Object PO_ID = conversionTableRowData.get(x);
            PO po = this.tableModel.get(PO_ID);
            po.set_ValueNoCheck(editor.getColumnName(), newValue);
            this.dirtyModel.put((Integer)PO_ID, po);
            List factories = Service.locator().list(IMatrixWindowCalloutFactory.class).getServices();
            if (factories != null) {
                String calloutMessage = null;
                for (IMatrixWindowCalloutFactory factory : factories) {
                    IMatrixWindowCallout callout = factory.getCallout(po.get_TableName(), editor.getColumnName());
                    if (callout == null || (calloutMessage = callout.start(this, x, y, newValue, oldValue)) == null || calloutMessage.equals("")) continue;
                    this.getColumnGridFieldMap().get(0).getGridTab().fireDataStatusEEvent("Message", calloutMessage, false);
                    logger.saveError("Error", new Exception(calloutMessage));
                }
            }
        }
    }

    public void setValue(int x, int y, Object newValue) {
        WEditor editor = this.columnEditorMap.get(x);
        editor.setValue(newValue);
        Map.Entry viewModelRow = this.viewModel.getElementAt(y);
        TreeMap viewModelRowData = (TreeMap)viewModelRow.getValue();
        viewModelRowData.put(x, newValue);
        editor.getGridField().setValue(newValue, false);
        Map.Entry conversionTableRow = this.convetionTable.getElementAt(y);
        TreeMap conversionTableRowData = (TreeMap)conversionTableRow.getValue();
        Object PO_ID = conversionTableRowData.get(x);
        PO po = this.tableModel.get(PO_ID);
        po.set_ValueNoCheck(editor.getColumnName(), editor.getValue());
        this.dirtyModel.put((Integer)PO_ID, po);
    }
}

