/*
 * Decompiled with CFR 0.152.
 */
package jpiere.plugin.simpleinputwindow.form;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import javax.swing.table.AbstractTableModel;
import org.compiere.model.DataStatusEvent;
import org.compiere.model.DataStatusListener;
import org.compiere.model.GridField;
import org.compiere.model.PO;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.MSort;

public class SimpleInputWindowGridTable
extends AbstractTableModel {
    private int m_lastSortColumnIndex = -1;
    private boolean m_lastSortedAscending = true;
    private Properties m_ctx;
    private int m_AD_Table_ID;
    private int m_WindowNo;
    private volatile ArrayList<MSort> m_sort = new ArrayList(100);
    private int m_rowCount = 0;
    private boolean m_changed = false;
    private int m_rowChanged = -1;
    private boolean m_inserting = false;
    private ArrayList<PO> list_POs;
    private GridField[] gridFields;

    @Override
    public int getRowCount() {
        return this.list_POs.size();
    }

    @Override
    public int getColumnCount() {
        return this.gridFields.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        GridField gf = this.gridFields[columnIndex];
        return this.list_POs.get(rowIndex).get_Value(gf.getColumnName());
    }

    public Object getValueAt(int rowIndex, GridField gridField) {
        return this.list_POs.get(rowIndex).get_Value(gridField.getColumnName());
    }

    public Object getValueAt(int rowIndex, String columnName) {
        return this.list_POs.get(rowIndex).get_Value(columnName);
    }

    public ArrayList<PO> getPOs() {
        return this.list_POs;
    }

    public PO getPO(int rowIndex) {
        return this.list_POs.get(rowIndex);
    }

    public void removePO(int rowIndex) {
        this.list_POs.remove(rowIndex);
    }

    public void setPO(PO po) {
        this.list_POs.add(po);
    }

    public GridField[] getFields() {
        return this.gridFields;
    }

    public void init(ArrayList<PO> POs, GridField[] gridFields) {
        this.list_POs = POs;
        this.gridFields = gridFields;
    }

    public void setValueAt(Object value, int rowIndex, GridField gridField) {
        this.list_POs.get(rowIndex).set_ValueNoCheck(gridField.getColumnName(), value);
    }

    protected GridField getField(int index) {
        if (index < 0 || index >= this.gridFields.length) {
            return null;
        }
        return this.gridFields[index];
    }

    @Override
    public int findColumn(String columnName) {
        int i = 0;
        while (i < this.gridFields.length) {
            GridField field = this.gridFields[i];
            if (columnName.equals(field.getColumnName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void sort(int col, boolean ascending) {
        boolean isSameSortEntries;
        if (col < 0) {
            return;
        }
        if (this.getRowCount() == 0) {
            return;
        }
        boolean bl = isSameSortEntries = col == this.m_lastSortColumnIndex && ascending == this.m_lastSortedAscending;
        if (!isSameSortEntries) {
            this.m_lastSortColumnIndex = col;
            this.m_lastSortedAscending = ascending;
        }
        Object[] changedRow = this.m_rowChanged >= 0 ? this.getDataAtRow(this.m_rowChanged) : null;
        GridField field = this.getField(col);
        if (field.getDisplayType() == 26) {
            return;
        }
        boolean isLookup = DisplayType.isLookup((int)field.getDisplayType());
        boolean isASI = 35 == field.getDisplayType();
        int i = 0;
        while (i < this.m_sort.size()) {
            MSort sort = this.m_sort.get(i);
            Object[] rowData = this.getDataAtRow(i);
            sort.data = rowData[col] == null ? null : (isLookup || isASI ? field.getLookup().getDisplay(rowData[col]) : rowData[col]);
            ++i;
        }
        MSort sort = new MSort(0, null);
        sort.setSortAsc(ascending);
        Collections.sort(this.m_sort, sort);
        if (changedRow != null) {
            int cfr_ignored_0 = changedRow.length;
        }
        int i2 = 0;
        while (i2 < this.m_sort.size()) {
            this.m_sort.get((int)i2).data = null;
            ++i2;
        }
        if (!isSameSortEntries) {
            this.fireTableDataChanged();
            this.fireDataStatusIEvent("Sorted", "#" + this.m_sort.size());
        }
    }

    public void waitLoadingForRow(int row) {
    }

    private Object[] getDataAtRow(int row) {
        return this.getDataAtRow(row, true);
    }

    private Object[] getDataAtRow(int row, boolean fetchIfNotFound) {
        return null;
    }

    protected void fireDataStatusIEvent(String AD_Message, String info) {
        DataStatusEvent e = this.createDSE();
        e.setInfo(AD_Message, info, false, false);
        this.fireDataStatusChanged(e);
    }

    private void fireDataStatusChanged(DataStatusEvent e) {
        DataStatusListener[] listeners = (DataStatusListener[])this.listenerList.getListeners(DataStatusListener.class);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].dataStatusChanged(e);
            ++i;
        }
    }

    private DataStatusEvent createDSE() {
        boolean changed = this.m_changed;
        if (this.m_rowChanged != -1) {
            changed = true;
        }
        DataStatusEvent dse = new DataStatusEvent((Object)this, this.m_rowCount, changed, Env.isAutoCommit((Properties)this.m_ctx, (int)this.m_WindowNo), this.m_inserting);
        dse.AD_Table_ID = this.m_AD_Table_ID;
        dse.Record_ID = null;
        return dse;
    }
}

