/*
 * Decompiled with CFR 0.152.
 */
package jpiere.plugin.simpleinputwindow.callout;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.Properties;
import jpiere.plugin.simpleinputwindow.base.ISimpleInputWindowCallout;
import jpiere.plugin.simpleinputwindow.form.SimpleInputWindowDataBinder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPriceList;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPricing;
import org.compiere.model.MStorageReservation;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class SIWCalloutOrderProduct
implements ISimpleInputWindowCallout {
    @Override
    public String start(SimpleInputWindowDataBinder dataBinder, int rowIndex, String ColumnName, Object newValue, Object oldValue) {
        String sql;
        Integer M_Product_ID = (Integer)newValue;
        if (M_Product_ID == null || M_Product_ID == 0) {
            return "";
        }
        int WindowNo = dataBinder.getSimpleInputWindow().getGridTab().getWindowNo();
        Properties ctx = Env.getCtx();
        int tabNo = dataBinder.getSimpleInputWindow().getGridTab().getTabNo();
        dataBinder.setValue(rowIndex, "C_Charge_ID", null);
        if (Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)1113, (String)"M_Product_ID") == M_Product_ID && Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)1113, (String)"M_AttributeSetInstance_ID") != 0) {
            dataBinder.setValue(rowIndex, "M_AttributeSetInstance_ID", Env.getContextAsInt((Properties)Env.getCtx(), (int)WindowNo, (int)1113, (String)"M_AttributeSetInstance_ID"));
        } else {
            dataBinder.setValue(rowIndex, "M_AttributeSetInstance_ID", null);
        }
        int C_BPartner_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"C_BPartner_ID");
        BigDecimal Qty = (BigDecimal)dataBinder.getValue(rowIndex, "QtyOrdered");
        boolean IsSOTrx = Env.getContext((Properties)ctx, (int)WindowNo, (String)"IsSOTrx").equals("Y");
        MProductPricing pp = new MProductPricing(M_Product_ID.intValue(), C_BPartner_ID, Qty, IsSOTrx);
        int M_PriceList_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"M_PriceList_ID");
        pp.setM_PriceList_ID(M_PriceList_ID);
        Timestamp orderDate = (Timestamp)dataBinder.getValue(rowIndex, "DateOrdered");
        int M_PriceList_Version_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"M_PriceList_Version_ID");
        if (M_PriceList_Version_ID == 0 && M_PriceList_ID > 0 && (M_PriceList_Version_ID = DB.getSQLValueEx(null, (String)(sql = "SELECT plv.M_PriceList_Version_ID FROM M_PriceList_Version plv WHERE plv.M_PriceList_ID=?  AND plv.ValidFrom <= ? ORDER BY plv.ValidFrom DESC"), (Object[])new Object[]{M_PriceList_ID, orderDate})) > 0) {
            Env.setContext((Properties)ctx, (int)WindowNo, (String)"M_PriceList_Version_ID", (int)M_PriceList_Version_ID);
        }
        pp.setM_PriceList_Version_ID(M_PriceList_Version_ID);
        pp.setPriceDate(orderDate);
        dataBinder.setValue(rowIndex, "PriceList", pp.getPriceList());
        dataBinder.setValue(rowIndex, "PriceLimit", pp.getPriceLimit());
        dataBinder.setValue(rowIndex, "PriceActual", pp.getPriceStd());
        dataBinder.setValue(rowIndex, "PriceEntered", pp.getPriceStd());
        dataBinder.setValue(rowIndex, "C_Currency_ID", pp.getC_Currency_ID());
        dataBinder.setValue(rowIndex, "Discount", pp.getDiscount());
        dataBinder.setValue(rowIndex, "C_UOM_ID", pp.getC_UOM_ID());
        dataBinder.setValue(rowIndex, "QtyOrdered", dataBinder.getValue(rowIndex, "QtyEntered"));
        Env.setContext((Properties)ctx, (int)WindowNo, (String)"EnforcePriceLimit", (String)(pp.isEnforcePriceLimit() ? "Y" : "N"));
        Env.setContext((Properties)ctx, (int)WindowNo, (String)"DiscountSchema", (String)(pp.isDiscountSchema() ? "Y" : "N"));
        int StdPrecision = MPriceList.getStandardPrecision((Properties)ctx, (int)M_PriceList_ID);
        BigDecimal LineNetAmt = ((BigDecimal)dataBinder.getValue(rowIndex, "QtyEntered")).multiply(pp.getPriceStd());
        if (LineNetAmt.scale() > StdPrecision) {
            LineNetAmt = LineNetAmt.setScale(StdPrecision, RoundingMode.HALF_UP);
        }
        dataBinder.setValue(rowIndex, "LineNetAmt", LineNetAmt);
        if (Env.isSOTrx((Properties)ctx, (int)WindowNo)) {
            MProduct product = MProduct.get((Properties)ctx, (int)M_Product_ID);
            String obj = Env.getContext((Properties)Env.getCtx(), (int)WindowNo, (String)"IsDropShip");
            if (product.isStocked() && Env.getContext((Properties)Env.getCtx(), (int)WindowNo, (String)"IsDropShip").equals("N")) {
                BigDecimal total;
                BigDecimal notReserved;
                BigDecimal QtyOrdered = (BigDecimal)dataBinder.getValue(rowIndex, "QtyOrdered");
                int M_Warehouse_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"M_Warehouse_ID");
                int M_AttributeSetInstance_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)dataBinder.getSimpleInputWindow().getGridTab().getTabNo(), (String)"M_AttributeSetInstance_ID");
                BigDecimal available = MStorageReservation.getQtyAvailable((int)M_Warehouse_ID, (int)M_Product_ID, (int)M_AttributeSetInstance_ID, null);
                if (available == null) {
                    available = Env.ZERO;
                }
                if (available.signum() == 0) {
                    return Msg.getMsg((Properties)ctx, (String)"NoQtyAvailable");
                }
                if (available.compareTo(QtyOrdered) < 0) {
                    return Msg.getMsg((Properties)ctx, (String)"InsufficientQtyAvailable");
                }
                Integer C_OrderLine_ID = (Integer)dataBinder.getValue(rowIndex, "C_OrderLine_ID");
                if (C_OrderLine_ID == null) {
                    C_OrderLine_ID = 0;
                }
                if ((notReserved = MOrderLine.getNotReserved((Properties)ctx, (int)M_Warehouse_ID, (int)M_Product_ID, (int)M_AttributeSetInstance_ID, (int)C_OrderLine_ID)) == null) {
                    notReserved = Env.ZERO;
                }
                if ((total = available.subtract(notReserved)).compareTo(QtyOrdered) < 0) {
                    String info = Msg.parseTranslation((Properties)ctx, (String)("@QtyAvailable@=" + available + " - @QtyNotReserved@=" + notReserved + " = " + total));
                    return String.valueOf(Msg.getMsg((Properties)ctx, (String)"InsufficientQtyAvailable")) + info;
                }
            }
        }
        return "";
    }
}

