/*
 * Decompiled with CFR 0.152.
 */
package jpiere.plugin.delete.process;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.DBException;
import org.adempiere.util.IProcessUI;
import org.adempiere.util.ProcessUtil;
import org.compiere.db.AdempiereDatabase;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.Util;

public class JPiereInitializeDefaultAccountOnly
extends SvrProcess {
    private int p_LookupClientID = 0;
    private ArrayList<Integer> defaultAccount_List = new ArrayList();
    private String message = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("LookupClientID")) {
                this.p_LookupClientID = para[i].getParameterAsInt();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        int AD_User_ID = Env.getAD_User_ID((Properties)Env.getCtx());
        if (AD_User_ID == 100) {
            this.message = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Delete_SuperUser_CanNot");
            this.addLog(this.message);
            return this.message;
        }
        if (this.p_LookupClientID == 0) {
            MClient client = new MClient(this.getCtx(), 0, null);
            this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"DeleteError")) + " " + client.getName() + " " + Msg.getElement((Properties)this.getCtx(), (String)"AD_Client_ID");
            this.addLog(this.message);
            return this.message;
        }
        MClient m_Client = MClient.get((Properties)this.getCtx(), (int)this.p_LookupClientID);
        if (Util.isEmpty((String)m_Client.getName())) {
            this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"NoRecordID")) + " : " + "AD_Client_ID = " + this.p_LookupClientID;
            this.addLog(this.message);
            return this.message;
        }
        try {
            try {
                this.executeUpdateConstraint("D");
                this.commitEx();
                this.doAcctSchemaDefaultCopy();
                this.doAcctProductCategoryAcctCopy();
                this.doBPGroupAcctCopyAcctCopy();
                this.deletePA_Report_Tables();
                this.deleteC_Charge_Tables();
                this.deleteC_SubAcct_Tables();
                this.getAcctSchemaElementAccounts();
                this.getDefaultGLAccounts();
                this.getDefaultAccounts();
                this.deleteC_ValidCombination();
                this.deleteTreeNode();
                this.deleteC_ElementValue();
                this.updateBankAccountInfo();
            }
            catch (Exception e) {
                if (e instanceof DBException) {
                    DBException dbe = (DBException)e;
                    this.addLog(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + " SQL: " + dbe.getSQL());
                    this.addLog(dbe.toString());
                } else {
                    this.addLog(e.toString());
                }
                throw new Exception(String.valueOf(e.toString()) + this.message.toString());
            }
        }
        finally {
            this.executeUpdateConstraint("O");
            this.commitEx();
        }
        return Msg.getMsg((Properties)this.getCtx(), (String)"Success");
    }

    private int executeUpdateConstraint(String s) {
        if (s.equals("D")) {
            this.addLog("### INVALID FK CONSTRAINT ###");
        } else if (s.equals("O")) {
            this.addLog("### VALID FK CONSTRAINT ###");
        } else {
            return -1;
        }
        AdempiereDatabase adempiereDB = DB.getDatabase();
        String schemaName = adempiereDB.getSchema();
        String updateConstraintSQL = "update pg_trigger set tgenabled = ? where oid in (  select tr.oid from pg_class cl, pg_trigger tr, pg_namespace ns    where tr.tgrelid = cl.oid      and cl.relnamespace = ns.oid     and ns.nspname = ?)";
        CPreparedStatement pstmt = null;
        Object rs = null;
        int updates = 0;
        try {
            try {
                pstmt = DB.prepareStatement((String)updateConstraintSQL, (String)this.get_TrxName());
                pstmt.setString(1, s);
                pstmt.setString(2, schemaName);
                updates = pstmt.executeUpdate();
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, updateConstraintSQL, (Throwable)e);
                throw new DBException(e, updateConstraintSQL);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return updates;
    }

    private boolean doAcctSchemaDefaultCopy() {
        ProcessInfo pi = new ProcessInfo("OverWrite Default Account", 0);
        String className = "org.compiere.process.AcctSchemaDefaultCopy";
        pi.setClassName(className);
        pi.setAD_Client_ID(this.getAD_Client_ID());
        pi.setAD_User_ID(this.getAD_User_ID());
        pi.setAD_PInstance_ID(this.getAD_PInstance_ID());
        MAcctSchema[] acctSchemas = MAcctSchema.getClientAcctSchema((Properties)this.getCtx(), (int)this.p_LookupClientID);
        int i = 0;
        while (i < acctSchemas.length) {
            ArrayList<ProcessInfoParameter> list = new ArrayList<ProcessInfoParameter>();
            list.add(new ProcessInfoParameter("C_AcctSchema_ID", (Object)acctSchemas[i].getC_AcctSchema_ID(), null, null, null));
            list.add(new ProcessInfoParameter("CopyOverwriteAcct", (Object)"Y", null, null, null));
            ProcessInfoParameter[] pars = new ProcessInfoParameter[list.size()];
            list.toArray(pars);
            pi.setParameter(pars);
            if (this.processUI == null) {
                this.processUI = Env.getProcessUI((Properties)this.getCtx());
            }
            boolean bl = ProcessUtil.startJavaProcess((Properties)this.getCtx(), (ProcessInfo)pi, (Trx)Trx.get((String)this.get_TrxName(), (boolean)true), (boolean)false, (IProcessUI)this.processUI);
            ++i;
        }
        return true;
    }

    private boolean doAcctProductCategoryAcctCopy() {
        ProcessInfo pi = new ProcessInfo("OverWrite Default Product Account", 0);
        String className = "org.compiere.process.ProductCategoryAcctCopy";
        pi.setClassName(className);
        pi.setAD_Client_ID(this.getAD_Client_ID());
        pi.setAD_User_ID(this.getAD_User_ID());
        pi.setAD_PInstance_ID(this.getAD_PInstance_ID());
        MAcctSchema[] acctSchemas = MAcctSchema.getClientAcctSchema((Properties)this.getCtx(), (int)this.p_LookupClientID);
        int i = 0;
        while (i < acctSchemas.length) {
            int[] M_ProductCategory_IDs = PO.getAllIDs((String)"M_Product_Category", (String)(" AD_Client_ID=" + this.p_LookupClientID), (String)this.get_TrxName());
            int j = 0;
            while (j < M_ProductCategory_IDs.length) {
                ArrayList<ProcessInfoParameter> list = new ArrayList<ProcessInfoParameter>();
                list.add(new ProcessInfoParameter("C_AcctSchema_ID", (Object)acctSchemas[i].getC_AcctSchema_ID(), null, null, null));
                list.add(new ProcessInfoParameter("M_Product_Category_ID", (Object)M_ProductCategory_IDs[j], null, null, null));
                ProcessInfoParameter[] pars = new ProcessInfoParameter[list.size()];
                list.toArray(pars);
                pi.setParameter(pars);
                if (this.processUI == null) {
                    this.processUI = Env.getProcessUI((Properties)this.getCtx());
                }
                boolean bl = ProcessUtil.startJavaProcess((Properties)this.getCtx(), (ProcessInfo)pi, (Trx)Trx.get((String)this.get_TrxName(), (boolean)true), (boolean)false, (IProcessUI)this.processUI);
                ++j;
            }
            ++i;
        }
        return true;
    }

    private boolean doBPGroupAcctCopyAcctCopy() {
        ProcessInfo pi = new ProcessInfo("OverWrite Default BP Account", 0);
        String className = "org.compiere.process.BPGroupAcctCopy";
        pi.setClassName(className);
        pi.setAD_Client_ID(this.getAD_Client_ID());
        pi.setAD_User_ID(this.getAD_User_ID());
        pi.setAD_PInstance_ID(this.getAD_PInstance_ID());
        MAcctSchema[] acctSchemas = MAcctSchema.getClientAcctSchema((Properties)this.getCtx(), (int)this.p_LookupClientID);
        int i = 0;
        while (i < acctSchemas.length) {
            int[] C_BP_Group_IDs = PO.getAllIDs((String)"C_BP_Group", (String)(" AD_Client_ID=" + this.p_LookupClientID), (String)this.get_TrxName());
            int j = 0;
            while (j < C_BP_Group_IDs.length) {
                ArrayList<ProcessInfoParameter> list = new ArrayList<ProcessInfoParameter>();
                list.add(new ProcessInfoParameter("C_AcctSchema_ID", (Object)acctSchemas[i].getC_AcctSchema_ID(), null, null, null));
                list.add(new ProcessInfoParameter("C_BP_Group_ID", (Object)C_BP_Group_IDs[j], null, null, null));
                ProcessInfoParameter[] pars = new ProcessInfoParameter[list.size()];
                list.toArray(pars);
                pi.setParameter(pars);
                if (this.processUI == null) {
                    this.processUI = Env.getProcessUI((Properties)this.getCtx());
                }
                boolean bl = ProcessUtil.startJavaProcess((Properties)this.getCtx(), (ProcessInfo)pi, (Trx)Trx.get((String)this.get_TrxName(), (boolean)true), (boolean)false, (IProcessUI)this.processUI);
                ++j;
            }
            ++i;
        }
        return true;
    }

    private boolean deletePA_Report_Tables() {
        String[] PA_Report_Tables = new String[]{"PA_Report", "PA_ReportLineSet", "PA_ReportLine", "PA_ReportSource", "PA_ReportColumnSet", "PA_ReportColumn", "PA_ReportCube", "PA_Hierarchy"};
        int i = 0;
        while (i < PA_Report_Tables.length) {
            this.executeDeleteSQL(PA_Report_Tables[i], null);
            ++i;
        }
        return true;
    }

    private boolean deleteC_Charge_Tables() {
        String[] C_Charge_Tables = new String[]{"C_Charge", "C_Charge_Acct", "C_Charge_Trl", "C_ChargeType", "C_ChargeType_DocType"};
        int i = 0;
        while (i < C_Charge_Tables.length) {
            this.executeDeleteSQL(C_Charge_Tables[i], null);
            ++i;
        }
        return true;
    }

    private boolean deleteC_SubAcct_Tables() {
        String[] C_SubAcct_Tables = new String[]{"C_SubAcct"};
        int i = 0;
        while (i < C_SubAcct_Tables.length) {
            this.executeDeleteSQL(C_SubAcct_Tables[i], null);
            ++i;
        }
        return true;
    }

    private void getAcctSchemaElementAccounts() {
        String[] AcctSchemaElement_Accounts = new String[]{"C_ElementValue_ID"};
        int i = 0;
        while (i < AcctSchemaElement_Accounts.length) {
            block7: {
                String sql = "SELECT ev.C_ElementValue_ID FROM C_AcctSchema_Element ae  INNER JOIN adempiere.C_ElementValue ev on (ev.C_ElementValue_ID = ae." + AcctSchemaElement_Accounts[i] + ") " + " WHERE ae.AD_Client_ID = ? ";
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                        pstmt.setInt(1, this.p_LookupClientID);
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            int account_ID = rs.getInt(1);
                            if (account_ID <= 0) continue;
                            this.defaultAccount_List.add(account_ID);
                        }
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, sql, (Throwable)e);
                        DB.close(rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            }
            ++i;
        }
    }

    private void getDefaultGLAccounts() {
        String[] defaultGLAccounts_Column = new String[]{"CommitmentOffsetSales_Acct", "CommitmentOffset_Acct", "CurrencyBalancing_Acct", "IncomeSummary_Acct", "IntercompanyDueFrom_Acct", "IntercompanyDueTo_Acct", "PPVOffset_Acct", "RetainedEarning_Acct", "SuspenseBalancing_Acct", "SuspenseError_Acct"};
        int i = 0;
        while (i < defaultGLAccounts_Column.length) {
            block7: {
                String sql = "SELECT vc.Account_ID FROM C_AcctSchema_GL gl  INNER JOIN adempiere.C_ValidCombination vc on (vc.C_ValidCombination_ID = gl." + defaultGLAccounts_Column[i] + ") " + " WHERE gl.AD_Client_ID = ? ";
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                        pstmt.setInt(1, this.p_LookupClientID);
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            int account_ID = rs.getInt(1);
                            if (account_ID <= 0) continue;
                            this.defaultAccount_List.add(account_ID);
                        }
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, sql, (Throwable)e);
                        DB.close(rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            }
            ++i;
        }
    }

    private void getDefaultAccounts() {
        String[] defaultAccounts_Column = new String[]{"B_Asset_Acct", "B_Expense_Acct", "B_InTransit_Acct", "B_InterestExp_Acct", "B_InterestRev_Acct", "B_PaymentSelect_Acct", "B_RevaluationGain_Acct", "B_RevaluationLoss_Acct", "B_SettlementGain_Acct", "B_SettlementLoss_Acct", "B_UnallocatedCash_Acct", "B_Unidentified_Acct", "CB_Asset_Acct", "CB_CashTransfer_Acct", "CB_Differences_Acct", "CB_Expense_Acct", "CB_Receipt_Acct", "C_Prepayment_Acct", "C_Receivable_Acct", "C_Receivable_Services_Acct", "Ch_Expense_Acct", "Ch_Revenue_Acct", "E_Expense_Acct", "E_Prepayment_Acct", "NotInvoicedReceipts_Acct", "NotInvoicedReceivables_Acct", "NotInvoicedRevenue_Acct", "PJ_Asset_Acct", "PJ_WIP_Acct", "P_Asset_Acct", "P_AverageCostVariance_Acct", "P_Burden_Acct", "P_COGS_Acct", "P_CostAdjustment_Acct", "P_CostOfProduction_Acct", "P_Expense_Acct", "P_FloorStock_Acct", "P_InventoryClearing_Acct", "P_InvoicePriceVariance_Acct", "P_Labor_Acct", "P_LandedCostClearing_Acct", "P_MethodChangeVariance_Acct", "P_MixVariance_Acct", "P_OutsideProcessing_Acct", "P_Overhead_Acct", "P_PurchasePriceVariance_Acct", "P_RateVariance_Acct", "P_Revenue_Acct", "P_Scrap_Acct", "P_TradeDiscountGrant_Acct", "P_TradeDiscountRec_Acct", "P_UsageVariance_Acct", "P_WIP_Acct", "PayDiscount_Exp_Acct", "PayDiscount_Rev_Acct", "RealizedGain_Acct", "RealizedLoss_Acct", "T_Credit_Acct", "T_Due_Acct", "T_Expense_Acct", "T_Liability_Acct", "T_Receivables_Acct", "UnEarnedRevenue_Acct", "UnrealizedGain_Acct", "UnrealizedLoss_Acct", "V_Liability_Acct", "V_Liability_Services_Acct", "V_Prepayment_Acct", "W_Differences_Acct", "W_InvActualAdjust_Acct", "W_Inventory_Acct", "W_Revaluation_Acct", "Withholding_Acct", "WriteOff_Acct"};
        int i = 0;
        while (i < defaultAccounts_Column.length) {
            block7: {
                String sql = "SELECT vc.Account_ID FROM C_AcctSchema_Default df  INNER JOIN adempiere.C_ValidCombination vc on (vc.C_ValidCombination_ID = df." + defaultAccounts_Column[i] + ") " + " WHERE df.AD_Client_ID = ? ";
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                        pstmt.setInt(1, this.p_LookupClientID);
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            int account_ID = rs.getInt(1);
                            if (account_ID <= 0) continue;
                            this.defaultAccount_List.add(account_ID);
                        }
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, sql, (Throwable)e);
                        DB.close(rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            }
            ++i;
        }
    }

    private boolean deleteC_ValidCombination() {
        StringBuilder where = new StringBuilder(" Account_ID NOT IN ( ");
        int i = 0;
        for (Integer account_ID : this.defaultAccount_List) {
            if (i == 0) {
                where.append(String.valueOf(account_ID));
            } else {
                where.append(",").append(String.valueOf(account_ID));
            }
            ++i;
        }
        where.append(")");
        this.executeDeleteSQL("C_ValidCombination", where.toString());
        return true;
    }

    private boolean deleteTreeNode() {
        StringBuilder deleteSQL = new StringBuilder("DELETE FROM AD_TreeNode tn USING AD_Tree t WHERE tn.AD_Tree_ID = t.AD_Tree_ID AND t.treetype = 'EV' AND tn.Node_ID NOT IN ( ");
        int i = 0;
        for (Integer account_ID : this.defaultAccount_List) {
            if (i == 0) {
                deleteSQL.append(String.valueOf(account_ID));
            } else {
                deleteSQL.append(",").append(String.valueOf(account_ID));
            }
            ++i;
        }
        deleteSQL.append(")");
        deleteSQL.append(" AND tn.AD_Client_ID = " + this.p_LookupClientID);
        CPreparedStatement pstmt = null;
        Object rs = null;
        int deletes = 0;
        try {
            try {
                pstmt = DB.prepareStatement((String)deleteSQL.toString(), (String)this.get_TrxName());
                deletes = pstmt.executeUpdate();
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, deleteSQL.toString(), (Throwable)e);
                throw new DBException(e, deleteSQL.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        StringBuilder updateSQL = new StringBuilder("UPDATE AD_TreeNode tn set Parent_ID = 0 FROM AD_Tree t WHERE tn.AD_Tree_ID = t.AD_Tree_ID AND t.treetype = 'EV' ");
        updateSQL.append(" AND tn.AD_Client_ID = " + this.p_LookupClientID);
        int updates = 0;
        try {
            try {
                pstmt = DB.prepareStatement((String)updateSQL.toString(), (String)this.get_TrxName());
                updates = pstmt.executeUpdate();
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, updateSQL.toString(), (Throwable)e);
                throw new DBException(e, updateSQL.toString());
            }
        }
        finally {
            DB.close(rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return true;
    }

    private boolean deleteC_ElementValue() {
        StringBuilder where = new StringBuilder(" C_ElementValue_ID NOT IN ( ");
        int i = 0;
        for (Integer account_ID : this.defaultAccount_List) {
            if (i == 0) {
                where.append(String.valueOf(account_ID));
            } else {
                where.append(",").append(String.valueOf(account_ID));
            }
            ++i;
        }
        where.append(")");
        this.executeDeleteSQL("C_ElementValue", where.toString());
        this.executeDeleteSQL("C_ElementValue_Trl", where.toString());
        return true;
    }

    private boolean updateBankAccountInfo() {
        StringBuilder updateSQL = new StringBuilder("UPDATE C_ElementValue ev set C_BankAccount_ID = NULL ");
        updateSQL.append(" WHERE ev.AD_Client_ID = " + this.p_LookupClientID);
        CPreparedStatement pstmt = null;
        Object rs = null;
        int updates = 0;
        try {
            try {
                pstmt = DB.prepareStatement((String)updateSQL.toString(), (String)this.get_TrxName());
                updates = pstmt.executeUpdate();
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, updateSQL.toString(), (Throwable)e);
                throw new DBException(e, updateSQL.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return true;
    }

    private boolean executeDeleteSQL(String table, String where) {
        StringBuilder DeleteSQL = new StringBuilder();
        DeleteSQL.append("DELETE FROM " + table);
        if (Util.isEmpty((String)where)) {
            DeleteSQL.append(" WHERE AD_Client_ID = " + this.p_LookupClientID);
        } else {
            DeleteSQL.append(" WHERE " + where).append(" AND AD_Client_ID = " + this.p_LookupClientID);
        }
        CPreparedStatement pstmt = null;
        Object rs = null;
        int deletes = 0;
        try {
            try {
                pstmt = DB.prepareStatement((String)DeleteSQL.toString(), (String)this.get_TrxName());
                deletes = pstmt.executeUpdate();
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, DeleteSQL.toString(), (Throwable)e);
                throw new DBException(e, DeleteSQL.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return true;
    }
}

