/*
 * Decompiled with CFR 0.152.
 */
package jpiere.plugin.delete.process;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.plugin.delete.model.MCustomDeleteProfile;
import jpiere.plugin.delete.model.MCustomDeleteProfileLine;
import jpiere.plugin.delete.process.JPiereDeleteClientRecords;
import org.adempiere.exceptions.DBException;
import org.compiere.model.MColumn;
import org.compiere.model.MTable;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class JPiereCreateDeleteProfileLine
extends SvrProcess {
    private int p_JP_CustomDeleteProfile_ID = 0;
    private JPiereDeleteClientRecords deleteClientRecordsProcess;

    protected void prepare() {
        this.p_JP_CustomDeleteProfile_ID = this.getRecord_ID();
        this.deleteClientRecordsProcess = new JPiereDeleteClientRecords();
    }

    protected String doIt() throws Exception {
        MCustomDeleteProfile customDeleteProfile = new MCustomDeleteProfile(this.getCtx(), this.p_JP_CustomDeleteProfile_ID, null);
        String treat = customDeleteProfile.getJP_TreatForeignKey();
        if (customDeleteProfile.getCustomDeleteProfileLines().length != 0) {
            String msg = Msg.getElement((Properties)this.getCtx(), (String)"JP_Delete_AlreadySomeLines");
            throw new Exception(msg);
        }
        MTable parent_Table = MTable.get((Properties)this.getCtx(), (String)customDeleteProfile.getAD_Table().getTableName());
        if (parent_Table.get_ID() == 0) {
            return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"NotFound")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_Table_ID");
        }
        String getTableSQL = "SELECT UPPER(TableName) FROM AD_Table t INNER JOIN AD_Column c ON(t.AD_Table_ID = C.AD_Table_ID) WHERE IsView='N' and UPPER(ColumnName)=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        int seqNo = 0;
        try {
            try {
                pstmt = DB.prepareStatement((String)getTableSQL, (String)this.get_TrxName());
                pstmt.setString(1, (String.valueOf(parent_Table.getTableName()) + "_ID").toUpperCase());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    MTable table;
                    if (rs.getString(1).equals(parent_Table.getTableName().toUpperCase()) || (table = MTable.get((Properties)this.getCtx(), (String)rs.getString(1))).get_ID() == 0 || table.getAccessLevel().equals(String.valueOf(4))) continue;
                    MColumn[] columns = table.getColumns(false);
                    MColumn col = null;
                    int i = 0;
                    while (i < columns.length) {
                        if (columns[i].getColumnName().toUpperCase().equals((String.valueOf(parent_Table.getTableName()) + "_ID").toUpperCase())) {
                            col = MColumn.get((Properties)this.getCtx(), (int)columns[i].get_ID());
                            break;
                        }
                        ++i;
                    }
                    if (col == null) continue;
                    MCustomDeleteProfileLine cdpl = new MCustomDeleteProfileLine(this.getCtx(), 0, null);
                    cdpl.setJP_CustomDeleteProfile_ID(customDeleteProfile.get_ID());
                    cdpl.setSeqNo(seqNo += 10);
                    cdpl.setAD_Table_ID(table.get_ID());
                    cdpl.setAD_Column_ID(col.getAD_Column_ID());
                    cdpl.setJP_TreatForeignKey(this.deleteClientRecordsProcess.treatAutoJudge(table.getTableName(), col.getColumnName(), treat, customDeleteProfile.getJP_ForeignKey_Value()));
                    cdpl.setJP_ForeignKey_Value(customDeleteProfile.getJP_ForeignKey_Value());
                    cdpl.saveEx();
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, getTableSQL.toString(), (Throwable)e);
                throw new DBException(e, getTableSQL.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        ArrayList<Integer> list_of_reference = this.deleteClientRecordsProcess.getReferenceList(parent_Table.getTableName());
        if (list_of_reference.size() != 0) {
            ArrayList<JPiereDeleteClientRecords.TableColumn> tableColumnList = this.deleteClientRecordsProcess.getIndirectReferTableColumn(String.valueOf(parent_Table.getTableName()) + "_ID", list_of_reference);
            for (JPiereDeleteClientRecords.TableColumn tableColumn : tableColumnList) {
                MTable table = MTable.get((Properties)this.getCtx(), (String)tableColumn.tableName);
                if (table.get_ID() == 0 || table.getAccessLevel().equals(String.valueOf(4))) continue;
                MColumn[] columns = table.getColumns(false);
                MColumn col = null;
                int i = 0;
                while (i < columns.length) {
                    if (columns[i].getColumnName().toUpperCase().equals(tableColumn.columnName.toUpperCase())) {
                        col = MColumn.get((Properties)this.getCtx(), (int)columns[i].get_ID());
                        break;
                    }
                    ++i;
                }
                if (col == null) continue;
                MCustomDeleteProfileLine cdpl = new MCustomDeleteProfileLine(this.getCtx(), 0, null);
                cdpl.setJP_CustomDeleteProfile_ID(customDeleteProfile.get_ID());
                cdpl.setSeqNo(seqNo += 10);
                cdpl.setAD_Table_ID(table.get_ID());
                cdpl.setAD_Column_ID(col.getAD_Column_ID());
                cdpl.setJP_TreatForeignKey(this.deleteClientRecordsProcess.treatAutoJudge(table.getTableName(), col.getColumnName(), treat, customDeleteProfile.getJP_ForeignKey_Value()));
                cdpl.setJP_ForeignKey_Value(customDeleteProfile.getJP_ForeignKey_Value());
                cdpl.saveEx();
            }
        }
        return "";
    }
}

