/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.BindUtils;
import org.zkoss.bind.Binder;
import org.zkoss.bind.Property;
import org.zkoss.bind.annotation.Destroy;
import org.zkoss.bind.impl.BindContextUtil;
import org.zkoss.bind.impl.BindEvaluatorXUtil;
import org.zkoss.bind.impl.BinderImpl;
import org.zkoss.bind.impl.MiscUtil;
import org.zkoss.bind.impl.ParamCall;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnnotatedMethodInvoker<T extends Annotation> {
    private static final Logger _log = LoggerFactory.getLogger(AbstractAnnotatedMethodInvoker.class);
    private final Map<Class<?>, List<Method>> annoMethodCache;
    private Class<T> annoClass;

    public AbstractAnnotatedMethodInvoker(Class<T> annoClass, Map<Class<?>, List<Method>> annoMethodCache) {
        this.annoClass = annoClass;
        this.annoMethodCache = annoMethodCache;
    }

    public boolean hasAnnotatedMethod(Binder binder) {
        Component rootComp = binder.getView();
        Object viewModel = rootComp.getAttribute("$VM$");
        Class<?> vmClz = BindUtils.getViewModelClass(viewModel);
        List<Method> methods = this.getAnnotateMethods(this.annoClass, vmClz);
        return !methods.isEmpty();
    }

    public void invokeMethod(Binder binder, Map<String, Object> bindingArgs) {
        this.invokeMethod(binder, bindingArgs, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeMethod(Binder binder, Map<String, Object> bindingArgs, Event triggeringEvent, boolean notifyChange) {
        Component rootComp = binder.getView();
        Object viewModel = rootComp.getAttribute("$VM$");
        Class<?> vmClz = BindUtils.getViewModelClass(viewModel);
        List<Method> methods = this.getAnnotateMethods(this.annoClass, vmClz);
        if (methods.size() == 0) {
            return;
        }
        if (bindingArgs != null) {
            bindingArgs = BindEvaluatorXUtil.evalArgs(binder.getEvaluatorX(), rootComp, bindingArgs);
        }
        Set<Property> changes = Collections.emptySet();
        if (notifyChange) {
            changes = new HashSet();
        }
        for (Method m : methods) {
            BindContext ctx = BindContextUtil.newBindContext(binder, null, false, null, rootComp, triggeringEvent);
            try {
                ParamCall parCall;
                ParamCall paramCall = parCall = binder instanceof BinderImpl ? ((BinderImpl)binder).createParamCall(ctx) : AbstractAnnotatedMethodInvoker.createParamCall(ctx, binder);
                if (bindingArgs != null) {
                    parCall.setBindingArgs(bindingArgs);
                }
                if (notifyChange) {
                    BinderImpl.handleNotifyChange(ctx, viewModel, m, parCall, changes);
                    continue;
                }
                parCall.call(viewModel, m);
            }
            catch (Exception e) {
                Map<Class<?>, List<Method>> map = this.annoMethodCache;
                synchronized (map) {
                    this.annoMethodCache.remove(vmClz);
                }
                throw UiException.Aide.wrap((Throwable)e, (String)e.getMessage());
            }
        }
        if (!changes.isEmpty() && binder instanceof BinderImpl) {
            ((BinderImpl)binder).fireNotifyChanges(changes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Method> getAnnotateMethods(Class<T> annotationClass, Class<?> vmClass) {
        List<Method> methods = null;
        Map<Class<?>, List<Method>> map = this.annoMethodCache;
        synchronized (map) {
            methods = this.annoMethodCache.get(vmClass);
            if (methods != null) {
                return methods;
            }
            methods = new ArrayList<Method>();
            Class<?> curr = vmClass;
            String sign = null;
            HashSet<String> signs = new HashSet<String>();
            while (curr != null && !curr.equals(Object.class)) {
                Method currm = null;
                T annotation = curr.getAnnotation(annotationClass);
                for (Method m : curr.getDeclaredMethods()) {
                    T i = m.getAnnotation(annotationClass);
                    if (i == null) continue;
                    if (annotation != null) {
                        throw new UiException("more than one [@" + annotationClass.getSimpleName() + "] in the class " + curr);
                    }
                    annotation = i;
                    currm = m;
                }
                if (currm != null) {
                    sign = MiscUtil.toSimpleMethodSignature(currm);
                    if (signs.contains(sign)) {
                        _log.warn("more than one {} method that has same signature '{}' in the hierarchy of '{}', the method in extended class will be call more than once ", new Object[]{annotationClass.getSimpleName(), sign, vmClass});
                    } else {
                        signs.add(sign);
                    }
                    if (annotation.annotationType() == Destroy.class) {
                        methods.add(currm);
                    } else {
                        methods.add(0, currm);
                    }
                }
                curr = annotation != null && this.shouldLookupSuperclass(annotation) ? curr.getSuperclass() : null;
            }
            methods = Collections.unmodifiableList(methods);
            this.annoMethodCache.put(vmClass, methods);
        }
        return methods;
    }

    protected abstract boolean shouldLookupSuperclass(T var1);

    private static ParamCall createParamCall(BindContext ctx, Binder binder) {
        Execution exec;
        ParamCall call = new ParamCall();
        call.setBinder(binder);
        call.setBindContext(ctx);
        Component comp = ctx.getComponent();
        if (comp != null) {
            call.setComponent(comp);
        }
        if ((exec = Executions.getCurrent()) != null) {
            call.setExecution(exec);
        }
        return call;
    }
}

