/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo2.AbstractElementHandler;
import org.adempiere.pipo2.Element;
import org.adempiere.pipo2.PIPOContext;
import org.adempiere.pipo2.PackOut;
import org.adempiere.pipo2.PoExporter;
import org.adempiere.pipo2.PoFiller;
import org.adempiere.pipo2.exception.DatabaseAccessException;
import org.adempiere.pipo2.exception.POSaveFailedException;
import org.compiere.model.MIndexColumn;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTableIndex;
import org.compiere.model.PO;
import org.compiere.model.X_AD_Package_Imp_Detail;
import org.compiere.process.TableIndexValidate;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class TableIndexElementHandler
extends AbstractElementHandler {
    private List<Integer> tableIndexes = new ArrayList<Integer>();

    /*
     * Enabled aggressive block sorting
     */
    public void startElement(PIPOContext ctx, Element element) throws SAXException {
        List excludes;
        PoFiller filler;
        List notfounds;
        String entitytype = this.getStringValue(element, "EntityType");
        if (!this.isProcessElement(ctx.ctx, entitytype)) {
            element.skip = true;
            return;
        }
        MTableIndex mTableIndex = (MTableIndex)this.findPO(ctx, element);
        if (mTableIndex == null) {
            mTableIndex = new MTableIndex(ctx.ctx, 0, this.getTrxName(ctx));
        }
        if ((notfounds = (filler = new PoFiller(ctx, (PO)mTableIndex, element, (AbstractElementHandler)this)).autoFill(excludes = this.defaultExcludeList("AD_TableIndex"))).size() > 0) {
            element.defer = true;
            element.unresolved = notfounds.toString();
            return;
        }
        if (!mTableIndex.is_new()) {
            if (!mTableIndex.is_Changed()) return;
        }
        X_AD_Package_Imp_Detail impDetail = this.createImportDetail(ctx, element.qName, "AD_TableIndex", 200085);
        String action = null;
        if (!mTableIndex.is_new()) {
            this.backupRecord(ctx, impDetail.getAD_Package_Imp_Detail_ID(), "AD_TableIndex", (PO)mTableIndex);
            action = "Update";
        } else {
            action = "New";
        }
        if (mTableIndex.save(this.getTrxName(ctx))) {
            this.logImportDetail(ctx, impDetail, 1, mTableIndex.getName(), mTableIndex.get_ID(), action);
            element.recordId = mTableIndex.getAD_TableIndex_ID();
            return;
        }
        this.logImportDetail(ctx, impDetail, 0, mTableIndex.getName(), mTableIndex.get_ID(), action);
        throw new POSaveFailedException("Failed to save AD_TableIndex " + mTableIndex.getName());
    }

    public void endElement(PIPOContext ctx, Element element) throws SAXException {
        MTableIndex mTableIndex = (MTableIndex)this.findPO(ctx, element);
        int success = this.validateTableIndex(ctx, mTableIndex);
        X_AD_Package_Imp_Detail dbDetail = this.createImportDetail(ctx, "dbIndex", "AD_TableIndex", 200085);
        if (success != 1) {
            this.logImportDetail(ctx, dbDetail, 0, mTableIndex.getName(), mTableIndex.get_ID(), "Validate");
            throw new DatabaseAccessException("Failed to validate AD_TableIndex for " + mTableIndex.getName());
        }
        this.logImportDetail(ctx, dbDetail, 1, mTableIndex.getName(), mTableIndex.get_ID(), "Validate");
    }

    private int validateTableIndex(PIPOContext ctx, MTableIndex tableIndex) {
        Trx trx = Trx.get((String)this.getTrxName(ctx), (boolean)true);
        if (MSysConfig.getBooleanValue((String)"2PACK_COMMIT_DDL", (boolean)false) && !trx.commit()) {
            return 0;
        }
        try {
            TableIndexValidate.validateTableIndex((Properties)ctx.ctx, (MTableIndex)tableIndex, (String)trx.getTrxName(), null);
            if (MSysConfig.getBooleanValue((String)"2PACK_COMMIT_DDL", (boolean)false)) {
                trx.commit(true);
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
            trx.rollback();
            return 0;
        }
        return 1;
    }

    public void create(PIPOContext ctx, TransformerHandler document) throws SAXException {
        MIndexColumn[] indexColumns;
        int AD_TableIndex_ID = Env.getContextAsInt((Properties)ctx.ctx, (String)"AD_TableIndex_ID");
        if (this.tableIndexes.contains(AD_TableIndex_ID)) {
            return;
        }
        this.tableIndexes.add(AD_TableIndex_ID);
        AttributesImpl atts = new AttributesImpl();
        MTableIndex m_TableIndex = new MTableIndex(ctx.ctx, AD_TableIndex_ID, null);
        boolean createElement = true;
        if (ctx.packOut.getFromDate() != null && m_TableIndex.getUpdated().compareTo(ctx.packOut.getFromDate()) < 0) {
            createElement = false;
        }
        if (createElement) {
            if (m_TableIndex.getAD_Message_ID() > 0) {
                try {
                    ctx.packOut.getHandler("AD_Message").packOut(ctx.packOut, document, ctx.logDocument, m_TableIndex.getAD_Message_ID());
                }
                catch (Exception e) {
                    throw new SAXException(e);
                }
            }
            this.verifyPackOutRequirement((PO)m_TableIndex);
            this.addTypeName(atts, "table");
            document.startElement("", "", "AD_TableIndex", atts);
            this.createTableIndexBinding(ctx, document, m_TableIndex);
        }
        MIndexColumn[] mIndexColumnArray = indexColumns = m_TableIndex.getColumns(true);
        int n = indexColumns.length;
        int n2 = 0;
        while (n2 < n) {
            MIndexColumn indexColumn = mIndexColumnArray[n2];
            this.createIndexColumn(ctx, document, indexColumn.getAD_IndexColumn_ID());
            ++n2;
        }
        if (createElement) {
            document.endElement("", "", "AD_TableIndex");
        }
    }

    private void createIndexColumn(PIPOContext ctx, TransformerHandler document, int AD_IndexColumn_ID) throws SAXException {
        try {
            ctx.packOut.getHandler("AD_IndexColumn").packOut(ctx.packOut, document, ctx.logDocument, AD_IndexColumn_ID);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    private void createTableIndexBinding(PIPOContext ctx, TransformerHandler document, MTableIndex m_TableIndex) {
        PoExporter filler = new PoExporter(ctx, document, (PO)m_TableIndex);
        List excludes = this.defaultExcludeList("AD_TableIndex");
        if (m_TableIndex.getAD_TableIndex_ID() <= 999999) {
            filler.add("AD_TableIndex_ID", new AttributesImpl());
        }
        filler.export(excludes);
    }

    public void packOut(PackOut packout, TransformerHandler packoutHandler, TransformerHandler docHandler, int recordId) throws Exception {
        Env.setContext((Properties)packout.getCtx().ctx, (String)"AD_TableIndex_ID", (int)recordId);
        this.create(packout.getCtx(), packoutHandler);
        packout.getCtx().ctx.remove("AD_TableIndex_ID");
    }
}

