/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2.handler;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo2.AbstractElementHandler;
import org.adempiere.pipo2.Element;
import org.adempiere.pipo2.PIPOContext;
import org.adempiere.pipo2.PackOut;
import org.adempiere.pipo2.PoExporter;
import org.adempiere.pipo2.PoFiller;
import org.adempiere.pipo2.exception.DatabaseAccessException;
import org.adempiere.pipo2.exception.POSaveFailedException;
import org.adempiere.pipo2.handler.FormAccessElementHandler;
import org.adempiere.pipo2.handler.InfoWindowAccessElementHandler;
import org.adempiere.pipo2.handler.OrgRoleElementHandler;
import org.adempiere.pipo2.handler.ProcessAccessElementHandler;
import org.adempiere.pipo2.handler.TaskAccessElementHandler;
import org.adempiere.pipo2.handler.WindowAccessElementHandler;
import org.adempiere.pipo2.handler.WorkflowAccessElementHandler;
import org.compiere.model.MRole;
import org.compiere.model.PO;
import org.compiere.model.X_AD_Package_Imp_Detail;
import org.compiere.model.X_AD_Role;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class RoleElementHandler
extends AbstractElementHandler {
    private OrgRoleElementHandler orgHandler = new OrgRoleElementHandler();
    private ProcessAccessElementHandler processHandler = new ProcessAccessElementHandler();
    private WindowAccessElementHandler windowHandler = new WindowAccessElementHandler();
    private FormAccessElementHandler formHandler = new FormAccessElementHandler();
    private TaskAccessElementHandler taskHandler = new TaskAccessElementHandler();
    private WorkflowAccessElementHandler workflowHandler = new WorkflowAccessElementHandler();
    private InfoWindowAccessElementHandler infoWindowHandler = new InfoWindowAccessElementHandler();

    public void startElement(PIPOContext ctx, Element element) throws SAXException {
        PoFiller filler;
        List notfounds;
        List excludes = this.defaultExcludeList("AD_Role");
        MRole mRole = (MRole)this.findPO(ctx, element);
        if (mRole == null) {
            mRole = new MRole(ctx.ctx, 0, this.getTrxName(ctx));
        }
        if ((notfounds = (filler = new PoFiller(ctx, (PO)mRole, element, (AbstractElementHandler)this)).autoFill(excludes)).size() > 0) {
            element.defer = true;
            element.unresolved = notfounds.toString();
            return;
        }
        if (mRole.is_new() || mRole.is_Changed()) {
            X_AD_Package_Imp_Detail impDetail = this.createImportDetail(ctx, element.qName, "AD_Role", 156);
            String action = null;
            action = !mRole.is_new() ? "Update" : "New";
            if (mRole.save(this.getTrxName(ctx))) {
                element.recordId = mRole.getAD_Role_ID();
                this.logImportDetail(ctx, impDetail, 1, mRole.getName(), mRole.get_ID(), action);
                element.requireRoleAccessUpdate = true;
            } else {
                this.logImportDetail(ctx, impDetail, 0, mRole.getName(), mRole.get_ID(), action);
                throw new POSaveFailedException("Failed to save Role " + mRole.getName());
            }
        }
    }

    public void endElement(PIPOContext ctx, Element element) throws SAXException {
    }

    public void create(PIPOContext ctx, TransformerHandler document) throws SAXException {
        int Role_id = Env.getContextAsInt((Properties)ctx.ctx, (String)"AD_Role_ID");
        if (ctx.packOut.isExported("AD_Role_ID|" + Role_id)) {
            return;
        }
        X_AD_Role m_Role = new X_AD_Role(ctx.ctx, Role_id, null);
        boolean createElement = this.isPackOutElement(ctx, (PO)m_Role);
        if (createElement) {
            this.verifyPackOutRequirement((PO)m_Role);
            AttributesImpl atts = new AttributesImpl();
            this.addTypeName(atts, "table");
            document.startElement("", "", "AD_Role", atts);
            this.createRoleBinding(ctx, document, m_Role);
        }
        String sql = "SELECT AD_Org_ID, AD_Role_ID FROM AD_Role_OrgAccess WHERE AD_Role_ID= " + Role_id;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, (String)this.getTrxName(ctx));
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    this.createOrgAccess(ctx, document, rs.getInt("AD_Org_ID"), rs.getInt("AD_Role_ID"));
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "AD_Role_OrgAccess", (Throwable)e);
                throw new DatabaseAccessException("Failed to export organization role access.");
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        sql = "SELECT AD_Window_ID, AD_Role_ID FROM AD_Window_Access WHERE AD_Role_ID= " + Role_id;
        pstmt = null;
        rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, (String)this.getTrxName(ctx));
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    this.createWindowAccess(ctx, document, rs.getInt("AD_Window_ID"), rs.getInt("AD_Role_ID"));
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "AD_Window_Access", (Throwable)e);
                throw new DatabaseAccessException("Failed to export window access.");
            }
        }
        finally {
            DB.close((ResultSet)rs, (Statement)pstmt);
        }
        sql = "SELECT AD_Process_ID, AD_Role_ID FROM AD_Process_Access WHERE AD_Role_ID= " + Role_id;
        pstmt = null;
        rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, (String)this.getTrxName(ctx));
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    this.createProcessAccess(ctx, document, rs.getInt("AD_Process_ID"), rs.getInt("AD_Role_ID"));
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "AD_Process_Access", (Throwable)e);
                throw new DatabaseAccessException("Failed to export process access.");
            }
        }
        finally {
            DB.close((ResultSet)rs, (Statement)pstmt);
        }
        sql = "SELECT AD_Form_ID, AD_Role_ID FROM AD_Form_Access WHERE AD_Role_ID= " + Role_id;
        pstmt = null;
        rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, (String)this.getTrxName(ctx));
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    this.createFormAccess(ctx, document, rs.getInt("AD_Form_ID"), rs.getInt("AD_Role_ID"));
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "AD_Form_Access", (Throwable)e);
                throw new DatabaseAccessException("Failed to export form access.");
            }
        }
        finally {
            DB.close((ResultSet)rs, (Statement)pstmt);
        }
        sql = "SELECT AD_Workflow_ID, AD_Role_ID FROM AD_Workflow_Access WHERE AD_Role_ID= " + Role_id;
        pstmt = null;
        rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, (String)this.getTrxName(ctx));
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    this.createWorkflowAccess(ctx, document, rs.getInt("AD_Workflow_ID"), rs.getInt("AD_Role_ID"));
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "AD_Workflow_Access", (Throwable)e);
                throw new DatabaseAccessException("Failed to export workflow access.");
            }
        }
        finally {
            DB.close((ResultSet)rs, (Statement)pstmt);
        }
        sql = "SELECT AD_Task_ID, AD_Role_ID FROM AD_Task_Access WHERE AD_Role_ID= " + Role_id;
        pstmt = null;
        rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, (String)this.getTrxName(ctx));
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    this.createTaskAccess(ctx, document, rs.getInt("AD_Task_ID"), rs.getInt("AD_Role_ID"));
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "AD_Task_Access", (Throwable)e);
                throw new DatabaseAccessException("Failed to export task access.");
            }
        }
        finally {
            DB.close((ResultSet)rs, (Statement)pstmt);
        }
        sql = "SELECT AD_InfoWindow_ID, AD_Role_ID FROM AD_InfoWindow_Access WHERE AD_Role_ID= " + Role_id;
        pstmt = null;
        rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, (String)this.getTrxName(ctx));
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    this.createInfoWindowAccess(ctx, document, rs.getInt("AD_InfoWindow_ID"), rs.getInt("AD_Role_ID"));
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "AD_InfoWindow_Access", (Throwable)e);
                throw new DatabaseAccessException("Failed to export InfoWindow access.");
            }
        }
        finally {
            DB.close((ResultSet)rs, (Statement)pstmt);
        }
        if (createElement) {
            document.endElement("", "", "AD_Role");
        }
    }

    private void createTaskAccess(PIPOContext ctx, TransformerHandler document, int AD_Task_ID, int AD_Role_ID) throws SAXException {
        Env.setContext((Properties)ctx.ctx, (String)"AD_Task_ID", (int)AD_Task_ID);
        Env.setContext((Properties)ctx.ctx, (String)"AD_Role_ID", (int)AD_Role_ID);
        this.taskHandler.create(ctx, document);
        ctx.ctx.remove("AD_Task_ID");
        ctx.ctx.remove("AD_Role_ID");
    }

    private void createWorkflowAccess(PIPOContext ctx, TransformerHandler document, int AD_Workflow_ID, int AD_Role_ID) throws SAXException {
        Env.setContext((Properties)ctx.ctx, (String)"AD_Workflow_ID", (int)AD_Workflow_ID);
        Env.setContext((Properties)ctx.ctx, (String)"AD_Role_ID", (int)AD_Role_ID);
        this.workflowHandler.create(ctx, document);
        ctx.ctx.remove("AD_Workflow_ID");
        ctx.ctx.remove("AD_Role_ID");
    }

    private void createFormAccess(PIPOContext ctx, TransformerHandler document, int AD_Form_ID, int AD_Role_ID) throws SAXException {
        Env.setContext((Properties)ctx.ctx, (String)"AD_Form_ID", (int)AD_Form_ID);
        Env.setContext((Properties)ctx.ctx, (String)"AD_Role_ID", (int)AD_Role_ID);
        this.formHandler.create(ctx, document);
        ctx.ctx.remove("AD_Form_ID");
        ctx.ctx.remove("AD_Role_ID");
    }

    private void createProcessAccess(PIPOContext ctx, TransformerHandler document, int AD_Process_ID, int AD_Role_ID) throws SAXException {
        Env.setContext((Properties)ctx.ctx, (String)"AD_Process_ID", (int)AD_Process_ID);
        Env.setContext((Properties)ctx.ctx, (String)"AD_Role_ID", (int)AD_Role_ID);
        this.processHandler.create(ctx, document);
        ctx.ctx.remove("AD_Process_ID");
        ctx.ctx.remove("AD_Role_ID");
    }

    private void createWindowAccess(PIPOContext ctx, TransformerHandler document, int AD_Window_ID, int AD_Role_ID) throws SAXException {
        Env.setContext((Properties)ctx.ctx, (String)"AD_Window_ID", (int)AD_Window_ID);
        Env.setContext((Properties)ctx.ctx, (String)"AD_Role_ID", (int)AD_Role_ID);
        this.windowHandler.create(ctx, document);
        ctx.ctx.remove("AD_Window_ID");
        ctx.ctx.remove("AD_Role_ID");
    }

    private void createInfoWindowAccess(PIPOContext ctx, TransformerHandler document, int AD_InfoWindow_ID, int AD_Role_ID) throws SAXException {
        Env.setContext((Properties)ctx.ctx, (String)"AD_InfoWindow_ID", (int)AD_InfoWindow_ID);
        Env.setContext((Properties)ctx.ctx, (String)"AD_Role_ID", (int)AD_Role_ID);
        this.infoWindowHandler.create(ctx, document);
        ctx.ctx.remove("AD_InfoWindow_ID");
        ctx.ctx.remove("AD_Role_ID");
    }

    private void createOrgAccess(PIPOContext ctx, TransformerHandler document, int AD_Org_ID, int AD_Role_ID) throws SAXException {
        Env.setContext((Properties)ctx.ctx, (String)"AD_Org_ID", (int)AD_Org_ID);
        Env.setContext((Properties)ctx.ctx, (String)"AD_Role_ID", (int)AD_Role_ID);
        this.orgHandler.create(ctx, document);
        ctx.ctx.remove("AD_Org_ID");
        ctx.ctx.remove("AD_Role_ID");
    }

    private void createRoleBinding(PIPOContext ctx, TransformerHandler document, X_AD_Role m_Role) {
        PoExporter filler = new PoExporter(ctx, document, (PO)m_Role);
        List excludes = this.defaultExcludeList("AD_Role");
        if (m_Role.getAD_Role_ID() <= 999999) {
            filler.add("AD_Role_ID", new AttributesImpl());
        }
        filler.export(excludes);
    }

    public void packOut(PackOut packout, TransformerHandler packoutHandler, TransformerHandler docHandler, int recordId) throws Exception {
        Env.setContext((Properties)packout.getCtx().ctx, (String)"AD_Role_ID", (int)recordId);
        this.create(packout.getCtx(), packoutHandler);
        packout.getCtx().ctx.remove("AD_Role_ID");
    }
}

