/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2.handler;

import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.pipo2.AbstractElementHandler;
import org.adempiere.pipo2.Element;
import org.adempiere.pipo2.ElementHandler;
import org.adempiere.pipo2.PIPOContext;
import org.adempiere.pipo2.PackOut;
import org.adempiere.pipo2.PoExporter;
import org.adempiere.pipo2.PoFiller;
import org.adempiere.pipo2.exception.POSaveFailedException;
import org.adempiere.pipo2.handler.CommonTranslationHandler;
import org.adempiere.pipo2.handler.InfoColumnElementHandler;
import org.adempiere.pipo2.handler.InfoProcessElementHandler;
import org.adempiere.pipo2.handler.InfoRelatedElementHandler;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_AD_InfoColumn;
import org.compiere.model.X_AD_InfoProcess;
import org.compiere.model.X_AD_InfoRelated;
import org.compiere.model.X_AD_InfoWindow;
import org.compiere.model.X_AD_Package_Imp_Detail;
import org.compiere.util.Env;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class InfoWindowElementHandler
extends AbstractElementHandler {
    private InfoColumnElementHandler infoColumnHandler = new InfoColumnElementHandler();
    private InfoProcessElementHandler infoProcessHandler = new InfoProcessElementHandler();
    private InfoRelatedElementHandler infoRelatedHandler = new InfoRelatedElementHandler();

    /*
     * Enabled aggressive block sorting
     */
    public void startElement(PIPOContext ctx, Element element) throws SAXException {
        List excludes;
        PoFiller filler;
        List notfounds;
        String entitytype = this.getStringValue(element, "EntityType");
        if (!this.isProcessElement(ctx.ctx, entitytype)) {
            element.skip = true;
            return;
        }
        X_AD_InfoWindow mInfoWindow = (X_AD_InfoWindow)this.findPO(ctx, element);
        if (mInfoWindow == null) {
            mInfoWindow = new X_AD_InfoWindow(ctx.ctx, 0, this.getTrxName(ctx));
        }
        if ((notfounds = (filler = new PoFiller(ctx, (PO)mInfoWindow, element, (AbstractElementHandler)this)).autoFill(excludes = this.defaultExcludeList("AD_InfoWindow"))).size() > 0) {
            element.defer = true;
            element.unresolved = notfounds.toString();
            return;
        }
        element.recordId = mInfoWindow.get_ID();
        if (!mInfoWindow.is_new()) {
            if (!mInfoWindow.is_Changed()) return;
        }
        X_AD_Package_Imp_Detail impDetail = this.createImportDetail(ctx, element.qName, "AD_InfoWindow", 895);
        String action = null;
        if (!mInfoWindow.is_new()) {
            this.backupRecord(ctx, impDetail.getAD_Package_Imp_Detail_ID(), "AD_InfoWindow", (PO)mInfoWindow);
            action = "Update";
        } else {
            action = "New";
        }
        if (mInfoWindow.save(this.getTrxName(ctx))) {
            this.logImportDetail(ctx, impDetail, 1, mInfoWindow.getName(), mInfoWindow.get_ID(), action);
            element.recordId = mInfoWindow.get_ID();
            element.requireRoleAccessUpdate = true;
            return;
        }
        this.logImportDetail(ctx, impDetail, 0, mInfoWindow.getName(), mInfoWindow.get_ID(), action);
        throw new POSaveFailedException("Failed to save InfoWindow " + mInfoWindow.getName());
    }

    public void endElement(PIPOContext ctx, Element element) throws SAXException {
    }

    public void create(PIPOContext ctx, TransformerHandler document) throws SAXException {
        int AD_InfoWindow_ID = Env.getContextAsInt((Properties)ctx.ctx, (String)"AD_InfoWindow_ID");
        if (ctx.packOut.isExported("AD_InfoWindow_ID|" + AD_InfoWindow_ID)) {
            return;
        }
        PackOut packOut = ctx.packOut;
        X_AD_InfoWindow m_InfoWindow = new X_AD_InfoWindow(ctx.ctx, AD_InfoWindow_ID, this.getTrxName(ctx));
        AttributesImpl atts = new AttributesImpl();
        try {
            boolean createElement;
            block15: {
                if (m_InfoWindow.getAD_Table_ID() > 0) {
                    ElementHandler handler = packOut.getHandler("AD_Table");
                    handler.packOut(packOut, document, null, m_InfoWindow.getAD_Table_ID());
                }
                if (createElement = this.isPackOutElement(ctx, (PO)m_InfoWindow)) {
                    this.verifyPackOutRequirement((PO)m_InfoWindow);
                    this.addTypeName(atts, "table");
                    document.startElement("", "", "AD_InfoWindow", atts);
                    this.createInfoWindowBinding(ctx, document, m_InfoWindow);
                    packOut.getCtx().ctx.put("Table_Name", "AD_InfoWindow");
                    try {
                        new CommonTranslationHandler().packOut(packOut, document, null, m_InfoWindow.get_ID());
                    }
                    catch (Exception e) {
                        if (!this.log.isLoggable(Level.INFO)) break block15;
                        this.log.info(e.toString());
                    }
                }
            }
            Query queryCols = new Query(ctx.ctx, "AD_InfoColumn", "AD_InfoWindow_ID = ?", this.getTrxName(ctx));
            List infoColumnlist = queryCols.setParameters(new Object[]{AD_InfoWindow_ID}).list();
            for (X_AD_InfoColumn infoColumn : infoColumnlist) {
                ElementHandler handler;
                if (infoColumn.getAD_Reference_ID() > 0) {
                    handler = packOut.getHandler("AD_Reference");
                    handler.packOut(packOut, document, null, infoColumn.getAD_Reference_ID());
                }
                if (infoColumn.getAD_Reference_Value_ID() > 0) {
                    handler = packOut.getHandler("AD_Reference");
                    handler.packOut(packOut, document, null, infoColumn.getAD_Reference_Value_ID());
                }
                if (infoColumn.getAD_Val_Rule_ID() > 0) {
                    handler = packOut.getHandler("AD_Val_Rule");
                    handler.packOut(packOut, document, null, infoColumn.getAD_Val_Rule_ID());
                }
                this.createInfoColumn(ctx, document, infoColumn.getAD_InfoColumn_ID());
            }
            Query queryProc = new Query(ctx.ctx, "AD_InfoProcess", "AD_InfoWindow_ID = ?", this.getTrxName(ctx));
            List infoProcesslist = queryProc.setParameters(new Object[]{AD_InfoWindow_ID}).list();
            for (X_AD_InfoProcess infoProcess : infoProcesslist) {
                if (infoProcess.getAD_Process_ID() > 0) {
                    ElementHandler handler = packOut.getHandler("AD_Process");
                    handler.packOut(packOut, document, null, infoProcess.getAD_Process_ID());
                }
                this.createInfoProcess(ctx, document, infoProcess.getAD_InfoProcess_ID());
            }
            Query queryRel = new Query(ctx.ctx, "AD_InfoRelated", "AD_InfoWindow_ID = ?", this.getTrxName(ctx));
            List infoRelatedlist = queryRel.setParameters(new Object[]{AD_InfoWindow_ID}).list();
            for (X_AD_InfoRelated infoRelated : infoRelatedlist) {
                this.createInfoRelated(ctx, document, infoRelated.getAD_InfoRelated_ID());
            }
            if (createElement) {
                document.endElement("", "", "AD_InfoWindow");
            }
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
    }

    private void createInfoColumn(PIPOContext ctx, TransformerHandler document, int AD_InfoColumn_ID) throws SAXException {
        Env.setContext((Properties)ctx.ctx, (String)"AD_InfoColumn_ID", (int)AD_InfoColumn_ID);
        this.infoColumnHandler.create(ctx, document);
        ctx.ctx.remove("AD_InfoColumn_ID");
    }

    private void createInfoProcess(PIPOContext ctx, TransformerHandler document, int AD_InfoProcess_ID) throws SAXException {
        Env.setContext((Properties)ctx.ctx, (String)"AD_InfoProcess_ID", (int)AD_InfoProcess_ID);
        this.infoProcessHandler.create(ctx, document);
        ctx.ctx.remove("AD_InfoProcess_ID");
    }

    private void createInfoRelated(PIPOContext ctx, TransformerHandler document, int AD_InfoRelated_ID) throws SAXException {
        Env.setContext((Properties)ctx.ctx, (String)"AD_InfoRelated_ID", (int)AD_InfoRelated_ID);
        this.infoRelatedHandler.create(ctx, document);
        ctx.ctx.remove("AD_InfoRelated_ID");
    }

    private void createInfoWindowBinding(PIPOContext ctx, TransformerHandler document, X_AD_InfoWindow m_InfoWindow) {
        PoExporter filler = new PoExporter(ctx, document, (PO)m_InfoWindow);
        List excludes = this.defaultExcludeList("AD_InfoWindow");
        if (m_InfoWindow.getAD_InfoWindow_ID() <= 999999) {
            filler.add("AD_InfoWindow_ID", new AttributesImpl());
        }
        filler.export(excludes);
    }

    public void packOut(PackOut packout, TransformerHandler packoutHandler, TransformerHandler docHandler, int recordId) throws Exception {
        Env.setContext((Properties)packout.getCtx().ctx, (String)"AD_InfoWindow_ID", (int)recordId);
        this.create(packout.getCtx(), packoutHandler);
        packout.getCtx().ctx.remove("AD_InfoWindow_ID");
    }
}

