/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.util;

import java.util.List;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.util.Monitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Statistic
implements Monitor {
    private final long _startTime = System.currentTimeMillis();
    private int _nsess;
    private int _actsess;
    private int _ndt;
    private int _actdt;
    private int _nupd;
    private int _actupd;

    public long getStartTime() {
        return this._startTime;
    }

    public int getTotalSessionCount() {
        return this._nsess;
    }

    public int getActiveSessionCount() {
        return this._actsess;
    }

    public double getAverageSessionCount() {
        return (double)this._nsess / this.getEscapedHours();
    }

    public int getTotalDesktopCount() {
        return this._ndt;
    }

    public int getActiveDesktopCount() {
        return this._actdt;
    }

    public double getAverageDesktopCount() {
        return (double)this._ndt / this.getEscapedHours();
    }

    public int getTotalUpdateCount() {
        return this._nupd;
    }

    public int getActiveUpdateCount() {
        return this._actupd;
    }

    public double getAverageUpdateCount() {
        return (double)this._nupd / this.getEscapedHours();
    }

    private double getEscapedHours() {
        long v = System.currentTimeMillis() - this._startTime;
        return (double)v / 3600000.0;
    }

    @Override
    public synchronized void sessionCreated(Session sess) {
        ++this._nsess;
        ++this._actsess;
    }

    @Override
    public synchronized void sessionDestroyed(Session sess) {
        --this._actsess;
    }

    @Override
    public synchronized void desktopCreated(Desktop desktop) {
        ++this._ndt;
        ++this._actdt;
    }

    @Override
    public synchronized void desktopDestroyed(Desktop desktop) {
        --this._actdt;
    }

    @Override
    public synchronized void beforeUpdate(Desktop desktop, List<AuRequest> requests) {
        ++this._nupd;
        ++this._actupd;
    }

    @Override
    public synchronized void afterUpdate(Desktop desktop) {
        --this._actupd;
    }
}

