/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Objects;
import org.zkoss.lang.PotentialDeadLockException;
import org.zkoss.util.FastReadArray;
import org.zkoss.util.WaitLock;
import org.zkoss.xel.ExpressionFactory;
import org.zkoss.xel.Expressions;
import org.zkoss.xel.VariableResolver;
import org.zkoss.zk.au.AuDecoder;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.Richlet;
import org.zkoss.zk.ui.RichletConfig;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.ShadowElement;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.WebApps;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventThreadCleanup;
import org.zkoss.zk.ui.event.EventThreadInit;
import org.zkoss.zk.ui.event.EventThreadResume;
import org.zkoss.zk.ui.event.EventThreadSuspend;
import org.zkoss.zk.ui.http.Utils;
import org.zkoss.zk.ui.impl.EventInterceptors;
import org.zkoss.zk.ui.impl.MultiComposer;
import org.zkoss.zk.ui.impl.RichletConfigImpl;
import org.zkoss.zk.ui.metainfo.NamespaceParser;
import org.zkoss.zk.ui.sys.DesktopCacheProvider;
import org.zkoss.zk.ui.sys.DiskFileItemFactory;
import org.zkoss.zk.ui.sys.FailoverManager;
import org.zkoss.zk.ui.sys.IdGenerator;
import org.zkoss.zk.ui.sys.PropertiesRenderer;
import org.zkoss.zk.ui.sys.SEORenderer;
import org.zkoss.zk.ui.sys.SessionCache;
import org.zkoss.zk.ui.sys.UiEngine;
import org.zkoss.zk.ui.sys.UiFactory;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.ui.sys.WebAppFactory;
import org.zkoss.zk.ui.util.AggregationListener;
import org.zkoss.zk.ui.util.Callback;
import org.zkoss.zk.ui.util.CharsetFinder;
import org.zkoss.zk.ui.util.Composer;
import org.zkoss.zk.ui.util.DataHandlerInfo;
import org.zkoss.zk.ui.util.DesktopCleanup;
import org.zkoss.zk.ui.util.DesktopInit;
import org.zkoss.zk.ui.util.DesktopRecycle;
import org.zkoss.zk.ui.util.EventInterceptor;
import org.zkoss.zk.ui.util.ExecutionCleanup;
import org.zkoss.zk.ui.util.ExecutionInit;
import org.zkoss.zk.ui.util.ExecutionMonitor;
import org.zkoss.zk.ui.util.Initiator;
import org.zkoss.zk.ui.util.Monitor;
import org.zkoss.zk.ui.util.PerformanceMeter;
import org.zkoss.zk.ui.util.RequestInterceptor;
import org.zkoss.zk.ui.util.SessionCleanup;
import org.zkoss.zk.ui.util.SessionInit;
import org.zkoss.zk.ui.util.ThemeProvider;
import org.zkoss.zk.ui.util.URIInfo;
import org.zkoss.zk.ui.util.URIInterceptor;
import org.zkoss.zk.ui.util.UiLifeCycle;
import org.zkoss.zk.ui.util.WebAppCleanup;
import org.zkoss.zk.ui.util.WebAppInit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration {
    private static final Logger log = LoggerFactory.getLogger(Configuration.class);
    private static final String PROP_EXPRESS_FACTORY = "org.zkoss.xel.ExpressionFactory.class";
    private WebApp _wapp;
    private final FastReadArray<Class<?>> _evtInits = new FastReadArray(Class.class);
    private final FastReadArray<Class<?>> _evtCleans = new FastReadArray(Class.class);
    private final FastReadArray<Class<?>> _evtSusps = new FastReadArray(Class.class);
    private final FastReadArray<Class<?>> _evtResus = new FastReadArray(Class.class);
    private final FastReadArray<Class<?>> _appInits = new FastReadArray(Class.class);
    private final FastReadArray<Class<?>> _appCleans = new FastReadArray(Class.class);
    private final FastReadArray<Class<?>> _sessInits = new FastReadArray(Class.class);
    private final FastReadArray<Class<?>> _sessCleans = new FastReadArray(Class.class);
    private final FastReadArray<Class<?>> _dtInits = new FastReadArray(Class.class);
    private final FastReadArray<Class<?>> _dtCleans = new FastReadArray(Class.class);
    private final FastReadArray<Class<?>> _execInits = new FastReadArray(Class.class);
    private final FastReadArray<Class<?>> _execCleans = new FastReadArray(Class.class);
    private final FastReadArray<Class<?>> _composers = new FastReadArray(Class.class);
    private final FastReadArray<Class<?>> _initiators = new FastReadArray(Class.class);
    private final FastReadArray<Class<?>> _seoRends = new FastReadArray(Class.class);
    private final FastReadArray<Class<?>> _resolvers = new FastReadArray(Class.class);
    private final FastReadArray<Class<?>> _parsers = new FastReadArray(Class.class);
    private final FastReadArray<AggregationListener> _aggregations = new FastReadArray(AggregationListener.class);
    private final FastReadArray<URIInterceptor> _uriIntcps = new FastReadArray(URIInterceptor.class);
    private final FastReadArray<RequestInterceptor> _reqIntcps = new FastReadArray(RequestInterceptor.class);
    private final FastReadArray<UiLifeCycle> _uiCycles = new FastReadArray(UiLifeCycle.class);
    private final FastReadArray<PropertiesRenderer> _propRends = new FastReadArray(PropertiesRenderer.class);
    private final FastReadArray<String> _labellocs = new FastReadArray(String.class);
    private final Map<String, String> _prefs = Collections.synchronizedMap(new HashMap());
    private final Map<String, Object> _richlets = new HashMap<String, Object>();
    private final Map<String, Object[]> _richletmaps = new HashMap<String, Object[]>();
    private final Map<String, List<ErrorPage>> _errpgs = new HashMap<String, List<ErrorPage>>(4);
    private final Map<String, Map<Integer, String>> _errURIs = new HashMap<String, Map<Integer, String>>();
    private final Map<String, TimeoutURIInfo> _timeoutURIs = Collections.synchronizedMap(new HashMap());
    private final Map<String, DataHandlerInfo> _dataHandlers = new HashMap<String, DataHandlerInfo>();
    private final Map<String, Callback> _callbacks = new HashMap<String, Callback>();
    private Monitor _monitor;
    private PerformanceMeter _pfmeter;
    private ExecutionMonitor _execmon;
    private DesktopRecycle _dtRecycle;
    private final FastReadArray<String> _themeURIs = new FastReadArray(String.class);
    private ThemeProvider _themeProvider;
    private Set<String> _disThemeURIs;
    private final FastReadArray<String> _clientpkgs = new FastReadArray(String.class);
    private Class<?> _wappcls;
    private Class<?> _wappftycls;
    private Class<?> _uiengcls;
    private Class<?> _dcpcls;
    private Class<?> _uiftycls;
    private Class<?> _failmancls;
    private Class<?> _idgencls;
    private Class<?> _sesscachecls;
    private Class<?> _audeccls;
    private Class<?> _fileFactory;
    private int _dtTimeout = 3600;
    private int _sessDktMax = 15;
    private int _sessReqMax = 5;
    private int _sessPushMax = -1;
    private int _sessTimeout = 0;
    private int _sparThdMax = 100;
    private int _suspThdMax = -1;
    private int _maxUploadSize = 5120;
    private int _fileSizeThreshold;
    private int _maxProcTime = 3000;
    private int _promptDelay = 900;
    private int _tooltipDelay = 800;
    private int _autoResendTimeout = 200;
    private String _fileRepository;
    private String _charsetResp = "UTF-8";
    private String _charsetUpload = "UTF-8";
    private CharsetFinder _charsetFinderUpload;
    private final EventInterceptors _eis = new EventInterceptors();
    private int _evtTimeWarn = 600;
    private final Map<String, Object> _attrs = Collections.synchronizedMap(new HashMap());
    private boolean _evtThdEnabled;
    private boolean _zscriptEnabled = true;
    private boolean _keepDesktop;
    private boolean _timerKeepAlive;
    private boolean _debugJS;
    private boolean _crawlable;
    private boolean _repeatUuid;
    private boolean _customThemeProvider = false;
    private boolean _customThemeRegistry = false;
    private boolean _customThemeResolver = false;
    private String _initCrashScript;
    private int _initCrashTimeout = -1;
    private String _binderInitAttribute = null;
    private Set<String> _binderAnnotations;
    private boolean _sourceMapEnabled = false;

    public WebApp getWebApp() {
        return this._wapp;
    }

    public void setWebApp(WebApp wapp) {
        this._wapp = wapp;
    }

    public void addListener(Class<?> klass) throws Exception {
        boolean added = false;
        Object listener = null;
        if (Monitor.class.isAssignableFrom(klass)) {
            if (this._monitor != null) {
                throw new UiException(Configuration.onlyOnce(Monitor.class));
            }
            listener = Configuration.getInstance(klass, listener);
            this._monitor = (Monitor)listener;
            added = true;
        }
        if (PerformanceMeter.class.isAssignableFrom(klass)) {
            if (this._pfmeter != null) {
                throw new UiException(Configuration.onlyOnce(PerformanceMeter.class));
            }
            listener = Configuration.getInstance(klass, listener);
            this._pfmeter = (PerformanceMeter)listener;
            added = true;
        }
        if (ExecutionMonitor.class.isAssignableFrom(klass)) {
            if (this._execmon != null) {
                throw new UiException(Configuration.onlyOnce(ExecutionMonitor.class));
            }
            listener = Configuration.getInstance(klass, listener);
            this._execmon = (ExecutionMonitor)listener;
            added = true;
        }
        if (DesktopRecycle.class.isAssignableFrom(klass)) {
            if (this._dtRecycle != null) {
                throw new UiException(Configuration.onlyOnce(DesktopRecycle.class));
            }
            listener = Configuration.getInstance(klass, listener);
            this._dtRecycle = (DesktopRecycle)listener;
            added = true;
        }
        if (EventThreadInit.class.isAssignableFrom(klass)) {
            this._evtInits.add(klass);
            added = true;
        }
        if (EventThreadCleanup.class.isAssignableFrom(klass)) {
            this._evtCleans.add(klass);
            added = true;
        }
        if (EventThreadSuspend.class.isAssignableFrom(klass)) {
            this._evtSusps.add(klass);
            added = true;
        }
        if (EventThreadResume.class.isAssignableFrom(klass)) {
            this._evtResus.add(klass);
            added = true;
        }
        if (WebAppInit.class.isAssignableFrom(klass)) {
            this._appInits.add(klass);
            added = true;
        }
        if (WebAppCleanup.class.isAssignableFrom(klass)) {
            this._appCleans.add(klass);
            added = true;
        }
        if (SessionInit.class.isAssignableFrom(klass)) {
            this._sessInits.add(klass);
            added = true;
        }
        if (SessionCleanup.class.isAssignableFrom(klass)) {
            this._sessCleans.add(klass);
            added = true;
        }
        if (DesktopInit.class.isAssignableFrom(klass)) {
            this._dtInits.add(klass);
            added = true;
        }
        if (DesktopCleanup.class.isAssignableFrom(klass)) {
            this._dtCleans.add(klass);
            added = true;
        }
        if (ExecutionInit.class.isAssignableFrom(klass)) {
            this._execInits.add(klass);
            added = true;
        }
        if (ExecutionCleanup.class.isAssignableFrom(klass)) {
            this._execCleans.add(klass);
            added = true;
        }
        if (Composer.class.isAssignableFrom(klass)) {
            this._composers.add(klass);
            added = true;
        }
        if (Initiator.class.isAssignableFrom(klass)) {
            this._initiators.add(klass);
            added = true;
        }
        if (SEORenderer.class.isAssignableFrom(klass)) {
            this._seoRends.add(klass);
            added = true;
        }
        if (VariableResolver.class.isAssignableFrom(klass)) {
            this._resolvers.add(klass);
            added = true;
        }
        if (AggregationListener.class.isAssignableFrom(klass)) {
            try {
                listener = Configuration.getInstance(klass, listener);
                this._aggregations.add((Object)((AggregationListener)listener));
            }
            catch (Throwable ex) {
                log.error("Failed to instantiate " + klass, ex);
            }
            added = true;
        }
        if (URIInterceptor.class.isAssignableFrom(klass)) {
            try {
                listener = Configuration.getInstance(klass, listener);
                this._uriIntcps.add((Object)((URIInterceptor)listener));
            }
            catch (Throwable ex) {
                log.error("Failed to instantiate " + klass, ex);
            }
            added = true;
        }
        if (RequestInterceptor.class.isAssignableFrom(klass)) {
            try {
                listener = Configuration.getInstance(klass, listener);
                this._reqIntcps.add((Object)((RequestInterceptor)listener));
            }
            catch (Throwable ex) {
                log.error("Failed to instantiate " + klass, ex);
            }
            added = true;
        }
        if (EventInterceptor.class.isAssignableFrom(klass)) {
            try {
                listener = Configuration.getInstance(klass, listener);
                this._eis.addEventInterceptor((EventInterceptor)listener);
            }
            catch (Throwable ex) {
                log.error("Failed to instantiate " + klass, ex);
            }
            added = true;
        }
        if (UiLifeCycle.class.isAssignableFrom(klass)) {
            try {
                listener = Configuration.getInstance(klass, listener);
                this._uiCycles.add((Object)((UiLifeCycle)listener));
            }
            catch (Throwable ex) {
                log.error("Failed to instantiate " + klass, ex);
            }
            added = true;
        }
        if (PropertiesRenderer.class.isAssignableFrom(klass)) {
            try {
                listener = Configuration.getInstance(klass, listener);
                this._propRends.add((Object)((PropertiesRenderer)listener));
            }
            catch (Throwable ex) {
                log.error("Failed to instantiate " + klass, ex);
            }
            added = true;
        }
        if (NamespaceParser.class.isAssignableFrom(klass)) {
            this._parsers.add(klass);
            added = true;
        }
        if (!added) {
            for (AggregationListener aggregationListener : Arrays.asList(this._aggregations.toArray())) {
                if (!aggregationListener.isHandled(klass)) continue;
                added = true;
                break;
            }
        }
        if (!added) {
            throw new UiException("Unknown listener: " + klass);
        }
    }

    private static final String onlyOnce(Class<?> cls) {
        return cls + " can be assigned only once";
    }

    private static Object getInstance(Class<?> klass, Object listener) throws Exception {
        return listener != null ? listener : klass.newInstance();
    }

    public void removeListener(Class<?> klass) {
        if (this._monitor != null && this._monitor.getClass().equals(klass)) {
            this._monitor = null;
        }
        if (this._pfmeter != null && this._pfmeter.getClass().equals(klass)) {
            this._pfmeter = null;
        }
        if (this._execmon != null && this._execmon.getClass().equals(klass)) {
            this._execmon = null;
        }
        if (this._dtRecycle != null && this._dtRecycle.getClass().equals(klass)) {
            this._dtRecycle = null;
        }
        this._evtInits.remove(klass);
        this._evtCleans.remove(klass);
        this._evtSusps.remove(klass);
        this._evtResus.remove(klass);
        this._appInits.remove(klass);
        this._appCleans.remove(klass);
        this._sessInits.remove(klass);
        this._sessCleans.remove(klass);
        this._dtInits.remove(klass);
        this._dtCleans.remove(klass);
        this._execInits.remove(klass);
        this._execCleans.remove(klass);
        this._composers.remove(klass);
        this._initiators.remove(klass);
        this._seoRends.remove(klass);
        this._resolvers.remove(klass);
        this._parsers.remove(klass);
        SameClass sc = new SameClass(klass);
        this._aggregations.removeBy((Comparable)sc, true);
        this._uriIntcps.removeBy((Comparable)sc, true);
        this._reqIntcps.removeBy((Comparable)sc, true);
        this._uiCycles.removeBy((Comparable)sc, true);
        this._propRends.removeBy((Comparable)sc, true);
        this._eis.removeEventInterceptor(klass);
    }

    public List<EventThreadInit> newEventThreadInits(Component comp, Event evt) throws UiException {
        Class[] ary = (Class[])this._evtInits.toArray();
        if (ary.length == 0) {
            return null;
        }
        LinkedList<EventThreadInit> inits = new LinkedList<EventThreadInit>();
        for (int j = 0; j < ary.length; ++j) {
            Class klass = ary[j];
            try {
                EventThreadInit init = (EventThreadInit)klass.newInstance();
                init.prepare(comp, evt);
                inits.add(init);
                continue;
            }
            catch (Throwable ex) {
                throw UiException.Aide.wrap(ex);
            }
        }
        return inits;
    }

    public boolean invokeEventThreadInits(List<EventThreadInit> inits, Component comp, Event evt) throws UiException {
        if (inits == null || inits.isEmpty()) {
            return true;
        }
        for (EventThreadInit fn : inits) {
            try {
                if (fn.init(comp, evt)) continue;
                return false;
            }
            catch (Throwable ex) {
                throw UiException.Aide.wrap(ex);
            }
        }
        return true;
    }

    public List<EventThreadCleanup> newEventThreadCleanups(Component comp, Event evt, List<Throwable> errs, boolean silent) {
        Class[] ary = (Class[])this._evtCleans.toArray();
        if (ary.length == 0) {
            return null;
        }
        LinkedList<EventThreadCleanup> cleanups = new LinkedList<EventThreadCleanup>();
        for (int j = 0; j < ary.length; ++j) {
            Class klass = ary[j];
            try {
                EventThreadCleanup cleanup = (EventThreadCleanup)klass.newInstance();
                cleanup.cleanup(comp, evt, errs);
                cleanups.add(cleanup);
                continue;
            }
            catch (Throwable t) {
                if (errs != null) {
                    errs.add(t);
                }
                if (silent) continue;
                log.error("Failed to invoke " + klass, t);
            }
        }
        return cleanups.isEmpty() ? null : cleanups;
    }

    public void invokeEventThreadCompletes(List<EventThreadCleanup> cleanups, Component comp, Event evt, List<Throwable> errs, boolean silent) {
        if (cleanups == null || cleanups.isEmpty()) {
            return;
        }
        for (EventThreadCleanup fn : cleanups) {
            try {
                fn.complete(comp, evt);
            }
            catch (Throwable ex) {
                if (errs != null) {
                    errs.add(ex);
                }
                if (silent) continue;
                log.error("Failed to invoke " + fn, ex);
            }
        }
    }

    public List<EventThreadSuspend> newEventThreadSuspends(Component comp, Event evt, Object obj) {
        Class[] ary = (Class[])this._evtSusps.toArray();
        if (ary.length == 0) {
            return null;
        }
        LinkedList<EventThreadSuspend> suspends = new LinkedList<EventThreadSuspend>();
        for (int j = 0; j < ary.length; ++j) {
            Class klass = ary[j];
            try {
                EventThreadSuspend suspend = (EventThreadSuspend)klass.newInstance();
                suspend.beforeSuspend(comp, evt, obj);
                suspends.add(suspend);
                continue;
            }
            catch (Throwable ex) {
                throw UiException.Aide.wrap(ex);
            }
        }
        return suspends;
    }

    public void invokeEventThreadSuspends(List<EventThreadSuspend> suspends, Component comp, Event evt) throws UiException {
        if (suspends == null || suspends.isEmpty()) {
            return;
        }
        for (EventThreadSuspend fn : suspends) {
            try {
                fn.afterSuspend(comp, evt);
            }
            catch (Throwable ex) {
                log.error("Failed to invoke " + fn + " after suspended", ex);
            }
        }
    }

    public List<EventThreadResume> newEventThreadResumes(Component comp, Event evt) throws UiException {
        Class[] ary = (Class[])this._evtResus.toArray();
        if (ary.length == 0) {
            return null;
        }
        LinkedList<EventThreadResume> resumes = new LinkedList<EventThreadResume>();
        for (int j = 0; j < ary.length; ++j) {
            Class klass = ary[j];
            try {
                EventThreadResume resume = (EventThreadResume)klass.newInstance();
                resume.beforeResume(comp, evt);
                resumes.add(resume);
                continue;
            }
            catch (Throwable ex) {
                throw UiException.Aide.wrap(ex);
            }
        }
        return resumes;
    }

    public void invokeEventThreadResumes(List<EventThreadResume> resumes, Component comp, Event evt) throws UiException {
        if (resumes == null || resumes.isEmpty()) {
            return;
        }
        for (EventThreadResume fn : resumes) {
            try {
                fn.afterResume(comp, evt);
            }
            catch (Throwable ex) {
                throw UiException.Aide.wrap(ex);
            }
        }
    }

    public void invokeEventThreadResumeAborts(Component comp, Event evt) {
        Class[] ary = (Class[])this._evtResus.toArray();
        for (int j = 0; j < ary.length; ++j) {
            Class klass = ary[j];
            try {
                ((EventThreadResume)klass.newInstance()).abortResume(comp, evt);
                continue;
            }
            catch (Throwable ex) {
                log.error("Failed to invoke " + klass + " for aborting", ex);
            }
        }
    }

    public void invokeWebAppInits() throws UiException {
        Class[] ary = (Class[])this._appInits.toArray();
        for (int j = 0; j < ary.length; ++j) {
            Class klass = ary[j];
            try {
                ((WebAppInit)klass.newInstance()).init(this._wapp);
                continue;
            }
            catch (Throwable ex) {
                log.error("Failed to invoke " + klass, ex);
            }
        }
    }

    public void invokeWebAppCleanups() {
        Class[] ary = (Class[])this._appCleans.toArray();
        for (int j = 0; j < ary.length; ++j) {
            Class klass = ary[j];
            try {
                ((WebAppCleanup)klass.newInstance()).cleanup(this._wapp);
                continue;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                continue;
            }
            catch (Throwable ex) {
                log.error("Ignored: failed to invoke " + klass, ex);
            }
        }
    }

    public void invokeSessionInits(Session sess, Object request) throws UiException {
        Class[] ary = (Class[])this._sessInits.toArray();
        for (int j = 0; j < ary.length; ++j) {
            Class klass = ary[j];
            try {
                SessionInit fn = (SessionInit)klass.newInstance();
                fn.init(sess, request);
                continue;
            }
            catch (Throwable ex) {
                throw UiException.Aide.wrap(ex);
            }
        }
    }

    public void invokeSessionCleanups(Session sess) {
        Class[] ary = (Class[])this._sessCleans.toArray();
        for (int j = 0; j < ary.length; ++j) {
            Class klass = ary[j];
            try {
                ((SessionCleanup)klass.newInstance()).cleanup(sess);
                continue;
            }
            catch (Throwable ex) {
                log.error("Failed to invoke " + klass, ex);
            }
        }
    }

    public void invokeDesktopInits(Desktop desktop, Object request) throws UiException {
        Class[] ary = (Class[])this._dtInits.toArray();
        for (int j = 0; j < ary.length; ++j) {
            Class klass = ary[j];
            try {
                DesktopInit fn = (DesktopInit)klass.newInstance();
                fn.init(desktop, request);
                continue;
            }
            catch (Throwable ex) {
                throw UiException.Aide.wrap(ex);
            }
        }
    }

    public void invokeDesktopCleanups(Desktop desktop) {
        Class[] ary = (Class[])this._dtCleans.toArray();
        for (int j = 0; j < ary.length; ++j) {
            try {
                ((DesktopCleanup)ary[j].newInstance()).cleanup(desktop);
                continue;
            }
            catch (Throwable ex) {
                log.error("Failed to invoke " + ary[j], ex);
            }
        }
    }

    public void invokeExecutionInits(Execution exec, Execution parent) throws UiException {
        Class[] ary = (Class[])this._execInits.toArray();
        for (int j = 0; j < ary.length; ++j) {
            try {
                ((ExecutionInit)ary[j].newInstance()).init(exec, parent);
                continue;
            }
            catch (Throwable ex) {
                throw UiException.Aide.wrap(ex);
            }
        }
    }

    public void invokeExecutionCleanups(Execution exec, Execution parent, List<Throwable> errs) {
        Class[] ary = (Class[])this._execCleans.toArray();
        for (int j = 0; j < ary.length; ++j) {
            try {
                ((ExecutionCleanup)ary[j].newInstance()).cleanup(exec, parent, errs);
                continue;
            }
            catch (Throwable ex) {
                log.error("Failed to invoke " + ary[j], ex);
                if (errs == null) continue;
                errs.add(ex);
            }
        }
    }

    public void invokeURIInterceptors(String uri) {
        URIInterceptor[] ary = (URIInterceptor[])this._uriIntcps.toArray();
        for (int j = 0; j < ary.length; ++j) {
            try {
                ary[j].request(uri);
                continue;
            }
            catch (Exception ex) {
                throw UiException.Aide.wrap(ex);
            }
        }
    }

    public void invokeRequestInterceptors(Session sess, Object request, Object response) {
        RequestInterceptor[] ary = (RequestInterceptor[])this._reqIntcps.toArray();
        for (int j = 0; j < ary.length; ++j) {
            try {
                ary[j].request(sess, request, response);
                continue;
            }
            catch (Exception ex) {
                throw UiException.Aide.wrap(ex);
            }
        }
    }

    public void addLabelLocation(String location) {
        if (location == null || location.length() == 0) {
            throw new IllegalArgumentException();
        }
        this._labellocs.add((Object)location);
    }

    public String[] getLabelLocations() {
        return (String[])this._labellocs.toArray();
    }

    public Composer<?> getComposer(Page page) throws Exception {
        return MultiComposer.getComposer(page, this._composers.toArray());
    }

    public Initiator[] getInitiators() {
        Class[] initclses = (Class[])this._initiators.toArray();
        if (initclses.length == 0) {
            return new Initiator[0];
        }
        LinkedList<Initiator> inits = new LinkedList<Initiator>();
        for (int j = 0; j < initclses.length; ++j) {
            try {
                inits.add((Initiator)initclses[j].newInstance());
                continue;
            }
            catch (Throwable ex) {
                log.error("Failed to instantiate " + initclses[j]);
            }
        }
        return inits.toArray(new Initiator[inits.size()]);
    }

    public List<NamespaceParser> getNamespaceParsers() {
        Class[] initclses = (Class[])this._parsers.toArray();
        if (initclses.length == 0) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<NamespaceParser> inits = new LinkedList<NamespaceParser>();
        for (int j = 0; j < initclses.length; ++j) {
            try {
                inits.add((NamespaceParser)initclses[j].newInstance());
                continue;
            }
            catch (Throwable ex) {
                log.error("Failed to instantiate " + initclses[j]);
            }
        }
        return inits;
    }

    public SEORenderer[] getSEORenderers() {
        Class[] sdclses = (Class[])this._seoRends.toArray();
        if (sdclses.length == 0) {
            return new SEORenderer[0];
        }
        LinkedList<SEORenderer> sds = new LinkedList<SEORenderer>();
        for (int j = 0; j < sdclses.length; ++j) {
            try {
                sds.add((SEORenderer)sdclses[j].newInstance());
                continue;
            }
            catch (Throwable ex) {
                log.error("Failed to instantiate " + sdclses[j]);
            }
        }
        return sds.toArray(new SEORenderer[sds.size()]);
    }

    public void init(Page page) {
        Class[] classes = (Class[])this._resolvers.toArray();
        for (int j = 0; j < classes.length; ++j) {
            try {
                page.addVariableResolver((VariableResolver)classes[j].newInstance());
                continue;
            }
            catch (Throwable ex) {
                log.error("Failed to instantiate " + classes[j], ex);
            }
        }
    }

    public PropertiesRenderer[] getPropertiesRenderers() {
        return (PropertiesRenderer[])this._propRends.toArray();
    }

    public void afterComponentAttached(Component comp, Page page) {
        UiLifeCycle[] ary = (UiLifeCycle[])this._uiCycles.toArray();
        for (int j = 0; j < ary.length; ++j) {
            try {
                ary[j].afterComponentAttached(comp, page);
                continue;
            }
            catch (Throwable ex) {
                log.error("Failed to invoke " + ary[j], ex);
            }
        }
    }

    public void afterComponentDetached(Component comp, Page prevpage) {
        UiLifeCycle[] ary = (UiLifeCycle[])this._uiCycles.toArray();
        for (int j = 0; j < ary.length; ++j) {
            try {
                ary[j].afterComponentDetached(comp, prevpage);
                continue;
            }
            catch (Throwable ex) {
                log.error("Failed to invoke " + ary[j], ex);
            }
        }
    }

    public void invokeCallback(String name, Object data) {
        Callback callback = this._callbacks.get(name);
        if (callback != null) {
            callback.call(data);
        }
    }

    public void registerCallBack(String name, Callback callback) {
        this._callbacks.put(name, callback);
    }

    public void unregisterCallBack(String name) {
        this._callbacks.remove(name);
    }

    public boolean hasCallBack(String name) {
        return this._callbacks.containsKey(name);
    }

    public void afterShadowAttached(ShadowElement shadow, Component host) {
        UiLifeCycle[] ary = (UiLifeCycle[])this._uiCycles.toArray();
        for (int j = 0; j < ary.length; ++j) {
            try {
                ary[j].afterShadowAttached(shadow, host);
                continue;
            }
            catch (Throwable ex) {
                log.error("Failed to invoke " + ary[j], ex);
            }
        }
    }

    public void afterShadowDetached(ShadowElement shadow, Component prevhost) {
        UiLifeCycle[] ary = (UiLifeCycle[])this._uiCycles.toArray();
        for (int j = 0; j < ary.length; ++j) {
            try {
                ary[j].afterShadowDetached(shadow, prevhost);
                continue;
            }
            catch (Throwable ex) {
                log.error("Failed to invoke " + ary[j], ex);
            }
        }
    }

    public void afterComponentMoved(Component parent, Component child, Component prevparent) {
        UiLifeCycle[] ary = (UiLifeCycle[])this._uiCycles.toArray();
        for (int j = 0; j < ary.length; ++j) {
            try {
                ary[j].afterComponentMoved(parent, child, prevparent);
                continue;
            }
            catch (Throwable ex) {
                log.error("Failed to invoke " + ary[j], ex);
            }
        }
    }

    public void afterPageAttached(Page page, Desktop desktop) {
        UiLifeCycle[] ary = (UiLifeCycle[])this._uiCycles.toArray();
        for (int j = 0; j < ary.length; ++j) {
            try {
                ary[j].afterPageAttached(page, desktop);
                continue;
            }
            catch (Throwable ex) {
                log.error("Failed to invoke " + ary[j], ex);
            }
        }
    }

    public void afterPageDetached(Page page, Desktop prevdesktop) {
        UiLifeCycle[] ary = (UiLifeCycle[])this._uiCycles.toArray();
        for (int j = 0; j < ary.length; ++j) {
            try {
                ary[j].afterPageDetached(page, prevdesktop);
                continue;
            }
            catch (Throwable ex) {
                log.error("Failed to invoke " + ary[j], ex);
            }
        }
    }

    public void addThemeURI(String uri) {
        if (uri == null || uri.length() == 0) {
            throw new IllegalArgumentException("empty");
        }
        this._themeURIs.add((Object)uri);
    }

    public String[] getThemeURIs() {
        return (String[])this._themeURIs.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDisabledThemeURI(String uri) {
        if (uri == null || uri.length() == 0) {
            throw new IllegalArgumentException();
        }
        Configuration configuration = this;
        synchronized (configuration) {
            if (this._disThemeURIs == null) {
                this._disThemeURIs = Collections.synchronizedSet(new HashSet(4));
            }
        }
        this._disThemeURIs.add(uri);
    }

    public Set<String> getDisabledThemeURIs() {
        if (this._disThemeURIs != null) {
            return this._disThemeURIs;
        }
        return Collections.emptySet();
    }

    public ThemeProvider getThemeProvider() {
        return this._themeProvider;
    }

    public void setThemeProvider(ThemeProvider provider) {
        this._themeProvider = provider;
    }

    public void setUiEngineClass(Class<?> cls) {
        if (cls != null && !UiEngine.class.isAssignableFrom(cls)) {
            throw new IllegalArgumentException("UiEngine not implemented: " + cls);
        }
        this._uiengcls = cls;
    }

    public Class<?> getUiEngineClass() {
        return this._uiengcls;
    }

    public void setWebAppClass(Class<?> cls) {
        if (!(cls == null || WebApp.class.isAssignableFrom(cls) && WebAppCtrl.class.isAssignableFrom(cls))) {
            throw new IllegalArgumentException("WebApp or WebAppCtrl not implemented: " + cls);
        }
        this._wappcls = cls;
    }

    public Class<?> getWebAppClass() {
        return this._wappcls;
    }

    public void setWebAppFactoryClass(Class<?> cls) {
        if (cls != null && !WebAppFactory.class.isAssignableFrom(cls)) {
            throw new IllegalArgumentException("WebAppFactory not implemented: " + cls);
        }
        this._wappftycls = cls;
    }

    public Class<?> getWebAppFactoryClass() {
        return this._wappftycls;
    }

    public void setDesktopCacheProviderClass(Class<?> cls) {
        if (cls != null && !DesktopCacheProvider.class.isAssignableFrom(cls)) {
            throw new IllegalArgumentException("DesktopCacheProvider not implemented: " + cls);
        }
        this._dcpcls = cls;
    }

    public Class<?> getDesktopCacheProviderClass() {
        return this._dcpcls;
    }

    public void setUiFactoryClass(Class<?> cls) {
        if (cls != null && !UiFactory.class.isAssignableFrom(cls)) {
            throw new IllegalArgumentException("UiFactory not implemented: " + cls);
        }
        this._uiftycls = cls;
    }

    public Class<?> getUiFactoryClass() {
        return this._uiftycls;
    }

    public void setFailoverManagerClass(Class<?> cls) {
        if (cls != null && !FailoverManager.class.isAssignableFrom(cls)) {
            throw new IllegalArgumentException("FailoverManager not implemented: " + cls);
        }
        this._failmancls = cls;
    }

    public Class<?> getFailoverManagerClass() {
        return this._failmancls;
    }

    public void setIdGeneratorClass(Class<?> cls) {
        if (cls != null && !IdGenerator.class.isAssignableFrom(cls)) {
            throw new IllegalArgumentException("IdGenerator not implemented: " + cls);
        }
        this._idgencls = cls;
    }

    public Class<?> getIdGeneratorClass() {
        return this._idgencls;
    }

    public void setSessionCacheClass(Class<?> cls) {
        if (cls != null && !SessionCache.class.isAssignableFrom(cls)) {
            throw new IllegalArgumentException("SessionCache not implemented: " + cls);
        }
        this._sesscachecls = cls;
    }

    public Class<?> getSessionCacheClass() {
        return this._sesscachecls;
    }

    public void setFileItemFactoryClass(Class<?> cls) {
        if (cls != null && !DiskFileItemFactory.class.isAssignableFrom(cls)) {
            throw new IllegalArgumentException("DiskFileItemFactory not implemented: " + cls);
        }
        this._fileFactory = cls;
    }

    public Class<?> getFileItemFactoryClass() {
        return this._fileFactory;
    }

    public void setAuDecoderClass(Class<?> cls) {
        if (cls != null && !AuDecoder.class.isAssignableFrom(cls)) {
            throw new IllegalArgumentException("AuDecoder not implemented: " + cls);
        }
        this._audeccls = cls;
    }

    public Class<?> getAuDecoderClass() {
        return this._audeccls;
    }

    public void setMaxProcessTime(int time) {
        this._maxProcTime = time;
    }

    public int getMaxProcessTime() {
        return this._maxProcTime;
    }

    public void setMaxUploadSize(int sz) {
        this._maxUploadSize = sz;
    }

    public int getMaxUploadSize() {
        return this._maxUploadSize;
    }

    public void setFileSizeThreshold(int sz) {
        this._fileSizeThreshold = sz;
    }

    public int getFileSizeThreshold() {
        return this._fileSizeThreshold;
    }

    public void setFileRepository(String directory) {
        this._fileRepository = directory;
    }

    public String getFileRepository() {
        return this._fileRepository;
    }

    public String getUploadCharset() {
        return this._charsetUpload;
    }

    public void setUploadCharset(String charset) {
        this._charsetUpload = charset != null && charset.length() > 0 ? charset : "UTF-8";
    }

    public CharsetFinder getUploadCharsetFinder() {
        return this._charsetFinderUpload;
    }

    public void setUploadCharsetFinder(CharsetFinder finder) {
        this._charsetFinderUpload = finder;
    }

    public void setDesktopMaxInactiveInterval(int secs) {
        this._dtTimeout = secs;
    }

    public int getDesktopMaxInactiveInterval() {
        return this._dtTimeout;
    }

    public void setProcessingPromptDelay(int minisecs) {
        this._promptDelay = minisecs;
    }

    public int getProcessingPromptDelay() {
        return this._promptDelay;
    }

    public void setClickFilterDelay(int minisecs) {
    }

    public int getClickFilterDelay() {
        return 0;
    }

    public void setTooltipDelay(int minisecs) {
        this._tooltipDelay = minisecs;
    }

    public int getTooltipDelay() {
        return this._tooltipDelay;
    }

    public void setAutoResendTimeout(int minisecs) {
        this._autoResendTimeout = minisecs;
    }

    public int getAutoResendTimeout() {
        return this._autoResendTimeout;
    }

    public void setResendDelay(int minisecs) {
    }

    public int getResendDelay() {
        return -1;
    }

    public boolean isCrawlable() {
        return this._crawlable;
    }

    public void setCrawlable(boolean crawlable) {
        if (crawlable && !WebApps.getFeature("ee")) {
            log.warn("The crawlable setting is for EE edtion only!");
            return;
        }
        this._crawlable = crawlable;
    }

    public URIInfo getTimeoutURI(String deviceType) {
        TimeoutURIInfo inf;
        if (deviceType == null) {
            deviceType = "ajax";
        }
        return (inf = this._timeoutURIs.get(deviceType)) != null && inf.uri != null ? inf : null;
    }

    public URIInfo setTimeoutURI(String deviceType, String timeoutURI, int type) {
        TimeoutURIInfo newi;
        TimeoutURIInfo oldi;
        if (deviceType == null) {
            deviceType = "ajax";
        }
        if ((oldi = this._timeoutURIs.put(deviceType, newi = new TimeoutURIInfo(timeoutURI, type))) != null) {
            newi.auto = oldi.auto;
        }
        return oldi != null && oldi.uri != null ? oldi : null;
    }

    public String getTimeoutMessage(String deviceType) {
        TimeoutURIInfo inf;
        if (deviceType == null) {
            deviceType = "ajax";
        }
        return (inf = this._timeoutURIs.get(deviceType)) != null ? inf.message : null;
    }

    public String setTimeoutMessage(String deviceType, String message) {
        TimeoutURIInfo inf;
        if (deviceType == null) {
            deviceType = "ajax";
        }
        if ((inf = this._timeoutURIs.get(deviceType)) != null) {
            String old = inf.message;
            inf.message = message;
            return old;
        }
        inf = new TimeoutURIInfo();
        inf.message = message;
        this._timeoutURIs.put(deviceType, inf);
        return null;
    }

    public boolean isAutomaticTimeout(String deviceType) {
        TimeoutURIInfo inf;
        if (deviceType == null) {
            deviceType = "ajax";
        }
        return (inf = this._timeoutURIs.get(deviceType)) != null && inf.auto;
    }

    public boolean setAutomaticTimeout(String deviceType, boolean auto) {
        TimeoutURIInfo inf;
        if (deviceType == null) {
            deviceType = "ajax";
        }
        if ((inf = this._timeoutURIs.get(deviceType)) != null) {
            boolean old = inf.auto;
            inf.auto = auto;
            return old;
        }
        inf = new TimeoutURIInfo();
        inf.auto = auto;
        this._timeoutURIs.put(deviceType, inf);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String setClientErrorReload(String deviceType, int errCode, String uri, String connType) {
        if (uri == null) {
            return this.removeClientErrorReload(deviceType, errCode, connType);
        }
        String index = Configuration.deviceConn2Str(deviceType, connType);
        Map<String, Map<Integer, String>> map = this._errURIs;
        synchronized (map) {
            Map<Integer, String> map2 = this._errURIs.get(index);
            if (map2 == null) {
                map2 = new LinkedHashMap<Integer, String>();
                this._errURIs.put(index, map2);
            }
            return map2.put(errCode, uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String removeClientErrorReload(String deviceType, int errCode, String connType) {
        String index = Configuration.deviceConn2Str(deviceType, connType);
        Map<String, Map<Integer, String>> map = this._errURIs;
        synchronized (map) {
            Map<Integer, String> map2 = this._errURIs.get(index);
            return map2 != null ? map2.remove(errCode) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClientErrorReload(String deviceType, int errCode, String connType) {
        String index = Configuration.deviceConn2Str(deviceType, connType);
        Map<String, Map<Integer, String>> map = this._errURIs;
        synchronized (map) {
            Map<Integer, String> map2 = this._errURIs.get(index);
            return map2 != null ? map2.get(errCode) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[][] getClientErrorReloads(String deviceType, String connType) {
        String index = Configuration.deviceConn2Str(deviceType, connType);
        Map<String, Map<Integer, String>> map = this._errURIs;
        synchronized (map) {
            Map<Integer, String> map2 = this._errURIs.get(index);
            if (map2 != null) {
                Object[][] infs = new Object[map2.size()][2];
                int j = 0;
                for (Map.Entry<Integer, String> me : map2.entrySet()) {
                    infs[j][0] = me.getKey();
                    infs[j++][1] = new URIInfo(me.getValue());
                }
                return infs;
            }
        }
        return new Object[0][0];
    }

    private static final String deviceConn2Str(String deviceType, String connType) {
        if (deviceType == null) {
            deviceType = "ajax";
        }
        return connType != null && "server-push".equals(connType) ? "s:" + deviceType : deviceType;
    }

    public void setSessionMaxInactiveInterval(int secs) {
        this._sessTimeout = secs;
    }

    public int getSessionMaxInactiveInterval() {
        return this._sessTimeout;
    }

    public void setSessionMaxDesktops(int max) {
        this._sessDktMax = max;
    }

    public int getSessionMaxDesktops() {
        return this._sessDktMax;
    }

    public void setSessionMaxRequests(int max) {
        this._sessReqMax = max;
    }

    public int getSessionMaxRequests() {
        return this._sessReqMax;
    }

    public void setSessionMaxPushes(int max) {
        this._sessPushMax = max;
    }

    public int getSessionMaxPushes() {
        return this._sessPushMax;
    }

    public void setMaxSpareThreads(int max) {
        this._sparThdMax = max;
    }

    public int getMaxSpareThreads() {
        return this._sparThdMax;
    }

    public void setMaxSuspendedThreads(int max) {
        this._suspThdMax = max;
    }

    public int getMaxSuspendedThreads() {
        return this._suspThdMax;
    }

    public void enableEventThread(boolean enable) {
        UiEngine engine;
        if (!enable && this._wapp != null && (engine = ((WebAppCtrl)((Object)this._wapp)).getUiEngine()) != null && engine.hasSuspendedThread()) {
            throw new IllegalStateException("Unable to disable due to suspended threads");
        }
        if (enable) {
            log.warn("Enable event thread has deprecated!");
        }
        this._evtThdEnabled = enable;
    }

    public boolean isEventThreadEnabled() {
        return this._evtThdEnabled;
    }

    public void enableZScript(boolean enable) {
        this._zscriptEnabled = enable;
    }

    public boolean isZScriptEnabled() {
        return this._zscriptEnabled;
    }

    public Monitor getMonitor() {
        return this._monitor;
    }

    public Monitor setMonitor(Monitor monitor) {
        Monitor old = this._monitor;
        this._monitor = monitor;
        return old;
    }

    public PerformanceMeter getPerformanceMeter() {
        return this._pfmeter;
    }

    public PerformanceMeter setPerformanceMeter(PerformanceMeter meter) {
        PerformanceMeter old = this._pfmeter;
        this._pfmeter = meter;
        return old;
    }

    public ExecutionMonitor getExecutionMonitor() {
        return this._execmon;
    }

    public ExecutionMonitor setExecutionMonitor(ExecutionMonitor monitor) {
        ExecutionMonitor old = this._execmon;
        this._execmon = monitor;
        return old;
    }

    public DesktopRecycle getDesktopRecycle() {
        return this._dtRecycle;
    }

    public DesktopRecycle setDesktopRecycle(DesktopRecycle dtRecycle) {
        DesktopRecycle old = this._dtRecycle;
        this._dtRecycle = dtRecycle;
        return old;
    }

    public String getResponseCharset() {
        return this._charsetResp;
    }

    public void setResponseCharset(String charset) {
        this._charsetResp = charset != null && charset.length() > 0 ? charset : null;
    }

    public String getPreference(String name, String defaultValue) {
        String value = this._prefs.get(name);
        return value != null ? value : defaultValue;
    }

    public void setPreference(String name, String value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException("null");
        }
        this._prefs.put(name, value);
    }

    public Set<String> getPreferenceNames() {
        return this._prefs.keySet();
    }

    public Object addRichlet(String name, Class<?> richletClass, Map<String, String> params) {
        if (!Richlet.class.isAssignableFrom(richletClass)) {
            throw new IllegalArgumentException("A richlet class, " + richletClass + ", must implement " + Richlet.class.getName());
        }
        return this.addRichlet0(name, richletClass, params);
    }

    public Object addRichlet(String name, String richletClassName, Map<String, String> params) {
        if (richletClassName == null || richletClassName.length() == 0) {
            throw new IllegalArgumentException("richletClassName is required");
        }
        return this.addRichlet0(name, richletClassName, params);
    }

    public Object addRichlet(String name, Richlet richlet) {
        if (richlet == null) {
            throw new IllegalArgumentException("richlet instance is required");
        }
        return this.addRichlet0(name, richlet, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object addRichlet0(String name, Object richletClass, Map<String, String> params) {
        Object o;
        while (true) {
            o = this.removeRichlet0(name);
            Map<String, Object> map = this._richlets;
            synchronized (map) {
                if (!this._richlets.containsKey(name)) {
                    if (richletClass instanceof Richlet) {
                        this._richlets.put(name, richletClass);
                    } else {
                        this._richlets.put(name, new Object[]{richletClass, params});
                    }
                    break;
                }
            }
        }
        return o;
    }

    public Object removeRichlet(String name) {
        Object o = this.removeRichlet0(name);
        this.removeRichletMapping(name);
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object removeRichlet0(String name) {
        Object o;
        block7: {
            WaitLock lock;
            if (name == null) {
                throw new IllegalArgumentException("Name is required");
            }
            do {
                Map<String, Object> map = this._richlets;
                synchronized (map) {
                    o = this._richlets.remove(name);
                }
                if (!(o instanceof WaitLock)) break block7;
            } while ((lock = (WaitLock)o).waitUntilUnlock(300000));
            String msg = "Unable to remove richlet " + name + "\nCause: conflict too long.";
            PotentialDeadLockException ex = new PotentialDeadLockException(msg);
            log.warn(msg, (Throwable)ex);
            throw ex;
        }
        if (o == null) {
            return null;
        }
        if (o instanceof Richlet) {
            Configuration.destroy((Richlet)o);
            return o.getClass();
        }
        return ((Object[])o)[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRichletMapping(String name, String path) {
        if (path == null || path.length() == 0 || "/".equals(path)) {
            path = "";
        } else if (path.charAt(0) != '/') {
            throw new IllegalArgumentException("path must start with '/', not " + path);
        }
        boolean wildcard = path.endsWith("/*");
        if (wildcard) {
            path = path.substring(0, path.length() - 2);
        }
        Map<String, Object> map = this._richlets;
        synchronized (map) {
            if (!this._richlets.containsKey(name)) {
                throw new UiException("Richlet not defined: " + name);
            }
            Map<String, Object[]> map2 = this._richletmaps;
            synchronized (map2) {
                this._richletmaps.put(path, new Object[]{name, wildcard});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRichletMapping(String name) {
        Map<String, Object[]> map = this._richletmaps;
        synchronized (map) {
            Iterator<Map.Entry<String, Object[]>> iter = this._richletmaps.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, Object[]> entry = iter.next();
                String richletName = (String)entry.getValue()[0];
                if (!richletName.equals(name)) continue;
                iter.remove();
            }
        }
    }

    private static void destroy(Richlet richlet) {
        try {
            richlet.destroy();
        }
        catch (Throwable ex) {
            log.error("Unable to destroy " + richlet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Richlet getRichlet(String name) {
        Object[] info;
        WaitLock lock;
        block21: {
            lock = null;
            do {
                Map<String, Object> map = this._richlets;
                synchronized (map) {
                    Object o = this._richlets.get(name);
                    if (o == null || o instanceof Richlet) {
                        return (Richlet)o;
                    }
                    if (!(o instanceof WaitLock)) {
                        info = (Object[])o;
                        lock = new WaitLock();
                        this._richlets.put(name, lock);
                        break block21;
                    }
                    lock = (WaitLock)o;
                }
            } while (lock.waitUntilUnlock(300000));
            PotentialDeadLockException ex = new PotentialDeadLockException("Unable to load richlet " + name + "\nCause: conflict too long.");
            log.warn("", (Throwable)ex);
            throw ex;
        }
        try {
            Object o;
            if (info[0] instanceof String) {
                try {
                    info[0] = Classes.forNameByThread((String)((String)info[0]));
                }
                catch (Throwable ex) {
                    throw new UiException("Failed to load " + info[0]);
                }
            }
            if (!((o = ((Class)info[0]).newInstance()) instanceof Richlet)) {
                throw new UiException(Richlet.class + " must be implemented by " + info[0]);
            }
            Richlet richlet = (Richlet)o;
            richlet.init(this.newRichletConfig((Map)info[1]));
            Object object = this._richlets;
            synchronized (object) {
                this._richlets.put(name, richlet);
            }
            object = richlet;
            return object;
        }
        catch (Throwable ex) {
            Map<String, Object> map = this._richlets;
            synchronized (map) {
                this._richlets.put(name, info);
            }
            throw UiException.Aide.wrap(ex, "Unable to instantiate " + info[0]);
        }
        finally {
            lock.unlock();
        }
    }

    private RichletConfig newRichletConfig(Map<String, String> params) {
        return new RichletConfigImpl(this._wapp, params);
    }

    public Richlet getRichletByPath(String path) {
        int len;
        if (path == null || path.length() == 0 || "/".equals(path)) {
            path = "";
        } else if (path.charAt(0) != '/') {
            path = '/' + path;
        }
        int j = len = path.length();
        Richlet richlet;
        while ((richlet = this.getRichletByPath0(path.substring(0, j), j != len)) == null && j != 0) {
            j = path.lastIndexOf(47, j - 1);
        }
        return richlet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Richlet getRichletByPath0(String path, boolean wildcardOnly) {
        Object[] info;
        Map<String, Object[]> map = this._richletmaps;
        synchronized (map) {
            info = this._richletmaps.get(path);
        }
        return info != null && (!wildcardOnly || (Boolean)info[1] != false) ? this.getRichlet((String)info[0]) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detroyRichlets() {
        Map<String, Object> map = this._richlets;
        synchronized (map) {
            for (Object o : this._richlets.values()) {
                if (!(o instanceof Richlet)) continue;
                Configuration.destroy((Richlet)o);
            }
            this._richlets.clear();
        }
    }

    public void setKeepDesktopAcrossVisits(boolean keep) {
        this._keepDesktop = keep;
    }

    public boolean isKeepDesktopAcrossVisits() {
        return this._keepDesktop;
    }

    public void setTimerKeepAlive(boolean alive) {
        this._timerKeepAlive = alive;
    }

    public boolean isTimerKeepAlive() {
        return this._timerKeepAlive;
    }

    public boolean isDebugJS() {
        return this._debugJS;
    }

    public void setDebugJS(boolean debug) {
        this._debugJS = debug;
        if (this._wapp != null) {
            Utils.updateDebugJS(this._wapp, debug);
        }
    }

    public boolean isRepeatUuid() {
        return this._repeatUuid;
    }

    public void setRepeatUuid(boolean repeat) {
        this._repeatUuid = repeat;
    }

    public void setExpressionFactoryClass(Class<? extends ExpressionFactory> expfcls) {
        Expressions.setExpressionFactoryClass(expfcls);
    }

    public Class<? extends ExpressionFactory> getExpressionFactoryClass() {
        return Expressions.getExpressionFactoryClass();
    }

    public Event beforeSendEvent(Event event) {
        return this._eis.beforeSendEvent(event);
    }

    public Event beforePostEvent(Event event) {
        return this._eis.beforePostEvent(event);
    }

    public Event beforeProcessEvent(Event event) {
        return this._eis.beforeProcessEvent(event);
    }

    public void afterProcessEvent(Event event) {
        this._eis.afterProcessEvent(event);
    }

    public Map<String, Object> getAttributes() {
        return this._attrs;
    }

    public Object getAttribute(String name) {
        return this._attrs.get(name);
    }

    public Object setAttribute(String name, Object value) {
        return value != null ? this._attrs.put(name, value) : this.removeAttribute(name);
    }

    public Object removeAttribute(String name) {
        return this._attrs.remove(name);
    }

    public void addClientPackage(String pkg) {
        if (pkg == null || pkg.length() == 0) {
            throw new IllegalArgumentException("empty");
        }
        this._clientpkgs.add((Object)pkg);
    }

    public String[] getClientPackages() {
        return (String[])this._clientpkgs.toArray();
    }

    public int getEventTimeWarning() {
        return this._evtTimeWarn;
    }

    public void setEventTimeWarning(int secs) {
        this._evtTimeWarn = secs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addErrorPage(String deviceType, Class<?> type, String location) {
        List<ErrorPage> l;
        if (!Throwable.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("Throwable or derived is required: " + type);
        }
        if (location == null || deviceType == null) {
            throw new IllegalArgumentException();
        }
        Map<String, List<ErrorPage>> map = this._errpgs;
        synchronized (map) {
            l = this._errpgs.get(deviceType);
            if (l == null) {
                l = new LinkedList<ErrorPage>();
                this._errpgs.put(deviceType, l);
            }
        }
        String previous = null;
        List<ErrorPage> list = l;
        synchronized (list) {
            Iterator<ErrorPage> it = l.iterator();
            while (it.hasNext()) {
                ErrorPage errpg = it.next();
                if (!errpg.type.equals(type)) continue;
                previous = errpg.location;
                it.remove();
                break;
            }
            l.add(new ErrorPage(type, location));
        }
        return previous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getErrorPage(String deviceType, Throwable error) {
        if (!this._errpgs.isEmpty()) {
            List<ErrorPage> l;
            Object object = this._errpgs;
            synchronized (object) {
                l = this._errpgs.get(deviceType);
            }
            if (l != null) {
                object = l;
                synchronized (object) {
                    for (ErrorPage errpg : l) {
                        if (!errpg.type.isInstance(error)) continue;
                        return errpg.location;
                    }
                }
            }
        }
        return null;
    }

    public boolean isCustomThemeProvider() {
        return this._customThemeProvider;
    }

    public void setCustomThemeProvider(boolean customThemeProvider) {
        this._customThemeProvider = customThemeProvider;
    }

    public boolean isCustomThemeRegistry() {
        return this._customThemeRegistry;
    }

    public void setCustomThemeRegistry(boolean customThemeRegistry) {
        this._customThemeRegistry = customThemeRegistry;
    }

    public boolean isCustomThemeResolver() {
        return this._customThemeResolver;
    }

    public void setCustomThemeResolver(boolean customThemeResolver) {
        this._customThemeResolver = customThemeResolver;
    }

    public void setInitCrashScript(String script) {
        this._initCrashScript = script;
    }

    public void setInitCrashTimeout(int timeout) {
        this._initCrashTimeout = timeout;
    }

    public String getInitCrashScript() {
        return this._initCrashScript;
    }

    public int getInitCrashTimeout() {
        return this._initCrashTimeout;
    }

    public String getBinderInitAttribute() {
        return this._binderInitAttribute;
    }

    public void setBinderInitAttribute(String _binderInitAttribute) {
        this._binderInitAttribute = _binderInitAttribute;
    }

    public Set<String> getBinderAnnotations() {
        return this._binderAnnotations;
    }

    public void setBinderAnnotations(Set<String> binderAnnotations) {
        this._binderAnnotations = new HashSet<String>(binderAnnotations);
    }

    public void addDataHandler(DataHandlerInfo info) {
        String name = info.getName();
        DataHandlerInfo old = this._dataHandlers.put(name, info);
        if (info.isOverride()) {
            if (old == null) {
                log.warn("The data handler cannot be overridden! Not existing: [" + name + "]");
            }
        } else if (old != null) {
            log.warn("The data handler has been defined! [" + name + "]\n Please use <override>true</override> to disable the warning.");
        }
    }

    public Map<String, DataHandlerInfo> getDataHandlers() {
        return this._dataHandlers;
    }

    public void enableSourceMap(boolean enable) {
        this._sourceMapEnabled = enable;
    }

    public boolean isSourceMapEnabled() {
        return this._sourceMapEnabled;
    }

    private static class TimeoutURIInfo
    extends URIInfo {
        private String message;
        private boolean auto;

        private TimeoutURIInfo() {
            super(null);
        }

        private TimeoutURIInfo(String uri, int type) {
            super(uri, type);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SameClass
    implements Comparable<Object> {
        private final Class<?> _klass;

        private SameClass(Class<?> klass) {
            this._klass = klass;
        }

        @Override
        public int compareTo(Object o) {
            return o.getClass().equals(this._klass) ? 0 : 1;
        }

        public String toString() {
            return Objects.toString(this._klass);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return Objects.equals(this._klass, (Object)(o instanceof SameClass ? ((SameClass)((Object)o))._klass : o));
        }

        public int hashCode() {
            return Objects.hashCode(this._klass);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ErrorPage {
        private final Class<?> type;
        private final String location;

        private ErrorPage(Class<?> type, String location) {
            this.type = type;
            this.location = location;
        }
    }
}

