/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.metainfo;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.zkoss.idom.Namespace;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.ext.Native;
import org.zkoss.zk.ui.metainfo.ComponentDefinition;
import org.zkoss.zk.ui.metainfo.ComponentInfo;
import org.zkoss.zk.ui.metainfo.NodeInfo;
import org.zkoss.zk.xel.EvaluatorRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeInfo
extends ComponentInfo {
    private List<NodeInfo> _prokids;
    private List<NodeInfo> _epikids;
    private NativeInfo _splitkid;
    private List<Namespace> _dns;

    public NativeInfo(NodeInfo parent, ComponentDefinition compdef, String tag) {
        super(parent, compdef, tag);
        if (!compdef.isNative()) {
            throw new IllegalArgumentException("compdef must be native");
        }
    }

    public NativeInfo(EvaluatorRef evlar, ComponentDefinition compdef, String tag) {
        super(evlar, compdef, tag);
    }

    public List<Namespace> getDeclaredNamespaces() {
        if (this._dns != null) {
            return this._dns;
        }
        return Collections.emptyList();
    }

    public void addDeclaredNamespace(Namespace ns) {
        if (this._dns == null) {
            this._dns = new LinkedList<Namespace>();
        }
        this._dns.add(ns);
    }

    public List<NodeInfo> getPrologChildren() {
        if (this._prokids != null) {
            return this._prokids;
        }
        return Collections.emptyList();
    }

    public List<NodeInfo> getEpilogChildren() {
        if (this._epikids != null) {
            return this._epikids;
        }
        return Collections.emptyList();
    }

    public void addPrologChild(NodeInfo child) {
        if (this._prokids == null) {
            this._prokids = new LinkedList<NodeInfo>();
        }
        this._prokids.add(child);
    }

    public void addEpilogChild(NodeInfo child) {
        if (this._epikids == null) {
            this._epikids = new LinkedList<NodeInfo>();
        }
        this._epikids.add(child);
    }

    public NativeInfo getSplitChild() {
        return this._splitkid;
    }

    public void setSplitChild(NativeInfo child) {
        this._splitkid = child;
    }

    @Override
    public Component newInstance(Page page, Component parent) {
        Component comp = super.newInstance(page, parent);
        if (this._dns != null) {
            Native nc = (Native)((Object)comp);
            for (Namespace ns : this._dns) {
                nc.addDeclaredNamespace(ns);
            }
        }
        return comp;
    }
}

