/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.impl;

import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.ui.util.Initiator;
import org.zkoss.zk.ui.util.InitiatorExt;

class Initiators {
    static final Logger log = LoggerFactory.getLogger(Initiators.class);

    public static final Initiators doInit(PageDefinition pagedef, Page page, Initiator[] sysinits) {
        if (sysinits != null) {
            try {
                for (int j = 0; j < sysinits.length; ++j) {
                    sysinits[j].doInit(page, Collections.EMPTY_MAP);
                }
            }
            catch (Throwable ex) {
                throw UiException.Aide.wrap(ex);
            }
        }
        List<Initiator> inits = pagedef != null ? pagedef.doInit(page) : null;
        boolean sysinitEx = false;
        if (sysinits != null) {
            for (int j = 0; j < sysinits.length; ++j) {
                if (!(sysinits[j] instanceof InitiatorExt)) continue;
                sysinitEx = true;
                break;
            }
        }
        boolean initEx = false;
        if (inits != null) {
            for (Initiator init : inits) {
                if (!(init instanceof InitiatorExt)) continue;
                initEx = true;
                break;
            }
        }
        if (!sysinitEx && !initEx) {
            return new Initiators();
        }
        return new RealInits(sysinits, inits, sysinitEx, initEx);
    }

    protected Initiators() {
    }

    public void doAfterCompose(Page page, Component[] comps) throws Exception {
    }

    public boolean doCatch(Throwable t) {
        return false;
    }

    public void doFinally() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RealInits
    extends Initiators {
        private final Initiator[] _sysinits;
        private final List<Initiator> _inits;
        private boolean _sysinitEx;
        private boolean _initEx;

        private RealInits(Initiator[] sysinits, List<Initiator> inits, boolean sysinitEx, boolean initEx) {
            this._sysinits = sysinits;
            this._inits = inits;
            this._sysinitEx = sysinitEx;
            this._initEx = initEx;
        }

        @Override
        public void doAfterCompose(Page page, Component[] comps) throws Exception {
            if (this._sysinitEx) {
                for (int j = 0; j < this._sysinits.length; ++j) {
                    Initiator init = this._sysinits[j];
                    if (!(init instanceof InitiatorExt)) continue;
                    if (comps == null) {
                        comps = new Component[]{};
                    }
                    ((InitiatorExt)((Object)init)).doAfterCompose(page, comps);
                }
            }
            if (this._initEx) {
                for (Initiator init : this._inits) {
                    if (!(init instanceof InitiatorExt)) continue;
                    if (comps == null) {
                        comps = new Component[]{};
                    }
                    ((InitiatorExt)((Object)init)).doAfterCompose(page, comps);
                }
            }
        }

        @Override
        public boolean doCatch(Throwable t) {
            if (this._sysinitEx) {
                for (int j = 0; j < this._sysinits.length; ++j) {
                    Initiator init = this._sysinits[j];
                    if (!(init instanceof InitiatorExt)) continue;
                    try {
                        if (((InitiatorExt)((Object)init)).doCatch(t)) {
                            return true;
                        }
                        continue;
                    }
                    catch (Throwable ex) {
                        log.error("", ex);
                    }
                }
            }
            if (this._initEx) {
                for (Initiator init : this._inits) {
                    if (!(init instanceof InitiatorExt)) continue;
                    try {
                        if (!((InitiatorExt)((Object)init)).doCatch(t)) continue;
                        return true;
                    }
                    catch (Throwable ex) {
                        log.error("", ex);
                    }
                }
            }
            return false;
        }

        @Override
        public void doFinally() {
            Throwable t = null;
            if (this._sysinitEx) {
                for (int j = 0; j < this._sysinits.length; ++j) {
                    Initiator init = this._sysinits[j];
                    if (!(init instanceof InitiatorExt)) continue;
                    try {
                        ((InitiatorExt)((Object)init)).doFinally();
                        continue;
                    }
                    catch (Throwable ex) {
                        log.error("", ex);
                        if (t != null) continue;
                        t = ex;
                    }
                }
            }
            if (this._initEx) {
                for (Initiator init : this._inits) {
                    if (!(init instanceof InitiatorExt)) continue;
                    try {
                        ((InitiatorExt)((Object)init)).doFinally();
                    }
                    catch (Throwable ex) {
                        log.error("", ex);
                        if (t != null) continue;
                        t = ex;
                    }
                }
            }
            if (t != null) {
                throw UiException.Aide.wrap(t);
            }
        }
    }
}

