/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.http;

import java.util.List;
import javax.servlet.http.HttpSession;
import javax.websocket.HandshakeResponse;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpointConfig;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.WebApps;
import org.zkoss.zk.ui.sys.DesktopCache;
import org.zkoss.zk.ui.sys.SessionCtrl;
import org.zkoss.zk.ui.sys.SessionsCtrl;
import org.zkoss.zk.ui.sys.Storage;

public final class ZKWebSocket
extends ServerEndpointConfig.Configurator {
    public void modifyHandshake(ServerEndpointConfig config, HandshakeRequest request, HandshakeResponse response) {
        HttpSession httpSession = (HttpSession)request.getHttpSession();
        Session sess = SessionsCtrl.getSession(WebApps.getCurrent(), httpSession);
        config.getUserProperties().put(((Object)((Object)this)).getClass().getName(), sess);
    }

    public static Storage getDesktopStorage(javax.websocket.Session wsession) {
        Desktop desktop = ZKWebSocket.getDesktop(wsession);
        return desktop == null ? null : desktop.getStorage();
    }

    public static Desktop getDesktop(javax.websocket.Session wsession) {
        Session session = (Session)wsession.getUserProperties().get(ZKWebSocket.class.getName());
        if (session == null) {
            throw new IllegalStateException("ZK Session cannot be null!");
        }
        List dtids = (List)wsession.getRequestParameterMap().get("dtid");
        if (dtids.isEmpty()) {
            throw new IllegalStateException("the value of the key with 'dtid' cannot be null!");
        }
        DesktopCache desktopCache = ((SessionCtrl)((Object)session)).getDesktopCache();
        return desktopCache != null ? desktopCache.getDesktopIfAny((String)dtids.get(0)) : null;
    }
}

