/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.http;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.zkoss.util.CollectionsX;
import org.zkoss.web.servlet.xel.AttributesMap;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.ext.ScopeListener;
import org.zkoss.zk.ui.http.WebManager;
import org.zkoss.zk.ui.impl.AbstractWebApp;
import org.zkoss.zk.ui.impl.ScopeListeners;
import org.zkoss.zk.ui.sys.Registry;
import org.zkoss.zk.ui.sys.WebAppFactoryImpl;
import org.zkoss.zk.ui.util.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleWebApp
extends AbstractWebApp {
    private ServletContext _ctx;
    private final ScopeListeners _scopeListeners = new ScopeListeners(this);
    private final Map<String, Object> _attrs = new AttributesMap(){

        protected Enumeration<String> getKeys() {
            return SimpleWebApp.this._ctx.getAttributeNames();
        }

        protected Object getValue(String key) {
            return SimpleWebApp.this._ctx.getAttribute(key);
        }

        protected void setValue(String key, Object val) {
            SimpleWebApp.this._ctx.setAttribute(key, val);
        }

        protected void removeValue(String key) {
            SimpleWebApp.this._ctx.removeAttribute(key);
        }
    };

    @Override
    public void init(Object context, Configuration config) {
        if (context == null) {
            throw new IllegalArgumentException("context");
        }
        this._ctx = (ServletContext)context;
        super.init(context, config);
        Registry.sign(this, Registry.class, WebManager.class, WebAppFactoryImpl.class);
    }

    @Override
    public Object getAttribute(String name) {
        return this._ctx.getAttribute(name);
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.getAttribute(name) != null;
    }

    @Override
    public Object setAttribute(String name, Object value) {
        Object old = this._ctx.getAttribute(name);
        this._ctx.setAttribute(name, value);
        return old;
    }

    @Override
    public Object removeAttribute(String name) {
        Object old = this._ctx.getAttribute(name);
        this._ctx.removeAttribute(name);
        return old;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this._attrs;
    }

    @Override
    public boolean addScopeListener(ScopeListener listener) {
        return this._scopeListeners.addScopeListener(listener);
    }

    @Override
    public boolean removeScopeListener(ScopeListener listener) {
        return this._scopeListeners.removeScopeListener(listener);
    }

    ScopeListeners getScopeListeners() {
        return this._scopeListeners;
    }

    @Override
    public String getUpdateURI() {
        return this.getUpdateURI(true);
    }

    @Override
    public String getUpdateURI(boolean encode) {
        String uri = this.getWebManager().getUpdateURI();
        return encode ? Executions.getCurrent().encodeURL(uri) : uri;
    }

    private WebManager getWebManager() {
        return WebManager.getWebManager(this);
    }

    @Override
    public WebApp getWebApp(String uripath) {
        WebManager webman;
        ServletContext another = this._ctx.getContext(uripath);
        if (another != null && (webman = WebManager.getWebManagerIfAny(another)) != null) {
            return webman.getWebApp();
        }
        return null;
    }

    public String getDirectory() {
        return null;
    }

    @Override
    public URL getResource(String path) {
        if (path.startsWith("~./")) {
            return this.getWebManager().getClassWebResource().getResource(path.substring(2));
        }
        try {
            return this._ctx.getResource(path);
        }
        catch (MalformedURLException ex) {
            throw new UiException("Failed to retrieve " + path, (Throwable)ex);
        }
    }

    @Override
    public InputStream getResourceAsStream(String path) {
        if (path.startsWith("~./")) {
            return this.getWebManager().getClassWebResource().getResourceAsStream(path.substring(2));
        }
        return this._ctx.getResourceAsStream(path);
    }

    @Override
    public String getInitParameter(String name) {
        return this._ctx.getInitParameter(name);
    }

    @Override
    public Iterable<String> getInitParameterNames() {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new CollectionsX.EnumerationIterator(SimpleWebApp.this._ctx.getInitParameterNames());
            }
        };
    }

    @Override
    public String getRealPath(String path) {
        return this._ctx.getRealPath(path);
    }

    @Override
    public String getMimeType(String file) {
        return this._ctx.getMimeType(file);
    }

    @Override
    public Set<String> getResourcePaths(String path) {
        return this._ctx.getResourcePaths(path);
    }

    @Override
    public Object getNativeContext() {
        return this._ctx;
    }

    @Override
    public ServletContext getServletContext() {
        return this._ctx;
    }

    @Override
    public void log(String msg) {
        this._ctx.log(msg);
    }

    @Override
    public void log(String msg, Throwable ex) {
        this._ctx.log(msg, ex);
    }
}

