/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.event.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.lang.Threads;
import org.zkoss.util.CollectionsX;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.DesktopUnavailableException;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.EventQueue;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.sys.DesktopCtrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DesktopEventQueue<T extends Event>
implements EventQueue<T>,
Serializable {
    static final Logger log = LoggerFactory.getLogger(DesktopEventQueue.class);
    private static final String ON_QUEUE = "onQueue";
    private final Component _dummyTarget = new AbstractComponent();
    private final List<ListenerInfo<T>> _listenerInfos = new LinkedList<ListenerInfo<T>>();
    private int _nAsync;
    private boolean _serverPushEnabled;
    private boolean _closed;

    public DesktopEventQueue() {
        this._dummyTarget.addEventListener(ON_QUEUE, new QueueListener());
    }

    public boolean isIdle() {
        return this._listenerInfos.isEmpty();
    }

    @Override
    public void publish(T event) {
        if (event == null) {
            throw new IllegalArgumentException();
        }
        if (Executions.getCurrent() == null) {
            DesktopEventQueue.currentThread().postEvent(event);
        } else {
            Events.postEvent(ON_QUEUE, this._dummyTarget, event);
        }
    }

    private static final <W extends Event> AsyncListenerThread<W> currentThread() {
        Thread thd = Thread.currentThread();
        if (!(thd instanceof AsyncListenerThread)) {
            throw new IllegalStateException("publish() can be called only in an event listener");
        }
        return (AsyncListenerThread)thd;
    }

    @Override
    public void subscribe(EventListener<T> listener) {
        this.subscribe(listener, null, false);
    }

    @Override
    public void subscribe(EventListener<T> listener, EventListener<T> callback) {
        this.subscribe(listener, callback, true);
    }

    @Override
    public void subscribe(EventListener<T> listener, boolean async) {
        this.subscribe(listener, null, async);
    }

    private void subscribe(EventListener<T> listener, EventListener<T> callback, boolean async) {
        if (async && this._nAsync++ == 0) {
            Execution exec = Executions.getCurrent();
            if (exec == null) {
                throw new IllegalStateException("Execution required");
            }
            ((DesktopCtrl)((Object)exec.getDesktop())).enableServerPush(true, this);
            this._serverPushEnabled = true;
        }
        if (log.isDebugEnabled()) {
            log.debug("Subscribe event queue, async is [" + async + "]");
        }
        this._listenerInfos.add(new ListenerInfo(listener, callback, async));
    }

    @Override
    public boolean unsubscribe(EventListener<T> listener) {
        if (listener != null) {
            Iterator<ListenerInfo<T>> it = this._listenerInfos.iterator();
            while (it.hasNext()) {
                ListenerInfo<T> inf = it.next();
                if (!listener.equals(inf.listener)) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Unsubscribe event queue");
                }
                it.remove();
                if (inf.async && --this._nAsync == 0 && this._serverPushEnabled) {
                    ((DesktopCtrl)((Object)Executions.getCurrent().getDesktop())).enableServerPush(false, this);
                }
                return true;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Not found in the unsubscribe event queue");
        }
        return false;
    }

    @Override
    public boolean isSubscribed(EventListener<T> listener) {
        if (listener != null) {
            for (ListenerInfo<T> li : this._listenerInfos) {
                if (!listener.equals(li.listener)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void close() {
        this._closed = true;
        this._listenerInfos.clear();
        if (this._serverPushEnabled) {
            try {
                ((DesktopCtrl)((Object)Executions.getCurrent().getDesktop())).enableServerPush(false, this);
            }
            catch (Throwable ex) {
                log.warn("Ingored: unable to stop server push", ex);
            }
        }
    }

    @Override
    public boolean isClose() {
        return this._closed;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AsyncListenerThread<T extends Event>
    extends Thread {
        private static final Logger log = log;
        final Desktop _desktop = Executions.getCurrent().getDesktop();
        private final EventQueue<T> _que;
        private final ListenerInfo<T> _inf;
        private final T _event;
        private List<T> _pendingEvents;

        private AsyncListenerThread(EventQueue<T> que, ListenerInfo<T> inf, T event) {
            this._que = que;
            this._inf = inf;
            this._event = event;
            Threads.setDaemon((Thread)this, (boolean)true);
        }

        void postEvent(T event) {
            if (this._pendingEvents == null) {
                this._pendingEvents = new LinkedList<T>();
            }
            this._pendingEvents.add(event);
        }

        @Override
        public void run() {
            block9: {
                try {
                    this._inf.listener.onEvent(this._event);
                    if (this._inf.callback == null && this._pendingEvents == null) break block9;
                    Executions.activate(this._desktop);
                    try {
                        if (this._pendingEvents != null) {
                            for (Event evt : this._pendingEvents) {
                                this._que.publish(evt);
                            }
                        }
                        if (this._inf.callback != null) {
                            this._inf.callback.onEvent(this._event);
                        }
                    }
                    finally {
                        Executions.deactivate(this._desktop);
                    }
                }
                catch (DesktopUnavailableException ex) {
                    log.warn("", (Throwable)((Object)ex));
                }
                catch (Throwable ex) {
                    log.error("", ex);
                    throw UiException.Aide.wrap(ex);
                }
            }
        }

        /* synthetic */ AsyncListenerThread(EventQueue x0, ListenerInfo x1, Event x2, 1 x3) {
            this(x0, x1, x2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListenerInfo<T extends Event>
    implements Serializable {
        final EventListener<T> listener;
        final EventListener<T> callback;
        final boolean async;

        private ListenerInfo(EventListener<T> listener, EventListener<T> callback, boolean async) {
            if (listener == null) {
                throw new IllegalArgumentException();
            }
            this.listener = listener;
            this.callback = callback;
            this.async = async;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueueListener
    implements EventListener<Event>,
    Serializable {
        private QueueListener() {
        }

        @Override
        public void onEvent(Event event) throws Exception {
            Event evt = (Event)event.getData();
            Iterator it = CollectionsX.comodifiableIterator((Collection)DesktopEventQueue.this._listenerInfos);
            while (it.hasNext()) {
                ListenerInfo inf = (ListenerInfo)it.next();
                if (inf.async) {
                    new AsyncListenerThread(DesktopEventQueue.this, inf, evt, null).start();
                    continue;
                }
                inf.listener.onEvent(evt);
            }
        }
    }
}

