/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.event;

import java.util.Map;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuRequests;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;

public class SwipeEvent
extends Event {
    private int _swipeX;
    private int _swipeY;
    private int _swipeTime;
    private String _swipeDir;

    public static final SwipeEvent getSwipeEvent(AuRequest request) {
        Map<String, Object> data = request.getData();
        Object dir = data.get("dir");
        String swipeDir = dir == null ? "" : (String)dir;
        return new SwipeEvent(request.getCommand(), request.getComponent(), AuRequests.getInt(data, "dispX", 0), AuRequests.getInt(data, "dispY", 0), AuRequests.getInt(data, "dispT", 0), swipeDir);
    }

    public SwipeEvent(String name, Component target, int swipeX, int swipeY, int swipeTime, String swipeDir) {
        super(name, target);
        this._swipeX = swipeX;
        this._swipeY = swipeY;
        this._swipeTime = swipeTime;
        this._swipeDir = swipeDir;
    }

    public int getSwipeX() {
        return this._swipeX;
    }

    public int getSwipeY() {
        return this._swipeY;
    }

    public int getSwipeDuration() {
        return this._swipeTime;
    }

    public String getSwipeDirection() {
        return this._swipeDir;
    }
}

