/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.zkoss.io.Serializables;
import org.zkoss.lang.Library;
import org.zkoss.lang.Objects;
import org.zkoss.xel.VariableResolver;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.SerializableEventListener;
import org.zkoss.zk.ui.ext.Macro;
import org.zkoss.zk.ui.select.Selectors;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.util.ConventionWires;

public class HtmlMacroComponent
extends HtmlBasedComponent
implements Macro {
    private transient Map<String, Object> _props;
    private String _uri;
    private Component[] _inlines;
    private String _tag = "div";
    protected final List<VariableResolver> _resolvers;
    private static Integer _autowireflag;

    public HtmlMacroComponent() {
        this.setAttribute("z$is", Boolean.TRUE);
        this.init();
        this._resolvers = Selectors.newVariableResolvers(this.getClass(), HtmlMacroComponent.class);
        if (HtmlMacroComponent.getAutowireFlag() == 0) {
            Selectors.wireVariables(this, (Object)this, this._resolvers);
        }
    }

    private void init() {
        this._props = new LinkedHashMap<String, Object>();
        this._props.put("includer", this);
    }

    public String getWidgetClass() {
        return "zk.Macro";
    }

    public String getEnclosingTag() {
        return this._tag;
    }

    public void setEnclosingTag(String tag) {
        if (tag == null || tag.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (!this._tag.equals(tag)) {
            this._tag = tag;
            this.smartUpdate("enclosingTag", this._tag);
        }
    }

    public void afterCompose() {
        this.compose();
    }

    protected void compose() {
        Execution exec = Executions.getCurrent();
        if (exec == null) {
            throw new IllegalStateException("No execution available");
        }
        if (this.isInline()) {
            if (this._inlines != null) {
                return;
            }
            this._inlines = exec.createComponents(this._uri != null ? this._uri : this.getDefinition().getMacroURI(), this._props);
        } else {
            if (!this.getChildren().isEmpty()) {
                return;
            }
            exec.createComponents(this._uri != null ? this._uri : this.getDefinition().getMacroURI(), (Component)this, this._props);
        }
        switch (HtmlMacroComponent.getAutowireFlag()) {
            case 0: {
                Selectors.wireComponents(this, (Object)this, false);
                Selectors.wireEventListeners(this, this);
                this.addEventListener("onCreate", new AfterCreateWireListener());
                break;
            }
            case 1: {
                ConventionWires.wireVariables(this, (Object)this, '$', true, true);
                ConventionWires.addForwards(this, this, '$');
            }
        }
    }

    private static int getAutowireFlag() {
        if (_autowireflag == null) {
            _autowireflag = "true".equals(Library.getProperty((String)"org.zkoss.zk.ui.macro.autowire.disabled")) ? -1 : ("true".equals(Library.getProperty((String)"org.zkoss.zk.ui.macro.autowire.convention")) ? 1 : 0);
        }
        return _autowireflag;
    }

    public String getMacroURI() {
        return this._uri != null ? this._uri : this.getDefinition().getMacroURI();
    }

    public void setMacroURI(String uri) {
        if (!Objects.equals((Object)this._uri, (Object)uri)) {
            if (uri != null && uri.length() == 0) {
                throw new IllegalArgumentException("empty");
            }
            this._uri = uri;
            if (this.getParent() != null) {
                this.recreate();
            }
        }
    }

    public void recreate() {
        if (this._inlines != null) {
            for (int j = 0; j < this._inlines.length; ++j) {
                this._inlines[j].detach();
            }
            this._inlines = null;
        } else {
            this.getChildren().clear();
            this.invalidate();
        }
        this.compose();
    }

    public boolean isInline() {
        return this.getDefinition().isInlineMacro();
    }

    public void setParent(Component parent) {
        if (this.isInline()) {
            if (this._inlines == null) {
                this.compose();
            }
            for (int j = 0; j < this._inlines.length; ++j) {
                this._inlines[j].setParent(parent);
            }
        } else {
            super.setParent(parent);
        }
    }

    public boolean setInlineParent(Component parent, Component beforeSibling) {
        if (!this.isInline()) {
            throw new InternalError("inline only");
        }
        if (this._inlines == null) {
            this.compose();
        }
        boolean inserted = false;
        for (int j = 0; j < this._inlines.length; ++j) {
            if (!parent.insertBefore(this._inlines[j], beforeSibling)) continue;
            inserted = true;
        }
        return inserted;
    }

    public void setPage(Page page) {
        if (this.isInline()) {
            if (this._inlines == null) {
                this.compose();
            }
            for (int j = 0; j < this._inlines.length; ++j) {
                this._inlines[j].setPage(page);
            }
        } else {
            super.setPage(page);
        }
    }

    protected boolean isChildable() {
        return !this.isInline();
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        this._props.remove("includer");
        Serializables.smartWrite((ObjectOutputStream)s, this._props);
        this._props.put("includer", this);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init();
        Serializables.smartRead((ObjectInputStream)s, this._props);
    }

    public Object clone() {
        HtmlMacroComponent clone = (HtmlMacroComponent)super.clone();
        clone.init();
        clone._props.putAll(this._props);
        clone._props.put("includer", clone);
        if (this._inlines != null) {
            clone._inlines = new Component[this._inlines.length];
            for (int j = 0; j < this._inlines.length; ++j) {
                clone._inlines[j] = (Component)this._inlines[j].clone();
            }
        }
        return clone;
    }

    public boolean hasDynamicProperty(String name) {
        return this._props.containsKey(name);
    }

    public Object getDynamicProperty(String name) {
        return this._props.get(name);
    }

    public void setDynamicProperty(String name, Object value) throws WrongValueException {
        this._props.put(name, value);
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (!"div".equals(this._tag)) {
            renderer.render("enclosingTag", this._tag);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AfterCreateWireListener
    implements SerializableEventListener<Event> {
        private static final long serialVersionUID = 1L;

        private AfterCreateWireListener() {
        }

        @Override
        public void onEvent(Event event) throws Exception {
            HtmlMacroComponent hmcomp = HtmlMacroComponent.this;
            Selectors.wireEventListeners(hmcomp, hmcomp);
            HtmlMacroComponent.this.removeEventListener("onCreate", this);
        }
    }
}

