/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.ComponentNotFoundException;
import org.zkoss.zk.ui.IdSpace;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.sys.PageCtrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPage
implements Page,
PageCtrl,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(AbstractPage.class);
    private transient AbstractComponent _firstRoot;
    private transient AbstractComponent _lastRoot;
    private int _nRoot;
    private transient Collection<Component> _roots;
    private transient Map<String, Component> _fellows;

    protected AbstractPage() {
        this.init();
    }

    private void init() {
        this._roots = new Roots();
        this._fellows = new HashMap<String, Component>();
    }

    @Override
    public Component getFirstRoot() {
        return this._firstRoot;
    }

    @Override
    public Component getLastRoot() {
        return this._lastRoot;
    }

    @Override
    public boolean hasFellow(String compId) {
        return this._fellows.containsKey(compId);
    }

    @Override
    public boolean hasFellow(String compId, boolean recurse) {
        return this.hasFellow(compId);
    }

    @Override
    public Component getFellow(String compId) throws ComponentNotFoundException {
        Component comp = this._fellows.get(compId);
        if (comp == null) {
            throw new ComponentNotFoundException("Fellow component not found: " + compId);
        }
        return comp;
    }

    @Override
    public Component getFellow(String compId, boolean recurse) throws ComponentNotFoundException {
        return this.getFellow(compId);
    }

    @Override
    public Component getFellowIfAny(String compId) {
        return this._fellows.get(compId);
    }

    @Override
    public Component getFellowIfAny(String compId, boolean recurse) {
        return this.getFellowIfAny(compId);
    }

    @Override
    public Collection<Component> getFellows() {
        return Collections.unmodifiableCollection(this._fellows.values());
    }

    void addFellow(Component comp) {
        String compId = comp.getId();
        Component old = this._fellows.put(compId, comp);
        if (old != comp && old != null) {
            this._fellows.put(old.getId(), old);
            throw new InternalError("Called shall prevent replicated ID for roots");
        }
    }

    void removeFellow(Component comp) {
        this._fellows.remove(comp.getId());
    }

    void addRoot(Component comp) {
        AbstractComponent nc = (AbstractComponent)comp;
        AbstractComponent ac = this._firstRoot;
        while (ac != null) {
            if (ac == nc) {
                log.warn("Ignored adding " + comp + " twice");
                return;
            }
            ac = ac._next;
        }
        if (this._lastRoot == null) {
            this._firstRoot = this._lastRoot = nc;
            nc._prev = null;
            nc._next = null;
        } else {
            this._lastRoot._next = nc;
            nc._prev = this._lastRoot;
            nc._next = null;
            this._lastRoot = nc;
        }
        ++this._nRoot;
    }

    void removeRoot(Component comp) {
        if (this.isMyRoot(comp)) {
            AbstractComponent oc = (AbstractComponent)comp;
            this.setNext(oc._prev, oc._next);
            this.setPrev(oc._next, oc._prev);
            oc._prev = null;
            oc._next = null;
            --this._nRoot;
        }
    }

    void onReplaced(AbstractComponent from, AbstractComponent to) {
        if (this._firstRoot == from) {
            this._firstRoot = to;
        }
        if (this._lastRoot == from) {
            this._lastRoot = to;
        }
    }

    private boolean isMyRoot(Component comp) {
        AbstractComponent ac = this._firstRoot;
        while (ac != null) {
            if (ac == comp) {
                return true;
            }
            ac = ac._next;
        }
        return false;
    }

    private final void setNext(AbstractComponent comp, AbstractComponent next) {
        if (comp != null) {
            comp._next = next;
        } else {
            this._firstRoot = next;
        }
    }

    private final void setPrev(AbstractComponent comp, AbstractComponent prev) {
        if (comp != null) {
            comp._prev = prev;
        } else {
            this._lastRoot = prev;
        }
    }

    void moveRoot(Component comp, Component refRoot) {
        AbstractComponent nc = (AbstractComponent)comp;
        if (!this.isMyRoot(comp) || nc._next == refRoot) {
            return;
        }
        this.setNext(nc._prev, nc._next);
        this.setPrev(nc._next, nc._prev);
        nc._prev = null;
        nc._next = null;
        --this._nRoot;
        if (refRoot != null) {
            AbstractComponent ref = (AbstractComponent)refRoot;
            this.setNext(nc, ref);
            this.setPrev(nc, ref._prev);
            this.setNext(ref._prev, nc);
            this.setPrev(ref, nc);
            ++this._nRoot;
        } else {
            this.addRoot(nc);
        }
    }

    @Override
    public Collection<Component> getRoots() {
        return this._roots;
    }

    @Override
    public void removeComponents() {
        AbstractComponent c = this._lastRoot;
        while (c != null) {
            AbstractComponent p = c._prev;
            c.detach();
            c = p;
        }
    }

    @Override
    public void destroy() {
        this._firstRoot = null;
        this._nRoot = 0;
        this._fellows = new HashMap<String, Component>(2);
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        AbstractComponent p = this._firstRoot;
        while (p != null) {
            s.writeObject(p);
            p = p._next;
        }
        s.writeObject(null);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init();
        AbstractComponent q = null;
        while (true) {
            AbstractComponent child;
            if ((child = (AbstractComponent)s.readObject()) == null) break;
            if (q != null) {
                q._next = child;
            } else {
                this._firstRoot = child;
            }
            child._prev = q;
            child._page = this;
            q = child;
        }
        this._lastRoot = q;
        this.fixFellows(this.getRoots());
    }

    private final void fixFellows(Collection<Component> c) {
        for (Component comp : c) {
            String compId = comp.getId();
            if (compId.length() > 0) {
                this.addFellow(comp);
            }
            if (comp instanceof IdSpace) continue;
            this.fixFellows(comp.getChildren());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RootIter
    implements Iterator<Component> {
        private AbstractComponent _p;

        private RootIter(AbstractComponent first) {
            this._p = first;
        }

        @Override
        public boolean hasNext() {
            return this._p != null;
        }

        @Override
        public Component next() {
            AbstractComponent c = this._p;
            this._p = this._p._next;
            return c;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Roots
    extends AbstractCollection<Component> {
        private Roots() {
        }

        @Override
        public int size() {
            return AbstractPage.this._nRoot;
        }

        @Override
        public Iterator<Component> iterator() {
            return new RootIter(AbstractPage.this._firstRoot);
        }
    }
}

