/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.scripting.bsh;

import bsh.BshMethod;
import bsh.NameSpace;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.zkoss.zk.scripting.SerializableAware;
import org.zkoss.zk.scripting.bsh.BSHInterpreter;
import org.zkoss.zk.scripting.bsh.NSWrap;
import org.zkoss.zk.ui.ext.Scope;

class NSWrapSR
extends NSWrap
implements Serializable {
    private static final Logger log = BSHInterpreter.log;
    private Map<String, Object> _vars;
    private List<BshMethod> _mtds;
    private List<String> _clses;
    private List<String> _pkgs;

    NSWrapSR(NameSpace ns) {
        super(ns);
    }

    public NSWrapSR() {
    }

    public NameSpace unwrap(Scope scope) {
        if (this._bshns == null) {
            this._bshns = BSHInterpreter.getInterpreter(scope).newNS(scope);
            if (this._vars != null) {
                for (Map.Entry<String, Object> me : this._vars.entrySet()) {
                    try {
                        this._bshns.setVariable(me.getKey(), me.getValue(), false);
                    }
                    catch (Throwable ex) {
                        log.warn("Ignored failure of set " + me.getKey(), ex);
                    }
                }
                this._vars = null;
            }
            if (this._mtds != null) {
                for (BshMethod mtd : this._mtds) {
                    try {
                        this._bshns.setMethod(mtd.getName(), mtd);
                    }
                    catch (Throwable ex) {
                        log.warn("Ignored failure of set " + mtd, ex);
                    }
                }
                this._mtds = null;
            }
            if (this._clses != null) {
                for (String name : this._clses) {
                    try {
                        this._bshns.importClass(name);
                    }
                    catch (Throwable ex) {
                        log.warn("Ignored failure of import class " + name, ex);
                    }
                }
                this._clses = null;
            }
            if (this._pkgs != null) {
                for (String name : this._pkgs) {
                    try {
                        this._bshns.importPackage(name);
                    }
                    catch (Throwable ex) {
                        log.warn("Ignored failure of import package " + name, ex);
                    }
                }
                this._pkgs = null;
            }
        }
        return this._bshns;
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeBoolean(this._bshns != null);
        if (this._bshns != null) {
            BSHInterpreter.write(this._bshns, s, new SerializableAware.Filter(){

                public boolean accept(String name, Object value) {
                    return value == null || value instanceof Serializable || value instanceof Externalizable;
                }
            });
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (s.readBoolean()) {
            BSHInterpreter.read(new NameSpace(null, null, "nst"){

                public void setVariable(String name, Object value, boolean strictJava) {
                    if (NSWrapSR.this._vars == null) {
                        NSWrapSR.this._vars = new HashMap();
                    }
                    NSWrapSR.this._vars.put(name, value);
                }

                public void setMethod(String name, BshMethod mtd) {
                    if (NSWrapSR.this._mtds == null) {
                        NSWrapSR.this._mtds = new LinkedList();
                    }
                    NSWrapSR.this._mtds.add(mtd);
                }

                public void importClass(String name) {
                    if (NSWrapSR.this._clses == null) {
                        NSWrapSR.this._clses = new LinkedList();
                    }
                    NSWrapSR.this._clses.add(name);
                }

                public void importPackage(String name) {
                    if (NSWrapSR.this._pkgs == null) {
                        NSWrapSR.this._pkgs = new LinkedList();
                    }
                    NSWrapSR.this._pkgs.add(name);
                }

                public void loadDefaultImports() {
                }
            }, s);
        }
    }
}

