/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.device;

import java.io.IOException;
import java.util.Locale;
import org.zkoss.util.Locales;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.device.Devices;
import org.zkoss.zk.device.GenericDevice;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.http.Wpds;
import org.zkoss.zk.ui.metainfo.LanguageDefinition;
import org.zkoss.zk.ui.metainfo.MessageLoader;
import org.zkoss.zk.ui.util.Clients;

public class AjaxDevice
extends GenericDevice {
    public boolean isCacheable() {
        return false;
    }

    public Boolean isCompatible(String userAgent) {
        return (userAgent = userAgent.toLowerCase(Locale.ENGLISH)).indexOf("mozilla") >= 0 || userAgent.indexOf("msie ") >= 0 || userAgent.indexOf("gecko/") >= 0 || userAgent.indexOf("safari") >= 0 || userAgent.indexOf("opera") >= 0 ? Boolean.TRUE : null;
    }

    public String getContentType() {
        return "text/html";
    }

    public String getDocType() {
        return "<!DOCTYPE html>";
    }

    public String packageToPath(String pkg) {
        return "/js/" + pkg + ".wpd";
    }

    public String toAbsolutePath(String path) {
        char cc = path.length() > 0 ? path.charAt(0) : (char)'\u0000';
        return cc != '/' && cc != '~' ? "/js/" + path : path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadMessages(Locale locale) throws IOException {
        if (locale == null) {
            locale = Locales.getCurrent();
        }
        StringBuffer sb = new StringBuffer(4096);
        Locale oldl = Locales.setThreadLocal((Locale)locale);
        try {
            Execution exec = Executions.getCurrent();
            sb.append(Devices.loadJavaScript(exec, "~./js/zk/lang/msgzk*.js"));
            sb.append(Wpds.outLocaleJavaScript());
            for (LanguageDefinition langdef : LanguageDefinition.getByDeviceType(this.getType())) {
                for (MessageLoader loader : langdef.getMessageLoaders()) {
                    loader.load(sb, exec);
                }
            }
        }
        finally {
            Locales.setThreadLocal((Locale)oldl);
        }
        Clients.response("zk.reload", new AuScript(null, sb.toString()));
    }
}

