/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.au.http;

import java.io.IOException;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.zkoss.json.JSONArray;
import org.zkoss.json.JSONObject;
import org.zkoss.web.servlet.http.Https;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.AuWriter;
import org.zkoss.zk.au.AuWriters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpAuWriter
implements AuWriter {
    private JSONObject _out;
    private JSONArray _rs;
    private byte[] _result;
    private boolean _compress = true;

    public boolean isCompress() {
        return this._compress;
    }

    @Override
    public void setCompress(boolean compress) {
        this._compress = compress;
    }

    @Override
    public AuWriter open(Object request, Object response) throws IOException {
        ((HttpServletResponse)response).setContentType(AuWriters.CONTENT_TYPE);
        this._rs = new JSONArray();
        this._out = AuWriters.getJSONOutput(this._rs);
        return this;
    }

    @Override
    public void close(Object request, Object response) throws IOException {
        this.flush(request, response, this._compress);
    }

    @Override
    public void resend(Object prevContent) throws IOException {
        if (prevContent == null) {
            throw new IllegalArgumentException();
        }
        if (this._result != null || !this._rs.isEmpty()) {
            throw new IllegalStateException(this._rs.isEmpty() ? "resend twice or complete?" : "write called");
        }
        this._result = this.restore(prevContent);
        this._out = null;
        this._rs = null;
    }

    @Override
    public Object complete() throws IOException {
        if (this._result != null) {
            throw new IllegalStateException();
        }
        this._result = this._out.toString().getBytes("UTF-8");
        this._out = null;
        this._rs = null;
        return this.save(this._result);
    }

    protected void flush(Object request, Object response, boolean bCompress) throws IOException {
        byte[] bs;
        if (this._result == null) {
            this._result = this._out.toString().getBytes("UTF-8");
            this._out = null;
            this._rs = null;
        }
        HttpServletRequest hreq = (HttpServletRequest)request;
        HttpServletResponse hres = (HttpServletResponse)response;
        if (bCompress && this._result.length > 200 && (bs = Https.gzip((HttpServletRequest)hreq, (HttpServletResponse)hres, null, (byte[])this._result)) != null) {
            this._result = bs;
        }
        hres.setContentType(AuWriters.CONTENT_TYPE);
        hres.setContentLength(this._result.length);
        hres.getOutputStream().write(this._result);
        hres.flushBuffer();
    }

    protected Object save(byte[] data) {
        return data;
    }

    protected byte[] restore(Object data) {
        return (byte[])data;
    }

    @Override
    public void writeResponseId(int resId) throws IOException {
        this._out.put((Object)"rid", (Object)new Integer(resId));
    }

    @Override
    public void write(AuResponse response) throws IOException {
        this._rs.add((Object)AuWriters.toJSON(response));
    }

    @Override
    public void write(Collection<AuResponse> responses) throws IOException {
        for (AuResponse response : responses) {
            this.write(response);
        }
    }
}

