/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.web;

import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.binary.Base64;
import org.compiere.model.MUser;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class AdempiereMonitorFilter
implements Filter {
    protected CLogger log = CLogger.getCLogger(this.getClass());
    private static final String AUTHORIZATION = "AdempiereAuthorization";
    private Long m_authorization = System.currentTimeMillis();

    public void init(FilterConfig config) throws ServletException {
        this.log.info("");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String errorPage = "/error.html";
        boolean pass = false;
        try {
            if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
                request.getRequestDispatcher(errorPage).forward(request, response);
                return;
            }
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse resp = (HttpServletResponse)response;
            HttpSession session = req.getSession(true);
            Long compare = (Long)session.getAttribute(AUTHORIZATION);
            if (compare != null && compare.compareTo(this.m_authorization) == 0) {
                pass = true;
            } else if (this.checkAuthorization(req.getHeader("Authorization"))) {
                session.setAttribute(AUTHORIZATION, (Object)this.m_authorization);
                pass = true;
            }
            if (pass) {
                chain.doFilter(request, response);
            } else {
                resp.setStatus(401);
                resp.setHeader("WWW-Authenticate", "BASIC realm=\"Adempiere Server\"");
            }
            return;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "filter", (Throwable)e);
            request.getRequestDispatcher(errorPage).forward(request, response);
            return;
        }
    }

    private boolean checkAuthorization(String authorization) {
        String name;
        block7: {
            MUser user;
            block6: {
                if (authorization == null) {
                    return false;
                }
                try {
                    String userInfo = authorization.substring(6).trim();
                    Base64 decoder = new Base64();
                    String namePassword = new String(decoder.decode(userInfo.getBytes()));
                    int index = namePassword.indexOf(58);
                    name = namePassword.substring(0, index);
                    String password = namePassword.substring(index + 1);
                    user = MUser.get((Properties)Env.getCtx(), (String)name, (String)password);
                    if (user != null) break block6;
                    this.log.warning("User not found: '" + name);
                    return false;
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "check", (Throwable)e);
                    return false;
                }
            }
            if (user.isAdministrator()) break block7;
            this.log.warning("Not a Sys Admin = " + name);
            return false;
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Name=" + name);
        }
        return true;
    }

    public void destroy() {
        this.log.info("");
    }
}

