/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.server;

import java.io.File;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.impexp.ArrayExcelExporter;
import org.compiere.Adempiere;
import org.compiere.model.AdempiereProcessor;
import org.compiere.model.MAlert;
import org.compiere.model.MAlertProcessor;
import org.compiere.model.MAlertProcessorLog;
import org.compiere.model.MAlertRule;
import org.compiere.model.MAttachment;
import org.compiere.model.MClient;
import org.compiere.model.MNote;
import org.compiere.model.MSysConfig;
import org.compiere.model.MUser;
import org.compiere.server.AdempiereServer;
import org.compiere.server.AdempiereServerMgr;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;
import org.compiere.util.ValueNamePair;

public class AlertProcessor
extends AdempiereServer {
    protected MAlertProcessor m_model = null;
    protected StringBuffer m_summary = new StringBuffer();
    protected StringBuffer m_errors = new StringBuffer();
    protected MClient m_client = null;

    public AlertProcessor(MAlertProcessor model) {
        super((AdempiereProcessor)model, 30);
        this.m_model = model;
        this.m_client = MClient.get((Properties)model.getCtx(), (int)model.getAD_Client_ID());
    }

    @Override
    protected void doWork() {
        this.m_summary = new StringBuffer();
        this.m_errors = new StringBuffer();
        int count = 0;
        int countError = 0;
        MAlert[] alerts = this.m_model.getAlerts(false);
        int i = 0;
        while (i < alerts.length) {
            Language language = Env.getLanguage((Properties)this.getCtx());
            MClient client = MClient.get((Properties)this.getCtx(), (int)alerts[i].getAD_Client_ID());
            if (client.getLanguage() != null) {
                language = client.getLanguage();
            }
            if (!this.processAlert(alerts[i], language)) {
                ++countError;
            }
            ++count;
            ++i;
        }
        String summary = "Total=" + count;
        if (countError > 0) {
            summary = String.valueOf(summary) + ", Not processed=" + countError;
        }
        summary = String.valueOf(summary) + " - ";
        this.m_summary.insert(0, summary);
        int no = this.m_model.deleteLog();
        this.m_summary.append("Logs deleted=").append(no);
        MAlertProcessorLog pLog = new MAlertProcessorLog(this.m_model, this.m_summary.toString());
        pLog.setReference("#" + String.valueOf(this.p_runCount) + " - " + TimeUtil.formatElapsed((Timestamp)new Timestamp(this.p_startWork)));
        pLog.setTextMsg(this.m_errors.toString());
        pLog.saveEx();
    }

    protected boolean processAlert(MAlert alert, Language language) {
        if (!alert.isValid()) {
            return false;
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("" + alert);
        }
        StringBuffer message = new StringBuffer(alert.getAlertMessage()).append(Env.NL);
        boolean valid = true;
        boolean processed = false;
        ArrayList<File> attachments = new ArrayList<File>();
        MAlertRule[] rules = alert.getRules(false);
        int i = 0;
        while (i < rules.length) {
            MAlertRule rule;
            if (i > 0) {
                message.append(Env.NL);
            }
            if ((rule = rules[i]).isValid()) {
                int no;
                ValueNamePair error;
                String sql;
                block13: {
                    int no2;
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("" + rule);
                    }
                    if ((sql = rule.getPreProcessing()) != null && sql.length() > 0 && (no2 = DB.executeUpdate((String)sql, (boolean)false, null)) == -1) {
                        error = CLogger.retrieveError();
                        rule.setErrorMsg("Pre=" + error.getName());
                        this.m_errors.append("Pre=" + error.getName());
                        rule.setIsValid(false);
                        rule.saveEx();
                        valid = false;
                        break;
                    }
                    sql = rule.getSql(true);
                    try {
                        String text = null;
                        text = MSysConfig.getBooleanValue((String)"ALERT_SEND_ATTACHMENT_AS_XLS", (boolean)true, (int)alert.getAD_Client_ID()) ? this.getExcelReport(rule, sql, language, null, attachments) : this.getPlainTextReport(rule, sql, null, attachments);
                        if (text == null || text.length() <= 0) break block13;
                        message.append(text);
                        processed = true;
                    }
                    catch (Exception e) {
                        rule.setErrorMsg("Select=" + e.getLocalizedMessage());
                        this.m_errors.append("Select=" + e.getLocalizedMessage());
                        rule.setIsValid(false);
                        rule.saveEx();
                        valid = false;
                        break;
                    }
                }
                if ((sql = rule.getPostProcessing()) != null && sql.length() > 0 && (no = DB.executeUpdate((String)sql, (boolean)false, null)) == -1) {
                    error = CLogger.retrieveError();
                    rule.setErrorMsg("Post=" + error.getName());
                    this.m_errors.append("Post=" + error.getName());
                    rule.setIsValid(false);
                    rule.saveEx();
                    valid = false;
                    break;
                }
            }
            ++i;
        }
        if (!valid) {
            alert.setIsValid(false);
            alert.saveEx();
            return false;
        }
        if (!processed) {
            this.m_summary.append(alert.getName()).append("=No Result - ");
            return true;
        }
        SimpleDateFormat df = DisplayType.getDateFormat((int)16, (Language)language);
        message.append("\n\n");
        message.append(Msg.translate((Language)language, (String)"Date")).append(" : ").append(df.format(new Timestamp(System.currentTimeMillis())));
        Collection users = alert.getRecipientUsers();
        int countMail = this.notifyUsers(users, alert.getAlertSubject(), message.toString(), attachments);
        for (File attachment : attachments) {
            if (!attachment.exists() || attachment.delete()) continue;
            attachment.deleteOnExit();
        }
        this.m_summary.append(alert.getName()).append(" (EMails+Notes=").append(countMail).append(") - ");
        return valid;
    }

    protected int notifyUsers(Collection<Integer> users, String subject, String message, Collection<File> attachments) {
        int countMail = 0;
        for (int user_id : users) {
            MUser user = MUser.get((Properties)this.getCtx(), (int)user_id);
            if (user.isNotificationEMail() && this.m_client.sendEMailAttachments(user_id, subject, message, attachments)) {
                ++countMail;
            }
            if (!user.isNotificationNote()) continue;
            Trx trx = null;
            try {
                try {
                    trx = Trx.get((String)Trx.createTrxName((String)"AP_NU"), (boolean)true);
                    trx.setDisplayName(String.valueOf(this.getClass().getName()) + "_" + this.m_model.getName() + "_notifyUsers");
                    int AD_Message_ID = 52244;
                    MNote note = new MNote(this.getCtx(), AD_Message_ID, user_id, trx.getTrxName());
                    note.setClientOrg(this.m_model.getAD_Client_ID(), this.m_model.getAD_Org_ID());
                    note.setTextMsg(message);
                    note.saveEx();
                    MAttachment attachment = new MAttachment(this.getCtx(), 389, note.getAD_Note_ID(), trx.getTrxName());
                    attachment.setClientOrg(this.m_model.getAD_Client_ID(), this.m_model.getAD_Org_ID());
                    for (File f : attachments) {
                        attachment.addEntry(f);
                    }
                    attachment.setTextMsg(message);
                    attachment.saveEx();
                    ++countMail;
                    trx.commit();
                }
                catch (Throwable e) {
                    if (trx != null) {
                        trx.rollback();
                    }
                    if (trx == null) continue;
                    trx.close();
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (trx != null) {
                    trx.close();
                }
                throw throwable;
            }
            if (trx == null) continue;
            trx.close();
        }
        return countMail;
    }

    protected ArrayList<ArrayList<Object>> getData(String sql, String trxName) throws Exception {
        Exception error;
        ArrayList<ArrayList<Object>> data;
        block10: {
            data = new ArrayList<ArrayList<Object>>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            error = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)trxName);
                    rs = pstmt.executeQuery();
                    ResultSetMetaData meta = rs.getMetaData();
                    boolean isFirstRow = true;
                    while (rs.next()) {
                        ArrayList<String> header = isFirstRow ? new ArrayList<String>() : null;
                        ArrayList<Object> row = new ArrayList<Object>();
                        int col = 1;
                        while (col <= meta.getColumnCount()) {
                            if (isFirstRow) {
                                String columnName = meta.getColumnLabel(col);
                                header.add(columnName);
                            }
                            Object o = rs.getObject(col);
                            row.add(o);
                            ++col;
                        }
                        if (isFirstRow) {
                            data.add(header);
                        }
                        data.add(row);
                        isFirstRow = false;
                    }
                }
                catch (Throwable e) {
                    this.log.log(Level.SEVERE, sql, e);
                    error = e instanceof Exception ? (Exception)e : new Exception(e.getMessage(), e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (error != null) {
            throw new Exception("(" + sql + ") " + Env.NL + error.getLocalizedMessage());
        }
        return data;
    }

    protected String getPlainTextReport(MAlertRule rule, String sql, String trxName, Collection<File> attachments) throws Exception {
        Exception error;
        StringBuilder result;
        block9: {
            result = new StringBuilder();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            error = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)trxName);
                    rs = pstmt.executeQuery();
                    ResultSetMetaData meta = rs.getMetaData();
                    while (rs.next()) {
                        result.append("------------------").append(Env.NL);
                        int col = 1;
                        while (col <= meta.getColumnCount()) {
                            result.append(meta.getColumnLabel(col)).append(" = ");
                            result.append(rs.getString(col));
                            result.append(Env.NL);
                            ++col;
                        }
                    }
                    if (result.length() == 0) {
                        this.log.fine("No rows selected");
                    }
                }
                catch (Throwable e) {
                    this.log.log(Level.SEVERE, sql, e);
                    error = e instanceof Exception ? (Exception)e : new Exception(e.getMessage(), e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block9;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (error != null) {
            throw new Exception("(" + sql + ") " + Env.NL + error.getLocalizedMessage());
        }
        return result.toString();
    }

    protected String getExcelReport(MAlertRule rule, String sql, Language language, String trxName, Collection<File> attachments) throws Exception {
        ArrayList<ArrayList<Object>> data = this.getData(sql, trxName);
        if (data.size() <= 1) {
            return null;
        }
        File file = rule.createReportFile("xls");
        ArrayExcelExporter exporter = new ArrayExcelExporter(this.getCtx(), data);
        exporter.export(file, language, false);
        attachments.add(file);
        String msg = String.valueOf(rule.getName()) + " (" + Msg.translate((Language)language, (String)"SeeAttachment") + " " + file.getName() + ")" + Env.NL;
        return msg;
    }

    @Override
    public String getServerInfo() {
        return "#" + this.p_runCount + " - Last=" + this.m_summary.toString();
    }

    public static void main(String[] args) {
        Adempiere.startup((boolean)true);
        MAlertProcessor model = new MAlertProcessor(Env.getCtx(), 100, null);
        AlertProcessor ap = new AlertProcessor(model);
        AdempiereServerMgr.ServerWrapper wrapper = new AdempiereServerMgr.ServerWrapper(ap);
        wrapper.start();
    }
}

