/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.server;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.adempiere.base.Service;
import org.adempiere.server.AdempiereServerActivator;
import org.adempiere.server.IServerFactory;
import org.compiere.Adempiere;
import org.compiere.model.AdempiereProcessor;
import org.compiere.model.MScheduler;
import org.compiere.model.MSession;
import org.compiere.server.AdempiereServer;
import org.compiere.server.AdempiereServerGroup;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class AdempiereServerMgr
implements ServiceTrackerCustomizer<IServerFactory<AdempiereServer, AdempiereProcessor>, IServerFactory<AdempiereServer, AdempiereProcessor>>,
BundleListener {
    private static ServiceTracker<IServerFactory<AdempiereServer, AdempiereProcessor>, IServerFactory<AdempiereServer, AdempiereProcessor>> serviceTracker;
    public static int SERVER_STATE_NOT_SCHEDULE;
    public static int SERVER_STATE_STARTED;
    public static int SERVER_STATE_STOPPED;
    private static AdempiereServerMgr m_serverMgr;
    protected CLogger log = CLogger.getCLogger(this.getClass());
    private ArrayList<ServerWrapper> m_servers = new ArrayList();
    private Properties m_ctx = Env.getCtx();
    private Timestamp m_start = new Timestamp(System.currentTimeMillis());
    private Set<String> processorClass;

    static {
        SERVER_STATE_NOT_SCHEDULE = 0;
        SERVER_STATE_STARTED = 1;
        SERVER_STATE_STOPPED = 2;
        m_serverMgr = null;
    }

    public static synchronized AdempiereServerMgr get() {
        return AdempiereServerMgr.get(true);
    }

    public static synchronized AdempiereServerMgr get(boolean createNew) {
        if (m_serverMgr == null && createNew) {
            m_serverMgr = new AdempiereServerMgr();
            serviceTracker = new ServiceTracker(AdempiereServerActivator.getBundleContext(), IServerFactory.class.getName(), (ServiceTrackerCustomizer)m_serverMgr);
            serviceTracker.open();
            AdempiereServerActivator.getBundleContext().addBundleListener((BundleListener)m_serverMgr);
        }
        return m_serverMgr;
    }

    private AdempiereServerMgr() {
        this.startEnvironment();
        this.m_servers = new ArrayList();
        this.processorClass = new HashSet<String>();
    }

    private boolean startEnvironment() {
        Adempiere.startup((boolean)false);
        this.log.info("");
        MSession session = MSession.get((Properties)this.getCtx(), (boolean)true);
        session.setWebStoreSession(false);
        session.setWebSession("Server");
        session.saveEx();
        return true;
    }

    public synchronized boolean reload() {
        this.log.info("");
        if (!this.stopAll()) {
            return false;
        }
        int noServers = 0;
        this.m_servers = new ArrayList();
        this.processorClass = new HashSet<String>();
        List serverFactoryList = Service.locator().list(IServerFactory.class).getServices();
        if (serverFactoryList != null && !serverFactoryList.isEmpty()) {
            for (IServerFactory factory : serverFactoryList) {
                this.createServers(factory);
            }
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("#" + noServers);
        }
        return this.startAll();
    }

    private void createServers(IServerFactory<AdempiereServer, AdempiereProcessor> factory) {
        String name = factory.getProcessorClass().getName();
        if (!this.processorClass.contains(name)) {
            this.processorClass.add(name);
            AdempiereServer[] servers = factory.create(this.m_ctx);
            if (servers != null && servers.length > 0) {
                AdempiereServer[] adempiereServerArray = servers;
                int n = servers.length;
                int n2 = 0;
                while (n2 < n) {
                    AdempiereServer server = adempiereServerArray[n2];
                    AdempiereProcessor model = server.getModel();
                    if (AdempiereServer.isOKtoRunOnIP(model)) {
                        this.m_servers.add(new ServerWrapper(server));
                    }
                    ++n2;
                }
            }
        }
    }

    public boolean addScheduler(MScheduler scheduler) {
        String serverId = scheduler.getServerID();
        if (this.getServer(serverId) != null) {
            return false;
        }
        List serverFactoryList = Service.locator().list(IServerFactory.class).getServices();
        if (serverFactoryList != null && !serverFactoryList.isEmpty()) {
            for (IServerFactory factory : serverFactoryList) {
                Object server;
                if (!factory.getProcessorClass().getName().equals(scheduler.getClass().getName()) || (server = factory.create(this.m_ctx, scheduler)) == null || !AdempiereServer.isOKtoRunOnIP((AdempiereProcessor)scheduler)) continue;
                this.m_servers.add(new ServerWrapper((AdempiereServer)server));
                return this.start(serverId);
            }
        }
        return false;
    }

    public Properties getCtx() {
        return this.m_ctx;
    }

    public synchronized boolean startAll() {
        this.log.info("");
        ServerWrapper[] servers = this.getInActive();
        int i = 0;
        while (i < servers.length) {
            ServerWrapper server = servers[i];
            try {
                if (server.scheduleFuture == null || server.scheduleFuture.isDone()) {
                    Env.setContext((Properties)Env.getCtx(), (String)"#AD_Client_ID", (int)server.getServer().getModel().getAD_Client_ID());
                    server.getServer().recalculateSleepMS();
                    server.start();
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "Server: " + server, (Throwable)e);
            }
            ++i;
        }
        Env.setContext((Properties)Env.getCtx(), (String)"#AD_Client_ID", (int)0);
        int noRunning = 0;
        int noStopped = 0;
        int i2 = 0;
        while (i2 < servers.length) {
            ServerWrapper server = servers[i2];
            try {
                if (server.scheduleFuture != null && !server.scheduleFuture.isDone()) {
                    if (this.log.isLoggable(Level.INFO)) {
                        this.log.info("Alive: " + server);
                    }
                    ++noRunning;
                } else {
                    this.log.warning("Dead: " + server);
                    ++noStopped;
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "(checking) - " + server, (Throwable)e);
                ++noStopped;
            }
            ++i2;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Running=" + noRunning + ", Stopped=" + noStopped);
        }
        return noStopped == 0;
    }

    public synchronized boolean start(String serverID) {
        ServerWrapper server = this.getServer(serverID);
        if (server == null) {
            return false;
        }
        if (server.scheduleFuture != null && !server.scheduleFuture.isDone()) {
            return true;
        }
        try {
            try {
                Env.setContext((Properties)Env.getCtx(), (String)"#AD_Client_ID", (int)server.getServer().getModel().getAD_Client_ID());
                server.getServer().recalculateSleepMS();
                server.start();
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "Server=" + serverID, (Throwable)e);
                Env.setContext((Properties)Env.getCtx(), (String)"#AD_Client_ID", (int)0);
                return false;
            }
        }
        finally {
            Env.setContext((Properties)Env.getCtx(), (String)"#AD_Client_ID", (int)0);
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(server.toString());
        }
        return server.scheduleFuture != null && !server.scheduleFuture.isDone();
    }

    public synchronized boolean stopAll() {
        ServerWrapper server;
        this.log.info("");
        ServerWrapper[] servers = this.getActive();
        int i = 0;
        while (i < servers.length) {
            server = servers[i];
            try {
                if (server.scheduleFuture != null && !server.scheduleFuture.isDone()) {
                    server.scheduleFuture.cancel(true);
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "(interrupting) - " + server, (Throwable)e);
            }
            ++i;
        }
        Thread.yield();
        i = 0;
        while (i < servers.length) {
            server = servers[i];
            try {
                int maxWait = 10;
                while (server.scheduleFuture != null && !server.scheduleFuture.isDone()) {
                    if (maxWait-- == 0) {
                        this.log.severe("Wait timeout for interruped " + server);
                        break;
                    }
                    Thread.sleep(100L);
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "(waiting) - " + server, (Throwable)e);
            }
            ++i;
        }
        int noRunning = 0;
        int noStopped = 0;
        int i2 = 0;
        while (i2 < servers.length) {
            ServerWrapper server2 = servers[i2];
            try {
                if (server2.scheduleFuture != null && !server2.scheduleFuture.isDone()) {
                    this.log.warning("Alive: " + server2);
                    ++noRunning;
                } else {
                    if (this.log.isLoggable(Level.INFO)) {
                        this.log.info("Stopped: " + server2);
                    }
                    ++noStopped;
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "(checking) - " + server2, (Throwable)e);
                ++noRunning;
            }
            ++i2;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Running=" + noRunning + ", Stopped=" + noStopped);
        }
        AdempiereServerGroup.get().dump();
        return noRunning == 0;
    }

    public synchronized boolean stop(String serverID) {
        ServerWrapper server = this.getServer(serverID);
        if (server == null) {
            return false;
        }
        if (server.scheduleFuture == null || server.scheduleFuture.isDone()) {
            return true;
        }
        try {
            server.scheduleFuture.cancel(true);
            Thread.sleep(10L);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "stop", (Throwable)e);
            return false;
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(server.toString());
        }
        return server.scheduleFuture == null || server.scheduleFuture.isDone();
    }

    public synchronized void destroy() {
        this.log.info("");
        this.stopAll();
        this.m_servers.clear();
    }

    protected synchronized ServerWrapper[] getActive() {
        ArrayList<ServerWrapper> list = new ArrayList<ServerWrapper>();
        int i = 0;
        while (i < this.m_servers.size()) {
            ServerWrapper server = this.m_servers.get(i);
            if (server != null && server.scheduleFuture != null && !server.scheduleFuture.isDone()) {
                list.add(server);
            }
            ++i;
        }
        ServerWrapper[] retValue = new ServerWrapper[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    protected synchronized ServerWrapper[] getInActive() {
        ArrayList<ServerWrapper> list = new ArrayList<ServerWrapper>();
        int i = 0;
        while (i < this.m_servers.size()) {
            ServerWrapper server = this.m_servers.get(i);
            if (server != null && (server.scheduleFuture == null || server.scheduleFuture.isDone())) {
                list.add(server);
            }
            ++i;
        }
        ServerWrapper[] retValue = new ServerWrapper[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public synchronized ServerWrapper[] getAll() {
        ServerWrapper[] retValue = new ServerWrapper[this.m_servers.size()];
        this.m_servers.toArray(retValue);
        return retValue;
    }

    public synchronized int getStatus(AdempiereProcessor processor) {
        int status = SERVER_STATE_NOT_SCHEDULE;
        int i = 0;
        while (i < this.m_servers.size()) {
            ServerWrapper server = this.m_servers.get(i);
            AdempiereProcessor model = server.server.getModel();
            if (model.getClass().getName().equals(processor.getClass().getName()) && model.getServerID().equals(processor.getServerID())) {
                status = server.scheduleFuture == null || server.scheduleFuture.isDone() ? SERVER_STATE_STOPPED : SERVER_STATE_STARTED;
            }
            ++i;
        }
        return status;
    }

    public synchronized ServerWrapper getServer(String serverID) {
        if (serverID == null) {
            return null;
        }
        int i = 0;
        while (i < this.m_servers.size()) {
            ServerWrapper server = this.m_servers.get(i);
            if (serverID.equals(server.server.getServerID())) {
                return server;
            }
            ++i;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AdempiereServerMgr[");
        sb.append("Servers=").append(this.m_servers.size()).append(",ContextSize=").append(this.m_ctx.size()).append(",Started=").append(this.m_start).append("]");
        return sb.toString();
    }

    public String getDescription() {
        return "$Revision: 1.4 $";
    }

    public synchronized String getServerCount() {
        int noRunning = 0;
        int noStopped = 0;
        int i = 0;
        while (i < this.m_servers.size()) {
            ServerWrapper server = this.m_servers.get(i);
            if (server.scheduleFuture != null && !server.scheduleFuture.isDone()) {
                ++noRunning;
            } else {
                ++noStopped;
            }
            ++i;
        }
        String info = String.valueOf(String.valueOf(this.m_servers.size())) + " - Running=" + noRunning + " - Stopped=" + noStopped;
        return info;
    }

    public Timestamp getStartTime() {
        return this.m_start;
    }

    public synchronized IServerFactory<AdempiereServer, AdempiereProcessor> addingService(ServiceReference<IServerFactory<AdempiereServer, AdempiereProcessor>> reference) {
        IServerFactory factory = (IServerFactory)AdempiereServerActivator.getBundleContext().getService(reference);
        this.createServers(factory);
        this.startAll();
        return factory;
    }

    public void modifiedService(ServiceReference<IServerFactory<AdempiereServer, AdempiereProcessor>> reference, IServerFactory<AdempiereServer, AdempiereProcessor> service) {
    }

    public void removedService(ServiceReference<IServerFactory<AdempiereServer, AdempiereProcessor>> reference, IServerFactory<AdempiereServer, AdempiereProcessor> service) {
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 4) {
            if (serviceTracker != null) {
                serviceTracker.close();
            }
        } else if (event.getType() == 2 && serviceTracker != null) {
            serviceTracker.open();
        }
    }

    public Boolean remove(String serverID) {
        ServerWrapper server = this.getServer(serverID);
        if (server == null) {
            return false;
        }
        if (server.scheduleFuture != null && !server.scheduleFuture.isDone() && !this.stop(serverID)) {
            return false;
        }
        int i = 0;
        while (i < this.m_servers.size()) {
            server = this.m_servers.get(i);
            if (serverID.equals(server.server.getServerID())) {
                this.m_servers.remove(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public static class ServerWrapper
    implements Runnable {
        protected AdempiereServer server;
        protected volatile ScheduledFuture<?> scheduleFuture;

        public ServerWrapper(AdempiereServer server) {
            this.server = server;
            this.start();
        }

        public void start() {
            this.scheduleFuture = Adempiere.getThreadPoolExecutor().schedule(this, this.server.getInitialNap() * 1000L + this.server.getSleepMS(), TimeUnit.MILLISECONDS);
        }

        @Override
        public void run() {
            if (this.server.isSleeping()) {
                this.server.run();
                if (this.server.getSleepMS() != 0L) {
                    this.scheduleFuture = Adempiere.getThreadPoolExecutor().schedule(this, this.server.getSleepMS(), TimeUnit.MILLISECONDS);
                }
            } else {
                this.scheduleFuture = Adempiere.getThreadPoolExecutor().schedule(this, 60000L, TimeUnit.MILLISECONDS);
            }
        }

        public AdempiereServer getServer() {
            return this.server;
        }

        public boolean isAlive() {
            return this.scheduleFuture != null && !this.scheduleFuture.isDone();
        }

        public boolean isInterrupted() {
            return this.scheduleFuture != null && this.scheduleFuture.isCancelled();
        }
    }
}

