/*
 * Decompiled with CFR 0.152.
 */
package org.bmlaurus.home;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.util.CLogger;
import org.compiere.util.Ini;
import org.compiere.util.SecureEngine;

public final class Prop
implements Serializable {
    private static final long serialVersionUID = -2735243406793760873L;
    public static final String HOME_PROPERTY_FILE = "home.properties";
    private static final String TEMPLATE_PATH = "TemplatePath";
    private static final String TEMPLATE_NAME = "TemplateName";
    public static final String CLIENT_NAME = "ClientName";
    public static final String CREDITS_TXT = "Credits";
    public static final String COPYRIGHT_TXT = "Copyright";
    public static final String CUSTOM_IMAGE_PATH = "CustomImagePath";
    public static final String WEBUI_LINK = "WebUiLink";
    public static final String WEBSTORE_LINK = "WebStoreLink";
    public static final String SENDREQUEST_LINK = "SendRequestLink";
    public static final String RESOURCE_LINK = "ResourceLink";
    public static final String SUPPORT_LINK = "SupportLink";
    public static final String IRC_LINK = "IrcLink";
    public static final String WIKI_LINK = "WikiLink";
    public static final String FORUMS_LINK = "ForumsLink";
    public static final String SUPPORTREQ_LINK = "SupportRequestLink";
    public static final String OPTION_LINK = "OptionLink";
    public static final String FELIX_LINK = "FelixLink";
    public static final String MONITOR_LINK = "iDempiereMonitorLink";
    public static final String OPTION_TEXT = "OptionText";
    public static final String FELIX_TEXT = "FelixText";
    public static final String LOCAL_TEXT = "LocalSupportText";
    public static final String MONITOR_TEXT = "iDempiereMonitorText";
    public static final String WEBUI_TEXT = "WebUiText";
    public static final String WEBSTORE_TEXT = "WebStoreText";
    public static final String SENDREQUEST_TEXT = "SendRequestText";
    public static final String RESOURCE_TEXT = "ResourceText";
    public static final String IRC_TEXT = "IrcText";
    public static final String WIKI_TEXT = "WikiText";
    public static final String FORUMS_TEXT = "ForumsText";
    public static final String SUPPORTREQUEST_TEXT = "SupportRequestText";
    public static final String TITLE = "Title";
    private static final String DEF_FELIX_LINK = "osgi/system/console";
    private static final String DEF_MONITOR_LINK = "idempiereMonitor";
    private static final String DEF_WEBUI_LINK = "/webui/";
    private static final String DEF_WEBSTORE_LINK = "/wstore/index.jsp";
    private static final String DEF_SENDREQUEST_LINK = "/wstore/request.jsp";
    private static final String DEF_RESOURCE_LINK = "http://www.idempiere.org";
    private static final String DEF_SUPPORT_LINK = "#";
    private static final String DEF_IRC_LINK = "http://webchat.freenode.net/?channels=idempiere";
    private static final String DEF_WIKI_LINK = "http://wiki.idempiere.org/";
    private static final String DEF_FORUMS_LINK = "http://groups.google.com/group/idempiere";
    private static final String DEF_SUPPORTREQ_LINK = "http://jira.idempiere.com";
    public static final String SOC_FACEBOOK = "Facebook";
    public static final String SOC_TWITTER = "Twitter";
    public static final String SOC_LINKEDIN = "LinkedIn";
    public static final String SOC_GOOPLUS = "Google+";
    public static final String SOC_5 = "Social5";
    public static final String SOC_6 = "Social6";
    public static final String SOC_7 = "Social7";
    private static final String CREDITS = "Welcome to the iDempiere (OSGi+ADempiere) 6.2 Page!";
    private static String LOGO_URL = null;
    private static volatile Properties s_prop = new Properties();
    private static CLogger log = CLogger.getCLogger(Prop.class);

    private static String IMAGE_PATH() {
        String path = "resources/templates/";
        if (s_prop != null) {
            path = Prop.getProperty(TEMPLATE_PATH);
            if (Prop.getProperty(TEMPLATE_NAME) != null && Prop.getProperty(TEMPLATE_NAME).length() > 0) {
                path = String.valueOf(path) + Prop.getProperty(TEMPLATE_NAME) + "/images/";
            }
        }
        return path;
    }

    public static boolean loadProperties(String filename) {
        boolean loadOK = true;
        s_prop = new Properties();
        InputStream fis = null;
        try {
            fis = new FileInputStream(filename);
            s_prop.load(fis);
            fis.close();
        }
        catch (FileNotFoundException e) {
            if (log.isLoggable(Level.INFO)) {
                log.info(String.valueOf(filename) + " not found");
                log.info("!!WARNING:Please locate your custom home.properties on IDEMPIERE_HOME.");
            }
            loadOK = false;
            try {
                fis = Prop.class.getResourceAsStream(HOME_PROPERTY_FILE);
                s_prop.load(fis);
                fis.close();
                loadOK = true;
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, String.valueOf(filename) + " - " + e.toString());
            loadOK = false;
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, String.valueOf(filename) + " - " + t.toString());
            loadOK = false;
        }
        return loadOK;
    }

    private static void setDefaults() {
        if (s_prop.getProperty(TEMPLATE_NAME) == null || s_prop.getProperty(TEMPLATE_NAME).length() <= 0) {
            s_prop.setProperty(TEMPLATE_NAME, "white");
        }
        if (s_prop.getProperty(CLIENT_NAME) == null || s_prop.getProperty(CLIENT_NAME).length() <= 0) {
            s_prop.setProperty(CLIENT_NAME, "iDempiere Server");
        }
        if (s_prop.getProperty(CREDITS_TXT) == null || s_prop.getProperty(CREDITS_TXT).length() <= 0) {
            s_prop.setProperty(CREDITS_TXT, CREDITS);
        }
        if (s_prop.getProperty(FELIX_LINK) == null || s_prop.getProperty(FELIX_LINK).length() <= 0) {
            s_prop.setProperty(FELIX_LINK, DEF_FELIX_LINK);
        }
        if (s_prop.getProperty(MONITOR_LINK) == null || s_prop.getProperty(MONITOR_LINK).length() <= 0) {
            s_prop.setProperty(MONITOR_LINK, DEF_MONITOR_LINK);
        }
        if (s_prop.getProperty(WEBUI_LINK) == null || s_prop.getProperty(WEBUI_LINK).length() <= 0) {
            s_prop.setProperty(WEBUI_LINK, DEF_WEBUI_LINK);
        }
        if (s_prop.getProperty(WEBSTORE_LINK) == null || s_prop.getProperty(WEBSTORE_LINK).length() <= 0) {
            s_prop.setProperty(WEBSTORE_LINK, DEF_WEBSTORE_LINK);
        }
        if (s_prop.getProperty(SENDREQUEST_LINK) == null || s_prop.getProperty(SENDREQUEST_LINK).length() <= 0) {
            s_prop.setProperty(SENDREQUEST_LINK, DEF_SENDREQUEST_LINK);
        }
        if (s_prop.getProperty(RESOURCE_LINK) == null || s_prop.getProperty(RESOURCE_LINK).length() <= 0) {
            s_prop.setProperty(RESOURCE_LINK, DEF_RESOURCE_LINK);
        }
        if (s_prop.getProperty(SUPPORT_LINK) == null || s_prop.getProperty(SUPPORT_LINK).length() <= 0) {
            s_prop.setProperty(SUPPORT_LINK, DEF_SUPPORT_LINK);
        }
        if (s_prop.getProperty(IRC_LINK) == null || s_prop.getProperty(IRC_LINK).length() <= 0) {
            s_prop.setProperty(IRC_LINK, DEF_IRC_LINK);
        }
        if (s_prop.getProperty(WIKI_LINK) == null || s_prop.getProperty(WIKI_LINK).length() <= 0) {
            s_prop.setProperty(WIKI_LINK, DEF_WIKI_LINK);
        }
        if (s_prop.getProperty(FORUMS_LINK) == null || s_prop.getProperty(FORUMS_LINK).length() <= 0) {
            s_prop.setProperty(FORUMS_LINK, DEF_FORUMS_LINK);
        }
        if (s_prop.getProperty(SUPPORTREQ_LINK) == null || s_prop.getProperty(SUPPORTREQ_LINK).length() <= 0) {
            s_prop.setProperty(SUPPORTREQ_LINK, DEF_SUPPORTREQ_LINK);
        }
        if (s_prop.getProperty(OPTION_LINK) == null || s_prop.getProperty(OPTION_LINK).length() <= 0) {
            s_prop.setProperty(OPTION_LINK, DEF_SUPPORT_LINK);
        }
    }

    public static String loadCss() {
        String retPath = null;
        if (Prop.getProperty(TEMPLATE_PATH).contains("://")) {
            String ret = "data:plain/text;base64,";
            URL fis = null;
            try {
                fis = new URL(String.valueOf(Prop.getProperty(TEMPLATE_PATH)) + Prop.getProperty(TEMPLATE_NAME) + "/styles/template.css");
                byte[] data = Prop.read(fis);
                ret = String.valueOf(ret) + Base64.getEncoder().encode(data);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            retPath = ret;
        } else {
            retPath = String.valueOf(Prop.getProperty(TEMPLATE_PATH)) + Prop.getProperty(TEMPLATE_NAME) + "/styles/template.css";
        }
        return retPath;
    }

    public static String getYear() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        return sdf.format(new Date());
    }

    public static String getImage(String img) {
        String retPath = null;
        if (Prop.getProperty(CUSTOM_IMAGE_PATH) != null && Prop.getProperty(CUSTOM_IMAGE_PATH).length() > 0 && !Prop.getProperty(CUSTOM_IMAGE_PATH).equals("NONE")) {
            retPath = Prop.imageToData(String.valueOf(Prop.getProperty(CUSTOM_IMAGE_PATH)) + img);
            if (retPath == null) {
                retPath = Prop.IMAGE_PATH().contains("://") ? Prop.imageToData(String.valueOf(Prop.IMAGE_PATH()) + img) : String.valueOf(Prop.IMAGE_PATH()) + img;
            }
        } else {
            retPath = Prop.IMAGE_PATH().contains("://") ? Prop.imageToData(String.valueOf(Prop.IMAGE_PATH()) + img) : String.valueOf(Prop.IMAGE_PATH()) + img;
        }
        return retPath;
    }

    public static String getProperty(String key) {
        if (key == null) {
            return "";
        }
        String retStr = s_prop.getProperty(key, "");
        if (retStr == null || retStr.length() == 0) {
            return "";
        }
        String value = SecureEngine.decrypt((String)retStr, (int)0);
        if (value == null) {
            return "";
        }
        return value;
    }

    public static String getFileName(boolean tryUserHome) {
        String home;
        if (System.getProperty("PropertyHomeFile") != null) {
            return System.getProperty("PropertyHomeFile");
        }
        String base = null;
        if (tryUserHome && Ini.isClient()) {
            base = System.getProperty("user.home");
        }
        if (!(Ini.isClient() && base != null && base.length() != 0 || (home = Ini.getAdempiereHome()) == null)) {
            base = home;
        }
        if (base != null && !base.endsWith(File.separator)) {
            base = String.valueOf(base) + File.separator;
        }
        if (base == null) {
            base = "";
        }
        return String.valueOf(base) + HOME_PROPERTY_FILE;
    }

    public static String imageToData(String url) {
        byte[] data;
        String ret;
        block5: {
            ret = "data:image/png;base64,";
            if (url.equals(LOGO_URL)) {
                return url;
            }
            URL fis = null;
            fis = new URL(url);
            data = Prop.read(fis);
            if (data != null && data.length > 0) break block5;
            return null;
        }
        try {
            ret = String.valueOf(ret) + Base64.getEncoder().encode(data);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ret;
    }

    private static byte[] read(URL url) throws IOException {
        ByteArrayOutputStream bais;
        block9: {
            bais = new ByteArrayOutputStream();
            InputStream is = null;
            try {
                try {
                    int n;
                    is = url.openStream();
                    byte[] byteChunk = new byte[4096];
                    while ((n = is.read(byteChunk)) > 0) {
                        bais.write(byteChunk, 0, n);
                    }
                }
                catch (IOException e) {
                    System.err.println("Failed while reading bytes from %s: %s" + url.toExternalForm() + e.getMessage());
                    if (is != null) {
                        is.close();
                    }
                    break block9;
                }
            }
            catch (Throwable throwable) {
                if (is != null) {
                    is.close();
                }
                throw throwable;
            }
            if (is != null) {
                is.close();
            }
        }
        return bais.toByteArray();
    }

    public static void load() {
        Prop.loadProperties(Prop.getFileName(false));
        Prop.setDefaults();
        LOGO_URL = String.valueOf(Prop.IMAGE_PATH()) + "logo.png";
    }
}

