/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.server;

import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.server.rpl.IImportProcessor;
import org.compiere.model.AdempiereProcessor;
import org.compiere.model.MClient;
import org.compiere.model.MIMPProcessor;
import org.compiere.model.MIMPProcessorLog;
import org.compiere.model.MOrgInfo;
import org.compiere.model.X_IMP_Processor_Type;
import org.compiere.server.AdempiereServer;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;

public class ReplicationProcessor
extends AdempiereServer {
    protected StringBuffer m_summary = new StringBuffer();
    protected MClient m_client = null;
    protected MIMPProcessor mImportProcessor = null;
    protected boolean isProcessRunning = false;

    public ReplicationProcessor(AdempiereProcessor model, int initialNap) {
        super(model, initialNap);
        this.mImportProcessor = (MIMPProcessor)model;
        this.m_client = MClient.get((Properties)this.mImportProcessor.getCtx(), (int)this.mImportProcessor.getAD_Client_ID());
    }

    public ReplicationProcessor(AdempiereProcessor model) {
        super(model, 30);
        this.mImportProcessor = (MIMPProcessor)model;
        this.m_client = MClient.get((Properties)this.mImportProcessor.getCtx(), (int)this.mImportProcessor.getAD_Client_ID());
    }

    protected void doWork() {
        if (!this.isProcessRunning) {
            MIMPProcessorLog pLog;
            MOrgInfo schedorg;
            Env.setContext((Properties)this.mImportProcessor.getCtx(), (String)"#AD_Client_ID", (int)this.mImportProcessor.getAD_Client_ID());
            Env.setContext((Properties)this.mImportProcessor.getCtx(), (String)"#AD_Org_ID", (int)this.mImportProcessor.getAD_Org_ID());
            if (this.mImportProcessor.getAD_Org_ID() != 0 && (schedorg = MOrgInfo.get((Properties)this.getCtx(), (int)this.mImportProcessor.getAD_Org_ID(), null)).getM_Warehouse_ID() > 0) {
                Env.setContext((Properties)this.mImportProcessor.getCtx(), (String)"#M_Warehouse_ID", (int)schedorg.getM_Warehouse_ID());
            }
            Env.setContext((Properties)this.mImportProcessor.getCtx(), (String)"#AD_User_ID", (int)this.getAD_User_ID());
            this.m_summary = new StringBuffer();
            String trxName = this.mImportProcessor.get_TrxName();
            if (trxName != null) {
                "".equals(trxName);
            }
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("trxName = " + trxName);
            }
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("ImportProcessor = " + this.mImportProcessor);
            }
            int IMP_ProcessorType_ID = 0;
            IMP_ProcessorType_ID = this.mImportProcessor.getIMP_Processor_Type_ID();
            X_IMP_Processor_Type impProcessor_Type = new X_IMP_Processor_Type(this.mImportProcessor.getCtx(), IMP_ProcessorType_ID, trxName);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("impProcessor_Type = " + impProcessor_Type);
            }
            String javaClass = impProcessor_Type.getJavaClass();
            IImportProcessor importProcessor = null;
            try {
                Class<?> clazz = Class.forName(javaClass);
                importProcessor = (IImportProcessor)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                importProcessor.process(this.mImportProcessor.getCtx(), this, trxName);
            }
            catch (Exception e) {
                this.isProcessRunning = false;
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("ReplicationProcessor caught an exception !!!");
                }
                e.printStackTrace();
                this.log.severe(e.getMessage());
                pLog = new MIMPProcessorLog(this.mImportProcessor, e.getMessage());
                pLog.setReference("#" + String.valueOf(this.p_runCount) + " - " + TimeUtil.formatElapsed((Timestamp)new Timestamp(this.p_startWork)));
                pLog.saveEx();
                try {
                    importProcessor.stop();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    MIMPProcessorLog pLog2 = new MIMPProcessorLog(this.mImportProcessor, e1.getMessage());
                    pLog2.saveEx();
                }
            }
            int no = this.mImportProcessor.deleteLog();
            this.m_summary.append("Logs Records deleted=").append(no).append("; ");
            pLog = new MIMPProcessorLog(this.mImportProcessor, this.m_summary.toString());
            pLog.setReference("#" + String.valueOf(this.p_runCount) + " - " + TimeUtil.formatElapsed((Timestamp)new Timestamp(this.p_startWork)));
            pLog.saveEx();
        }
    }

    protected int getAD_User_ID() {
        int AD_User_ID = this.mImportProcessor.getCreatedBy() > 0 ? this.mImportProcessor.getCreatedBy() : (this.mImportProcessor.getUpdatedBy() > 0 ? this.mImportProcessor.getUpdatedBy() : 100);
        return AD_User_ID;
    }

    public String getServerInfo() {
        return "#" + this.p_runCount + " - Last=" + this.m_summary.toString();
    }

    public boolean isProcessRunning() {
        return this.isProcessRunning;
    }

    public void setProcessRunning(boolean isProcessRunning) {
        this.isProcessRunning = isProcessRunning;
    }

    public MIMPProcessor getMImportProcessor() {
        return this.mImportProcessor;
    }

    public void setMImportProcessor(MIMPProcessor importProcessor) {
        this.mImportProcessor = importProcessor;
    }
}

