/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.server.rpl.imp;

import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.server.rpl.IImportProcessor;
import org.adempiere.server.rpl.imp.TopicListener;
import org.compiere.model.MIMPProcessor;
import org.compiere.model.X_IMP_ProcessorParameter;
import org.compiere.server.ReplicationProcessor;
import org.compiere.util.CLogger;

public class TopicImportProcessor
implements IImportProcessor {
    protected CLogger log = CLogger.getCLogger(TopicImportProcessor.class);
    private TopicListener topicListener = null;

    @Override
    public void process(Properties ctx, ReplicationProcessor replicationProcessor, String trxName) throws Exception {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("replicationProcessor = " + (Object)((Object)replicationProcessor));
            this.log.info("replicationProcessor.getMImportProcessor() = " + replicationProcessor.getMImportProcessor());
        }
        MIMPProcessor impProcessor = replicationProcessor.getMImportProcessor();
        X_IMP_ProcessorParameter[] processorParameters = impProcessor.getIMP_ProcessorParameters(trxName);
        String host = impProcessor.getHost();
        int port = impProcessor.getPort();
        String account = impProcessor.getAccount();
        String password = impProcessor.getPasswordInfo();
        String topicName = null;
        String protocol = null;
        boolean isDurableSubscription = true;
        String subscriptionName = null;
        String options = null;
        String clientID = null;
        if (processorParameters != null && processorParameters.length > 0) {
            int i = 0;
            while (i < processorParameters.length) {
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info("ProcesParameter          Value = " + processorParameters[i].getValue());
                    this.log.info("ProcesParameter ParameterValue = " + processorParameters[i].getParameterValue());
                }
                if (processorParameters[i].getValue().equals("topicName")) {
                    topicName = processorParameters[i].getParameterValue();
                } else if (processorParameters[i].getValue().equals("protocol")) {
                    protocol = processorParameters[i].getParameterValue();
                } else if (processorParameters[i].getValue().equals("isDurableSubscription")) {
                    isDurableSubscription = Boolean.parseBoolean(processorParameters[i].getParameterValue());
                } else if (processorParameters[i].getValue().equals("subscriptionName")) {
                    subscriptionName = processorParameters[i].getParameterValue();
                } else if (processorParameters[i].getValue().equals("clientID")) {
                    clientID = processorParameters[i].getParameterValue();
                }
                ++i;
            }
        }
        if (topicName == null || topicName.length() == 0) {
            throw new Exception("Missing IMP_ProcessorParameter with key 'topicName'!");
        }
        if (protocol == null || protocol.length() == 0) {
            throw new Exception("Missing IMP_ProcessorParameter with key 'protocol'!");
        }
        if (isDurableSubscription && subscriptionName == null || subscriptionName.length() == 0) {
            throw new Exception("Missing IMP_ProcessorParameter with key 'subscriptionName'!");
        }
        if (clientID == null || clientID.length() == 0) {
            throw new Exception("Missing IMP_ProcessorParameter with key 'clientID'!");
        }
        this.topicListener = new TopicListener(ctx, replicationProcessor, protocol, host, port, isDurableSubscription, subscriptionName, topicName, clientID, account, password, options, trxName);
        this.topicListener.run();
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Started topicListener = " + this.topicListener);
        }
    }

    @Override
    public void stop() throws Exception {
        if (this.topicListener != null) {
            this.topicListener.stop();
            this.log.info("Stoped topicListener.");
        }
    }
}

