
CKEDITOR.focusManager._.blurDelay = 0;

ckez.CKeditor = zk.$extends(zul.Widget, {
	_height: '200',
	_value: '',
	
	$define: {
		value: [function(v) {
			return !v ? '' : v;
		}, function (v, fromServer) {
			var editor = this.getEditor();
			if (editor) {
				editor.setData(v);
				
				
				if (fromServer)
					editor._.previousValue = editor.dataProcessor.toHtml(v);
			}
		}],
		autoHeight: null,
		customConfigurationsPath: _zkf = function () {
			if (this.desktop)
				this.rerender();
		},
		config: _zkf,
		toolbar: _zkf,
		width: function (v) {
			if (!v || !this.$n()) return;
			this._setSize(jq('#cke_' + this.uuid + '-cnt'), v, 'width');
		},
		height: function (v) {
			if (!v || !this.$n()) return;
			this._setSize(jq('#cke_' + this.uuid + '-cnt'), v, 'height');
		}
	},	

	setVflex: function (v) {
		if (v == 'min') v = false;
		
		
		if (this._editor)
			this.$super(ckez.CKeditor, 'setVflex', v);
		else
			this._tmpVflex = v;
	},
	setHflex: function (v) {
		if (v == 'min') v = false;
		
		
		if (this._editor)
			this.$super(ckez.CKeditor, 'setHflex', v);
		else
			this._tmpHflex = v;
	},
	setFlexSize_: function(sz, ignoreMargins) {
		if (this._editor) {
			
			if (this._isMaximize)
				return;
			var n = this.$n(),
				zkn = zk(n);
			if (sz.height !== undefined) {
				if (sz.height == 'auto')
					n.style.height = '';
				else if (sz.height != '') 
					this.setFlexSizeH_(n, zkn, sz.height, ignoreMargins);
				else {
					n.style.height = this._height || '';
					if (this._height)
						this._setSize(jq('#cke_' + this.uuid + '-cnt'), this._height, 'height');
					else
						this._setSize(jq('#cke_' + this.uuid + '-cnt'), '200px', 'height');
				}
			}
			if (sz.width !== undefined) {
				if (sz.width == 'auto')
					n.style.width = '';
				else if (sz.width != '') 
					this.setFlexSizeW_(n, zkn, sz.width, ignoreMargins);
				else {
					n.style.width = this._width || '';
					if (this._width)
						this._setSize(jq('#cke_' + this.uuid + '-cnt'), this._width, 'width');
					else
						this._setSize(jq('#cke_' + this.uuid + '-cnt'), '100%', 'width');
				}
			}
			return {height: n.offsetHeight, width: n.offsetWidth};
		}
	},
	setFlexSizeH_: function(n, zkn, height, ignoreMargins) {
		
		
		this._hflexHeight = height;

		this.$super(ckez.CKeditor, 'setFlexSizeH_', n, zkn, height, ignoreMargins);
		var h = parseInt(n.style.height); 
		
		n.style.height = '';
		
		
		var textArea  = jq(n).find('.cke_contents'),
			topHeight = textArea.prev().outerHeight(), 
			bottomHeight = textArea.next().outerHeight();
		h = h - topHeight - bottomHeight;

		
		this._setSize(textArea, jq.px0(h), 'height');
	},
	setFlexSizeW_: function(n, zkn, width, ignoreMargins) {
		
		var topHeight = jq('#cke_' + this.uuid + '-cnt .cke_top').outerHeight();

		this.$super(ckez.CKeditor, 'setFlexSizeW_', n, zkn, width, ignoreMargins);
		var w = parseInt(n.style.width); 

		
		
		this._setSize(jq('#cke_' + this.uuid + '-cnt'), jq.px0(w), 'width');
		
		
		if (topHeight != jq('#cke_' + this.uuid + '-cnt .cke_top').outerHeight() && this._vflex)
			this.setFlexSizeH_(n, zkn, this._hflexHeight, ignoreMargins);
	},
	redraw: function (out) {
		out.push('<div', this.domAttrs_({domStyle: true}), '><textarea id="', this.uuid, '-cnt"></textarea></div>');
	},
	
	domAttrs_: function (no) {
		var attr = this.$supers('domAttrs_', arguments);
		if (!this.isVisible() && (!no || !no.visible))
			attr += ' style="display:none;"';
		return attr;
	},
	
	bind_ : function() {
		this.$supers('bind_', arguments);
		var wgt = this;
		setTimeout(function(){wgt._init();},50);
		zWatch.listen({
			onSend : this,
			onRestore : this,
			onVParent : this
		});
	},
	
	unbind_ : function() {
		this._unbind = true;
		if (this._editor) {
			
			try {
				this._editor.destroy(true);
			} catch (err) {
				
				CKEDITOR.tools.removeFunction(this._editor._.frameLoadedHandler);
				this._editor.fire('contentDomUnload');

				
				this._editor.status = 'destroyed';
				this._editor.fire('destroy');
				this._editor.removeAllListeners();
				CKEDITOR.remove(this._editor);
				CKEDITOR.fire('instanceDestroyed', null, this._editor);
			}
		}

		this._editor = this._tmpVflex = this._tmpHflex = null;
		zWatch.unlisten({
			onSend : this,
			onRestore : this,
			onVParent : this
		});
		this.$supers('unbind_', arguments);
		this._unbind = null;
	},

	onSend: function (ctrl) {
		var implicit = ctrl.args[1];
		
		if (!implicit) {
			var editor = this.getEditor();
			if (editor)
				this.$class.onBlur(editor, true);
		}
	},
	
	onRestore: function () {
		this._restore();
	},
	
	
	onVParent: function (evt) {
		
		if (this._isChildOf(evt.origin)) {
			this._restore();
		}
	},
	
	_isChildOf: function(wgt) {
		var p = this.parent;
		if (p) {
			do {
				if (p == wgt)
					return true;
				p = p.parent;
			} while (p != wgt.desktop);
		}
		return false;
	},
	
	_restore: function () {
		var iframe = jq('#cke_' + this.uuid + '-cnt iframe')[0];
		if (!iframe) return;
		
		CKEDITOR.remove( this._editor );
		jq(this.$n()).html('<textarea id="' + this.uuid + '-cnt">' + this._value + '</textarea>');
		this.clearCache();
		this._init();
		
		if (zk.ie)
			jq('#cke_' + this.uuid + '-cnt').width(jq('#cke_'+this.uuid+'-cnt').width());
	}, 
	
	_setSize: function (node, value, prop) {
		value = this._getValue(value);
		if (!value) return;
		
		node[prop](value);
		this._editor.config[prop] = value;
	},
	
	_getValue: function (value) {
		if (!value) return null;
		if (value.endsWith('%'))
			return zk.ie ? jq.px0(jq(this.$n()).width()) : value;
			
		return jq.px0(zk.parseInt(value));
	},
	
	getEditor: function () {
		return this._editor;
	},
	
	
	getConfig_: function(config) {
		return config;
	}, 
		
	_init: function() {
		
		if (!this.desktop || this._unbind) return;
		var wgt = this,
			uuid = this.uuid,
			dtid = this.desktop.id,
			customConfigPath = this._customConfigurationsPath,
			filebrowserBrowseUrl = this.filebrowserBrowseUrl,
			filebrowserImageBrowseUrl = this.filebrowserImageBrowseUrl,
			filebrowserFlashBrowseUrl = this.filebrowserFlashBrowseUrl,
			filebrowserUploadUrl = this.filebrowserUploadUrl,
			filebrowserImageUploadUrl = this.filebrowserImageUploadUrl,
			filebrowserFlashUploadUrl = this.filebrowserFlashUploadUrl,
			fileBrowserTempl = this.fileBrowserTempl,
			fileUploadTempl = this.fileUploadTempl,
			config = this.getConfig_({
				customConfig: customConfigPath,
				width: this._getValue(this._width),
				height: this._getValue(this._height)
			});
		
		if (this._config) {
			zk.override(config, {}, this._config);
		}
		
		if (filebrowserBrowseUrl)
			config.filebrowserBrowseUrl = fileBrowserTempl + '?Type=Files&dtid=' + dtid + '&uuid=' + uuid;

		if (filebrowserImageBrowseUrl)
			config.filebrowserImageBrowseUrl = fileBrowserTempl + '?Type=Images&dtid=' + dtid + '&uuid=' + uuid;

		if (filebrowserFlashBrowseUrl)
			config.filebrowserFlashBrowseUrl = fileBrowserTempl + '?Type=Flash&dtid=' + dtid + '&uuid=' + uuid;
		
		if (filebrowserUploadUrl)
			config.filebrowserUploadUrl = fileUploadTempl + '?Type=Files&dtid=' + dtid + '&uuid=' + uuid;

		if (filebrowserImageUploadUrl)
			config.filebrowserImageUploadUrl = fileUploadTempl + '?Type=Images&dtid=' + dtid + '&uuid=' + uuid;

		if (filebrowserFlashUploadUrl)
			config.filebrowserFlashUploadUrl = fileUploadTempl + '?Type=Flash&dtid=' + dtid + '&uuid=' + uuid;
		
		if (this._toolbar)
			config.toolbar = this._toolbar;
		
		
		var cnt = this.$n('cnt');
		jq(cnt).text(this._value); 
		
		jq(cnt).ckeditor(function(){
			if (wgt._unbind) {
				this.destroy();
				return;
			}
			wgt._editor = this;
			this.on('focus', ckez.CKeditor.onFocus);
			this.on('blur', ckez.CKeditor.onBlur);
			this.on('selectionChange', ckez.CKeditor.onSelection);
			wgt._overrideFormSubmit();
			this.on('key', ckez.CKeditor.onAutoHeight); 
			this.on('loadSnapshot', ckez.CKeditor.onAutoHeight);
			this.on('beforePaste', ckez.CKeditor.onAutoHeight);
			this.on('maximize', ckez.CKeditor.onMaximize);
			
			jq('iframe', this.container.$).contents().on('click', wgt.proxy(wgt._mimicOnClick));
			this.resetDirty();

			
			if (!wgt._tmpHflex && wgt._hflex) {
				wgt._tmpHflex = wgt._hflex;
				wgt.setHflex(null);
			}
			if (!wgt._tmpVflex && wgt._vflex) {
				wgt._tmpVflex = wgt._vflex;
				wgt.setVflex(null);
			}

			if (wgt._tmpHflex) {
				wgt.setHflex(wgt._tmpHflex, {force:true});
				wgt._tmpHflex = null;
			}
			if (wgt._tmpVflex) {
				wgt.setVflex(wgt._tmpVflex, {force:true});
				wgt._tmpVflex = null;
			}
		}, config);
		
	},
	
	_overrideFormSubmit: function() {
		var editor = this.getEditor(),
			wgt = zk.Widget.$(editor.element.getId()),
			element = editor.element,
			form = element.$.form && new CKEDITOR.dom.element(element.$.form);
		
		if (!form) return;
		
		form.$.submit = CKEDITOR.tools.override(form.$.submit, function(originalSubmit) {
			return function() {
				editor.updateElement();
				var val = editor.getData();
				wgt.fire('onChange', {value: val}, {sendAhead: true});
				wgt.fire('onSave', {value: val}, {sendAhead: true});
			};
		});
	},

	_mimicOnClick: function (event) {
		zWatch.fire('onFloatUp', this, {triggerByClick: event.which});
	}
}, {
	onFocus: function (event) {
		var editor = event.editor,
			wgt = zk.Widget.$(editor.element.getId()),
			tmp = editor._.previousValue;
		
		zWatch.fire('onFloatUp', wgt, {triggerByFocus: true});

		wgt._tidChg = setInterval(function () {
			if (tmp != editor._.previousValue)
				tmp = wgt.previousValue = editor._.previousValue;
			
			
			if (editor.checkDirty() && wgt.previousValue != editor.getData()) {
				wgt.fire('onChanging', {
					value: editor.getData(),
					start: 0,
					bySelectBack: false
					},
				{ignorable:1}, 100);
				
				if (editor.checkDirty()) 
					wgt.previousValue = editor.getData();
			}
		}, 500);
	},
	
	onBlur: function (event, ahead) {
		var editor = event.editor || event,
			wgt = zk.Widget.$(editor.element.getId());
		
		
		
		
		if (zk.currentFocus === wgt) return;
		
		if (wgt._tidChg) {
			clearInterval(wgt._tidChg);
			wgt._tidChg = null;
		}
		
		if (!editor.document)
			editor.document = editor.element.getDocument();
		
		if (wgt.$class._checkEditorDirty(editor)) { 
			var val = editor.getData();
			wgt._value = val; 
			
			wgt.fire('onChange', {value: val}, {sendAhead: ahead});
			editor.resetDirty();
		}
	},
	
	onSelection: function (event) {
		var editor = event.editor,
			wgt = zk.Widget.$(editor.element.getId()),
			selection = editor.getSelection();
		
		if (!zk(wgt).isRealVisible) return;
		
		
		if (CKEDITOR.env.ie && CKEDITOR.env.version < 9) {
			selection = selection.getNative().createRange().text;
		} else if (CKEDITOR.env.ie && CKEDITOR.env.version >= 9) {
			selection = document.getSelection();
		} else {
			selection = selection.getNative().toString();
		}
		
		if (selection == '') return;
	},
	
	onAutoHeight: function (event) {
		var editor = event.editor,
			wgt = zk.Widget.$(editor.element.getId()),
			cnt = jq('#cke_' + wgt.uuid + '-cnt'),
			body = cnt.find('iframe').contents().find("body"),
			defaultHeight = zk.parseInt(editor.config.height);
				
		if (wgt._autoHeight) {
			setTimeout(function(){ 
				
				var pMargin = zk.parseInt(body.find("P").css("marginBottom")), 
					bodyMargin = zk.parseInt(body.css("marginBottom")),        
					textArea  = jq(cnt).find('.cke_contents'),
					topHeight = textArea.prev().outerHeight(), 
					bottomHeight = textArea.next().outerHeight(),
					h = body.height() + pMargin + bodyMargin,
					cnth = h + topHeight + bottomHeight;
				
				
				if (cnth < defaultHeight) cnth = defaultHeight;
				h = cnth - topHeight - bottomHeight;
				
				cnt.height(cnth);
				textArea.height(h);
			},20);
		}
	},

	onMaximize: function (event) {
		var editor = event.editor,
			wgt = zk.Widget.$(editor.element.getId()),
			isMaximize = event.data == CKEDITOR.TRISTATE_ON;
		wgt._isMaximize = isMaximize;
		if (!isMaximize)
			zWatch.fire('onSize');
	},
	
	
	_checkEditorDirty: function (editor) {
		var fmtSnapshot = editor.dataProcessor.toHtml(editor.getSnapshot());
		var fmtPreviousVal = editor.dataProcessor.toHtml(editor._.previousValue);
		return editor.status == 'ready' && fmtPreviousVal !== fmtSnapshot;
	}
});
