
(function () {


if (!zk.css3) {
	var _defShadowOpts = {left: 4, right: 4, top: 3, bottom: 3},
		_shadowEnding = '" class="z-shadow"><div class="z-shadow-tl"><div class="z-shadow-tr"></div></div>'
		+ '<div class="z-shadow-cl"><div class="z-shadow-cr"><div class="z-shadow-cm">&#160;</div></div></div>'
		+ '<div class="z-shadow-bl"><div class="z-shadow-br"></div></div></div>';

	
	zk.eff.Shadow = zk.$extends(zk.Object, {
		
		$init: function (element, opts) {
			opts = this.opts = zk.eff._skuOpts(zk.$default(opts, _defShadowOpts));
			this.node = element;
			var sdwid = element.id + '-sdw';
			jq(element).before('<div id="' + sdwid + _shadowEnding);
			this.shadow = jq(sdwid, zk)[0];
		},
		
		destroy: function () {
			jq(this.shadow).remove();
			jq(this.stackup).remove();
			this.node = this.shadow = this.stackup = null;
		},
		
		hide: function () {
			jq(this.shadow).hide();
			jq(this.stackup).hide();
		},
		
		sync: function () {
			var node = this.node, $node = jq(node),
				shadow = this.shadow;
			if (!node || !$node.zk.isVisible(true)) {
				this.hide();
				return false;
			}

			for (var c = shadow;;) {
				if (!(c = c.nextSibling) || c.tagName) {
					if (c != node)
						node.parentNode.insertBefore(shadow, node);
					break;
				}
			}

			var opts = this.opts,
				l = node.offsetLeft, t = node.offsetTop,
				w = node.offsetWidth, h = node.offsetHeight,
				
				wd = Math.max(0, l + w + opts.right > jq.innerWidth() ? w - opts.left : w - opts.left + opts.right),
				hgh = Math.max(0, h - opts.top + opts.bottom),
				st = shadow.style;
			st.left = jq.px(l + opts.left);
			st.top = jq.px(t + opts.top);
			st.width = jq.px0(wd);
			st.zIndex = zk.parseInt($node.css('zIndex'));
			st.display = 'block';
			var cns = shadow.childNodes;
			cns[1].style.height = jq.px0(hgh - cns[0].offsetHeight - cns[2].offsetHeight);

			var stackup = this.stackup;
			if (opts.stackup) {
				if (!stackup)
					stackup = this.stackup = jq.newStackup(node, node.id + '-sdwstk', shadow);

				st = stackup.style;
				st.left = jq.px(l);
				st.top = jq.px(t);
				st.width = jq.px0(w);
				st.height = jq.px0(h);
				st.zIndex = shadow.style.zIndex;
				st.display = 'block';
			}
			return true;
		},
		
		getBottomElement: function () {
			return this.stackup || this.shadow;
		}
	});
}
})();