


function zkpi(nm, wv) {
	return zk.isLoaded(nm) ? null : {n: nm, p: zk.$package(nm, false, wv)};
}


function zkpb(pguid, dtid, contextURI, updateURI, reqURI, props) {
	zkx([0, pguid,
		zk.copy(props, {dt: dtid, cu: contextURI, uu: updateURI, ru: reqURI}),{},[]]);
}

zkpe = zk.$void;


function zkver(ver, build, ctxURI, updURI, modVers, opts) {
	zk.version = ver;
	zk.build = build;
	zk.contextURI = ctxURI;
	zk.updateURI = updURI;

	for (var nm in modVers)
		zk.setVersion(nm, modVers[nm]);

	if (!zk.feature)
		zk.feature = {standard: true};
	zkopt(opts);
}


function zkmld(wgtcls, molds) {
	if (!wgtcls.superclass) {
		zk.afterLoad(function () {zkmld(wgtcls, molds);});
		return;
	}

	var ms = wgtcls.molds = {};
	for (var nm in molds) {
		var fn = molds[nm];
		ms[nm] = typeof fn == 'function' ? fn : fn[0].molds[fn[1]];
	}
}


function zkamn(pkg, fn) {
	zk.load(pkg, function () {
		setTimeout(function () {
			zk.afterMount(fn);
		}, 20);
	});
}

(function () {
	var Widget = zk.Widget,
		_wgt_$ = Widget.$, 
		_crInfBL0 = [], _crInfBL1 = [], 
		_crInfAU0 = [], 
		_aftMounts = [], 
		_aftResizes = [], 
		_mntctx = {}, 
		_paci = {s: 0, e: -1, f0: [], f1: []}, 
		_t0 = jq.now();

	
	
	
	
	
	
	
	jq(function () {
		function _stateless() {
			var dts = zk.Desktop.all;
			for (var dtid in dts)
				if (dts[dtid].stateless) return true;
		}
		_paci.i = setInterval(function () {
			var stateless;
			if ((zk.booted && !zk.mounting) || (stateless = _stateless()))
				if (stateless || _paci.s == _paci.e) { 
					clearInterval(_paci.i);
					var fs = _paci.f0.concat(_paci.f1);
					_paci = null;
					for (var f; f = fs.shift();)
						f();
				} else
					_paci.e = _paci.s;
		}, 25);
	});
	
	zk._apac = function (fn, _which_) {
		if (_paci)
			return _paci[_which_ || 'f1'].push(fn);
		zk.afterMount(fn); 
	};



	
	

	zk.afterMount = function (fn, delay) { 
		if (fn) {
			if (!jq.isReady)
				jq(function () {zk.afterMount(fn);}); 
			else if (zk.mounting)
				_aftMounts.push(fn); 
			else if (zk.loading)
				zk.afterLoad(fn);
			else if (delay < 0) {
				fn();
				return true; 
			} else
				setTimeout(fn, delay);
		}
	};


    
    

	zk.afterResize = function (fn) {
		if (fn)
			_aftResizes.push(fn);
	};
	zk.doAfterResize = function () {
		for (var fn; fn = _aftResizes.shift();) {
			fn();
		}
	};
	function _curdt() {
		return _mntctx.curdt || (_mntctx.curdt = zk.Desktop.$());
	}
	
	function mountpkg(infs) {
		var types = {};
		for (var j = infs.length; j--;) {
			var inf = infs[j];
			if (!inf.pked) { 
				inf.pked = true;
				getTypes(types, inf[0], inf[1]);
			}
		}

		for (var type in types) {
			var j = type.lastIndexOf('.');
			if (j >= 0)
				zk._load(type.substring(0, j), types[type]); 
		}
	}
	
	function getTypes(types, dt, wi) {
		var type = wi[0];
		if (type === 0) 
			type = wi[2].wc;
		else if (type === 1) 
			wi[0] = type = 'zhtml.Widget';
		if (type)
			types[type] = dt;

		for (var children = wi[4], j = children.length; j--;)
			getTypes(types, dt, children[j]);
	}
	
	function mtBL() {
		for (;;) {
			if (zk.loading)
				return zk.afterLoad(mtBL); 

			var inf = _crInfBL0.shift();
			if (!inf)
				break; 

			_crInfBL1.push([inf[0], create(inf[3] || inf[0], inf[1], true), inf[2], inf[4]]);
				
				
				
				
				

			if (breathe(mtBL))
				return; 
		}

		mtBL0();
	}
	function mtBL0() {
		for (;;) {
			if (_crInfBL0.length)
				return; 

			if (zk.loading)
				return zk.afterLoad(mtBL0);

			if (zk.ie < 11 && !jq.isReady) 
				return jq(mtBL0);

			var inf = _crInfBL1.shift();
			if (!inf) break;

			var wgt = inf[1];
			if (inf[2])
				wgt.bind(inf[0]); 
			else {
				var $jq;
				if (zk.processing
						&& ($jq = jq('#zk_proc')).length) {
					if ($jq.hasClass('z-loading') && $jq.parent().hasClass('z-temp')) {
						$jq[0].id = 'zna';
						if (!jq('#zk_proc').length) 
							zUtl.progressbox('zk_proc', window.msgzk ? msgzk.PLEASE_WAIT : 'Processing...', true);
					}
				}
				wgt.replaceHTML('#' + wgt.uuid, inf[0]);
			}

			doAuCmds(inf[3]); 
		}

		mtBL1();
	}
	function mtBL1() {
		if (_crInfBL0.length || _crInfBL1.length)
			return; 

		zk.booted = true;
		zk.mounting = false;
		doAfterMount(mtBL1);
		_paci && ++_paci.s;
		if (!zk.clientinfo) {
			zk.endProcessing();
		}

		zk.bmk.onURLChange();
		if (zk.pfmeter) {
			var dts = zk.Desktop.all;
			for (var dtid in dts)
				zAu._pfdone(dts[dtid], dtid);
		}
	}

	
	function mtAU() {
		for (;;) {
			if (zk.loading)
				return zk.afterLoad(mtAU);

			var inf = _crInfAU0.shift(), filter, wgt;
			if (!inf)
				break; 

			if (filter = inf[4][1]) 
				Widget.$ = function (n, opts) {return filter(_wgt_$(n, opts));};
			try {
				wgt = create(null, inf[1]);
			} finally {
				if (filter) Widget.$ = _wgt_$;
			}
			inf[4][0](wgt); 

			if (breathe(mtAU))
				return; 
		}
		mtAU0();
	}
	function mtAU0() {
		zk.mounting = false;
		doAfterMount(mtAU0);

		zAu._doCmds(); 
		doAfterMount(mtAU0);
	}
	function doAfterMount(fnext) {
		for (var fn; fn = _aftMounts.shift();) {
			fn();
			if (zk.loading) {
				zk.afterLoad(fnext); 
				return true; 
			}
		}
	}

	function doAuCmds(cmds) {
		if (cmds && cmds.length)
			zk._apac(function () {
				for (var j = 0; j < cmds.length; j += 2)
					zAu.process(cmds[j], cmds[j + 1]);
			}, 'f0');
	}

	
	function create(parent, wi, ignoreDom) {
		var wgt, stub, v,
			type = wi[0],
			uuid = wi[1],
			props = wi[2] || {},
			seProps = wi[3] || {};
		if (type === 0) { 
			type = zk.cut(props, 'wc');
			var cls = type ? zk.$import(type) : zk.Page;
			(wgt = new cls({uuid: uuid}, zk.cut(props, 'ct'))).inServer = true;
			if (parent) parent.appendChild(wgt, ignoreDom);
		} else {
			if ((stub = type == '#stub') || type == '#stubs') {
				if (!(wgt = _wgt_$(uuid) 
						|| zAu._wgt$(uuid))) 
					throw 'Unknown stub ' + uuid;
				var w = new Widget();
				
				
				if (wgt.desktop || wgt.z_rod === 9)
					wgt.unbind(); 
				zk._wgtutl.replace(wgt, w, stub);
					
					
			} else {
				var cls = zk.$import(type);
				if (!cls)
					throw 'Unknown widget: ' + type;
				(wgt = new cls(zkac)).inServer = true;
					
				wgt.uuid = uuid;
				if (v = wi[5])
					wgt.setMold(v);
			}
			if (parent) parent.appendChild(wgt, ignoreDom);

			
			if (v = zk.cut(props, 'z$al'))
				zk.afterLoad(function () {
					for (var p in v)
						wgt.set(p, v[p](), true); 
				});
			
			if (v = zk.cut(seProps, 'z$al'))
				zk.afterLoad(function () {
					for (var i = 0, j = v.length; i < j; i++) {
						var vv = v[i];
						for (var p in vv)
							wgt.set(p, vv[p](), true); 
					}
				});
		}

		for (var nm in props)
			wgt.set(nm, props[nm], true); 

		for (var nm in seProps) {
			var v = seProps[nm];
			for (var i = 0, j = v.length; i < j; i++) {
				var vv = v[i];
				wgt.set(nm, vv, true); 
			}
		}

		for (var j = 0, childs = wi[4], len = childs.length;
		j < len; ++j)
			create(wgt, childs[j]);
		return wgt;
	}

	
	function breathe(fn) {
		var t = jq.now(), dt = t - _t0;
		if (dt > 2500) { 
			_t0 = t;
			dt >>= 6;
			setTimeout(fn, dt < 10 ? dt : 10); 
				
			return true;
		}
	}

  zk.copy(window, {
	
	zkdt: function (dtid, contextURI, updateURI, reqURI) {
		var dt = zk.Desktop.$(dtid);
		if (dt == null) {
			dt = new zk.Desktop(dtid, contextURI, updateURI, reqURI);
			if (zk.pfmeter) zAu._pfrecv(dt, dtid);
		} else {
			if (updateURI != null) dt.updateURI = updateURI;
			if (contextURI != null) dt.contextURI = contextURI;
			if (reqURI != null) dt.requestPath = reqURI;
		}
		_mntctx.curdt = dt;
		return dt;
	},

	
	
	
	
	
	
	
	
	zkx: function (wi, extra, aucmds, js) { 
		zk.mounting = true;

		try {
			if (js) jq.globalEval(js);

			var mount = mtAU, infs = _crInfAU0, delay, owner;
			if (!extra || !extra.length) { 
				delay = extra;
				if (wi) {
					extra = aucmds;
					aucmds = null;
				}
				mount = mtBL;
				infs = _crInfBL0;
			} 

			if (wi) {
				if (wi[0] === 0) { 
					var props = wi[2],
						dt = zkdt(zk.cut(props, 'dt'), zk.cut(props, 'cu'), zk.cut(props, 'uu'), zk.cut(props, 'ru'));
					if (owner = zk.cut(props, 'ow'))
						owner = Widget.$(owner);
					var zf;
					if ((zf = zk.feature) && (zf.pe || zf.ee) && zk.clientinfo !== undefined) {
						zAu.cmd0.clientInfo(dt.uuid);
						if (extra) {
							var newExtra = [];
							for (var j = 0; j < extra.length; j += 2) {
								if (extra[j] != 'clientInfo')
									newExtra.push(extra[j], extra[j + 1]);
							}
							extra = newExtra;
						}
					} else
						delete zk.clientinfo;
				}

				infs.push([_curdt(), wi, _mntctx.bindOnly, owner, extra]);
					
				mountpkg(infs);
			}

			if (delay)
				setTimeout(mount, 0); 
			else if (!breathe(mount)) 
				mount();

			doAuCmds(aucmds);
		} catch (e) {
			zk.mounting = false;
			zk.error('Failed to mount: ' + (e.message || e));
			setTimeout(function () {
				throw e;
			},0);
		}
	},
	
	
	zkx_: function (args, stub, filter) {
		_t0 = jq.now(); 
		args[1] = [stub, filter]; 
		zkx.apply(this, args); 
	},

	
	zkac: function () {
		doAuCmds(arguments);
	},

	
	zkmx: function () {
		zkmb();
		try {
			zkx.apply(window, arguments);
		} finally {
			zkme();
		}
	},

	
	zkmb: function (bindOnly) {
		_mntctx.bindOnly = bindOnly;
		var t = 390 - (jq.now() - _t0);
		zk.startProcessing(t > 0 ? t : 0);
	},
	
	zkme: function () {
		_mntctx.curdt = null;
		_mntctx.bindOnly = false;
	},
	
	zkdh: function (name, script) {
		zk.addDataHandler('data-' + name, script);
	}
  });

})(window);


jq(function () {
	var Widget = zk.Widget,
		_bfUploads = [],
		_reszInf = {},
		_subevts = { 
			onClick: 'doSelect_',
			onRightClick: 'doSelect_',
			onMouseOver: 'doTooltipOver_',
			onMouseOut: 'doTooltipOut_'
		};

	
	zk.copy(zk, {
		
		beforeUnload: function (fn, opts) { 
			if (opts && opts.remove) _bfUploads.$remove(fn);
			else _bfUploads.push(fn);
		}
	});

	function _doEvt(wevt) {
		var wgt = wevt.target;
		if (wgt && !wgt.$weave) {
			var en = wevt.name,
				fn = _subevts[en];
			if (fn) {
				
				if (!zk.ios || (fn != 'doTooltipOver_' && fn != 'doTooltipOut_')) {
					wgt[fn].call(wgt, wevt);
				}
			}
			if (!wevt.stopped && (!wevt.originalEvent || !wevt.originalEvent['zkstopped'])) 
				wgt['do' + en.substring(2) + '_'].call(wgt, wevt);
			if (wevt.domStopped)
				wevt.domEvent.stop();
		}
	}
	
	function _docMouseDown(evt, wgt, noFocusChange) {
		zk.clickPointer[0] = evt.pageX;
		zk.clickPointer[1] = evt.pageY;

		if (!wgt) wgt = evt.target;

		var target = evt.domTarget,
			body = document.body,
			old = zk.currentFocus;
		if ((target != body && target != body.parentNode)
				|| (evt.pageX < body.clientWidth && evt.pageY < body.clientHeight)) 
			
			Widget.mimicMouseDown_(wgt, noFocusChange, evt.which); 
			
		_doEvt(evt);
		
		
		
		if (old && zk.ie) { 
			var n = jq(old)[0];
			if (n)
				setTimeout(function () {
					try {
						var cf = zk.currentFocus;
						if (cf != old && !n.offsetWidth && !n.offsetHeight) {
							zk.focusBackFix = true;
							cf.focus();
						}
					} catch (e) { 
					} finally {
						delete zk.focusBackFix;
					}
				});
		}
	}

	function _docResize() {
		if (!_reszInf.time) return; 

		var now = jq.now();
		if (zk.mounting || zk.loading || now < _reszInf.time || zk.animating()) {
			setTimeout(_docResize, 10);
			return;
		}

		_reszInf.time = null; 
		_reszInf.lastTime = now + 1000;
			

		zAu._onClientInfo();

		_reszInf.inResize = true;
		try {
			zWatch.fire('beforeSize'); 
			zWatch.fire('onFitSize', null, {reverse: true}); 
			zWatch.fire('onSize'); 
			_reszInf.lastTime = jq.now() + 8;
		} finally {
			_reszInf.inResize = false;
		}
	}
	
	function _afterKeyDown(wevt) {
		var dts = zk.Desktop.all, Page = zk.Page;
		for (var dtid in dts)
			for (var wgt = dts[dtid].firstChild; wgt; wgt = wgt.nextSibling)
				if (wgt.$instanceof(Page)) {
					for (var w = wgt.firstChild; w; w = w.nextSibling)
						if (_afterKD(w, wevt))
							return;
				} else if (_afterKD(wgt, wevt))
					return; 
	}
	function _afterKD(wgt, wevt) {
		if (!wgt.afterKeyDown_)
			return; 
		wevt.target = wgt; 
		return wgt.afterKeyDown_(wevt,true);
	}

	var lastTimestamp, lastTarget;
	jq(document)
	.keydown(function (evt) {
		var wgt = Widget.$(evt, {child: true}),
			wevt = new zk.Event(wgt, 'onKeyDown', evt.keyData(), null, evt);
		if (wgt) {
			_doEvt(wevt);
			if (!wevt.stopped && wgt.afterKeyDown_) {
				wgt.afterKeyDown_(wevt);
				if (wevt.domStopped)
					wevt.domEvent.stop();
			}
		} else if (zk.invokeFirstRootForAfterKeyDown)
			_afterKeyDown(wevt);

		if (evt.keyCode == 27
		&& (zk._noESC > 0 || zAu.shallIgnoreESC())) 
			return false; 
	})
	.keyup(function (evt) {
		var wgt = zk.keyCapture;
		if (wgt) zk.keyCapture = null;
		else wgt = Widget.$(evt, {child: true});
		_doEvt(new zk.Event(wgt, 'onKeyUp', evt.keyData(), null, evt));
	})
	.keypress(function (evt) {
		var wgt = zk.keyCapture;
		if (!wgt) wgt = Widget.$(evt, {child: true});
		_doEvt(new zk.Event(wgt, 'onKeyPress', evt.keyData(), null, evt));
	})
	.bind('zcontextmenu', function (evt) {
		
		
		
		zk.clickPointer[0] = evt.pageX;
		zk.clickPointer[1] = evt.pageY;

		var wgt = Widget.$(evt, {child: true});
		if (wgt) {
			if (zk.ie < 11)
				evt.which = 3;
			var wevt = new zk.Event(wgt, 'onRightClick', evt.mouseData(), {}, evt);
			_doEvt(wevt);
			if (wevt.domStopped)
				return false;
		}
		return !(zk.ie < 11) || evt.returnValue;
	})
	.bind('zmousedown', function (evt) {
		if (zk.mobile) {
			zk.currentPointer[0] = evt.pageX;
			zk.currentPointer[1] = evt.pageY;
		}
		var wgt = Widget.$(evt, {child: true});
		_docMouseDown(
			new zk.Event(wgt, 'onMouseDown', evt.mouseData(), null, evt),
			wgt);
	})
	.bind('zmouseup', function (evt) {
		var e = zk.Draggable.ignoreMouseUp(), wgt;
		if (e === true)
			return; 

		if (e != null) {
			_docMouseDown(e, null, true); 
		}

		wgt = zk.mouseCapture;
		if (wgt) zk.mouseCapture = null;
		else wgt = Widget.$(evt, {child: true});
		_doEvt(new zk.Event(wgt, 'onMouseUp', evt.mouseData(), null, evt));
	})
	.bind('zmousemove', function (evt) {
		zk.currentPointer[0] = evt.pageX;
		zk.currentPointer[1] = evt.pageY;

		var wgt = zk.mouseCapture;
		if (!wgt) wgt = Widget.$(evt, {child: true});
		_doEvt(new zk.Event(wgt, 'onMouseMove', evt.mouseData(), null, evt));
	})
	.mouseover(function (evt) {
		if (zk.mobile) return; 
		zk.currentPointer[0] = evt.pageX;
		zk.currentPointer[1] = evt.pageY;

		_doEvt(new zk.Event(Widget.$(evt, {child: true}), 'onMouseOver', evt.mouseData(), {ignorable: 1}, evt));
	})
	.mouseout(function (evt) {
		_doEvt(new zk.Event(Widget.$(evt, {child: true}), 'onMouseOut', evt.mouseData(), {ignorable: 1}, evt));
	})
	.click(function (evt) {
		if (zk.Draggable.ignoreClick()) return;
		
		if (zk.android
				&& (lastTimestamp && lastTimestamp + 400 > evt.timeStamp)
				&& (lastTarget && lastTarget == evt.target)) { 
			return;
		} else {
			lastTimestamp = evt.timeStamp;
			lastTarget = evt.target;
			
			zjq._fixClick(evt);
			
			if (evt.which == 1)
				_doEvt(new zk.Event(Widget.$(evt, {child: true}),
					'onClick', evt.mouseData(), {}, evt));
			
		}
	})
	.bind('zdblclick', function (evt) {
		if (zk.Draggable.ignoreClick()) return;

		var wgt = Widget.$(evt, {child: true});
		if (wgt) {
			var wevt = new zk.Event(wgt, 'onDoubleClick', evt.mouseData(), {}, evt);
			_doEvt(wevt);
			if (wevt.domStopped)
				return false;
		}
	})
	.bind((document.hidden !== undefined ? '' : zk.vendor_) + 'visibilitychange', function (evt) {
		zAu._onVisibilityChange();
	});
	
	var _sizeHandler = function (evt) {
		if (zk.mounting)
			return;

		
		
		
		
		
		
		
		

		var now = jq.now();
		if ((_reszInf.lastTime && now < _reszInf.lastTime) || _reszInf.inResize)
			return; 

		var delay = zk.ie < 11 || zk.android ? 250 : 50;
		_reszInf.time = now + delay - 1; 
		setTimeout(_docResize, delay);

		if (zk.mobile && zAu._cInfoReg) {
			if (!jq('#zk_proc').length && !jq('#zk_showBusy').length) {
				zUtl.progressbox('zk_proc', window.msgzk ? msgzk.PLEASE_WAIT : 'Processing...', true);
			}
		}
	};
	
	if (zk.mobile) {
		jq(window).bind('orientationchange', _sizeHandler);
		
		
		if (zk.ios) {
			jq(window).bind('pagehide', function () {
				zk.unloading = true; 

				if (!zk.rmDesktoping) {
					rmDesktop();
				}
			});
		}
	} else {
		jq(window).resize(_sizeHandler);
	}

	jq(window).scroll(function () {
		zWatch.fire('onScroll'); 
	})
	.unload(function () {
		zk.unloading = true; 

		
		if (zk.ie || !zk.rmDesktoping) {
			rmDesktop();
		}
	});
	
	function rmDesktop () {
		
		
		
		
		var bRmDesktop = !zk.opera && !zk.keepDesktop;
		if (bRmDesktop || zk.pfmeter) {
			zk.rmDesktoping = true;
			try {
				var dts = zk.Desktop.all;
				for (var dtid in dts)
					zAu._rmDesktop(dts[dtid], !bRmDesktop);
			} catch (e) { 
			}
		}
	};

	var _oldBfUnload = window.onbeforeunload;
	window.onbeforeunload = function () {
		if (!zk.skipBfUnload) {
			if (zk.confirmClose)
				return zk.confirmClose;

			for (var j = 0; j < _bfUploads.length; ++j) {
				var s = _bfUploads[j]();
				if (s) return s;
			}
		}

		if (_oldBfUnload) {
			var s = _oldBfUnload.apply(window, arguments);
			if (s) return s;
		}

		zk.unloading = true; 
		
		
		if (!zk.ie) {
			rmDesktop();
		}
		
	};

	zk.afterMount(function () {jq('script.z-runonce').remove();});
		
		
}); 
