/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.dbPort;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.compiere.db.DB_PostgreSQL;
import org.compiere.dbPort.ConvertMap_PostgreSQL;
import org.compiere.dbPort.Convert_SQL92;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class Convert_PostgreSQL
extends Convert_SQL92 {
    public static final int REGEX_FLAGS = 34;
    private TreeMap<String, String> m_map = ConvertMap_PostgreSQL.getConvertMap();
    private static CLogger log = CLogger.getCLogger(Convert_PostgreSQL.class);

    public boolean isOracle() {
        return false;
    }

    protected Map<String, String> getConvertMap() {
        return this.m_map;
    }

    protected ArrayList<String> convertStatement(String sqlStatement) {
        ArrayList<String> result = new ArrayList<String>();
        Vector retVars = new Vector();
        String statement = this.replaceQuotedStrings(sqlStatement, retVars);
        statement = this.convertWithConvertMap(statement);
        statement = this.convertSimilarTo(statement);
        String cmpString = (statement = statement.replace(DB_PostgreSQL.NATIVE_MARKER, "")).toUpperCase();
        boolean isCreate = cmpString.startsWith("CREATE ");
        if (!(isCreate && cmpString.indexOf(" FUNCTION ") != -1 || isCreate && cmpString.indexOf(" TRIGGER ") != -1 || isCreate && cmpString.indexOf(" PROCEDURE ") != -1 || isCreate && cmpString.indexOf(" VIEW ") != -1)) {
            if (cmpString.indexOf("ALTER TABLE") != -1) {
                statement = this.recoverQuotedStrings(statement, retVars);
                retVars.clear();
                statement = this.convertDDL(this.convertComplexStatement(statement));
            } else if (cmpString.indexOf("DELETE ") != -1 && cmpString.indexOf("DELETE FROM") == -1) {
                statement = this.convertDelete(statement);
                statement = this.convertComplexStatement(this.convertAlias(statement));
            } else {
                statement = cmpString.indexOf("DELETE FROM") != -1 ? this.convertComplexStatement(this.convertAlias(statement)) : (cmpString.indexOf("UPDATE ") != -1 ? this.convertComplexStatement(this.convertUpdate(this.convertAlias(statement))) : this.convertComplexStatement(this.convertAlias(statement)));
            }
        }
        if (retVars.size() > 0) {
            statement = this.recoverQuotedStrings(statement, retVars);
        }
        result.add(statement);
        if ("true".equals(System.getProperty("org.idempiere.db.postgresql.debug"))) {
            log.warning("Oracle -> " + sqlStatement);
            log.warning("PgSQL  -> " + statement);
        }
        return result;
    }

    private String convertSimilarTo(String statement) {
        String retValue = statement;
        boolean useSimilarTo = "Y".equals(Env.getContext((Properties)Env.getCtx(), (String)"P|IsUseSimilarTo"));
        if (useSimilarTo) {
            String regex = "\\bLIKE\\b";
            String replacement = "SIMILAR TO";
            try {
                Pattern p = Pattern.compile(regex, 34);
                Matcher m = p.matcher(retValue);
                retValue = m.replaceAll(replacement);
            }
            catch (Exception e) {
                String error = "Error expression: " + regex + " - " + e;
                log.info(error);
                this.m_conversionError = error;
            }
        }
        return retValue;
    }

    protected String escapeQuotedString(String in) {
        StringBuilder out = new StringBuilder();
        boolean escape = false;
        int size = in.length();
        int i = 0;
        while (i < size) {
            char c = in.charAt(i);
            out.append(c);
            if (c == '\\') {
                escape = true;
                out.append(c);
            }
            ++i;
        }
        if (escape) {
            return "E" + out.toString();
        }
        return out.toString();
    }

    protected String convertComplexStatement(String sqlStatement) {
        String retValue = sqlStatement;
        int found = retValue.toUpperCase().indexOf("DECODE");
        int fromIndex = 0;
        while (found != -1) {
            retValue = this.convertDecode(retValue, fromIndex);
            fromIndex = found + 6;
            found = retValue.toUpperCase().indexOf("DECODE", fromIndex);
        }
        int index = retValue.toUpperCase().indexOf("SELECT ");
        if (index != -1 && retValue.indexOf("(+)", index) != -1) {
            retValue = this.convertOuterJoin(retValue);
        }
        retValue = this.convertCast(retValue);
        return retValue;
    }

    private String convertCast(String sqlStatement) {
        String PATTERN_String = "'([^']|(''))*'";
        String PATTERN_DataType = "([\\w]+)(\\(\\d+\\))?";
        String pattern = "\\bCAST\\b[\\s]*\\([\\s]*(('([^']|(''))*')|([^\\s]+))[\\s]*AS[\\s]*(([\\w]+)(\\(\\d+\\))?)\\s*\\)";
        boolean gidx_arg1 = true;
        int gidx_arg2 = 7;
        Pattern p = Pattern.compile("\\bCAST\\b[\\s]*\\([\\s]*(('([^']|(''))*')|([^\\s]+))[\\s]*AS[\\s]*(([\\w]+)(\\(\\d+\\))?)\\s*\\)", 2);
        Matcher m = p.matcher(sqlStatement);
        TreeMap convertMap = (TreeMap)this.getConvertMap();
        StringBuffer retValue = new StringBuffer(sqlStatement.length());
        while (m.find()) {
            String arg1 = m.group(1);
            String arg2 = m.group(7);
            String datatype = (String)convertMap.get("\\b" + arg2.toUpperCase() + "\\b");
            if (datatype == null) {
                datatype = arg2;
            }
            m.appendReplacement(retValue, "cast(" + arg1 + " as " + datatype + ")");
        }
        m.appendTail(retValue);
        return retValue.toString();
    }

    private String convertUpdate(String sqlStatement) {
        String targetTable = null;
        String targetAlias = null;
        String sqlUpper = sqlStatement.toUpperCase();
        StringBuilder token = new StringBuilder();
        String previousToken = null;
        int charIndex = 0;
        int sqlLength = sqlUpper.length();
        int cnt = 0;
        boolean isUpdate = false;
        while (charIndex < sqlLength) {
            char c = sqlStatement.charAt(charIndex);
            if (Character.isWhitespace(c)) {
                if (token.length() > 0) {
                    if (++cnt == 1) {
                        isUpdate = "UPDATE".equalsIgnoreCase(token.toString());
                    } else if (cnt == 2) {
                        targetTable = token.toString();
                    } else if (cnt == 3 && "SET".equalsIgnoreCase(targetAlias = token.toString().trim())) {
                        targetAlias = targetTable;
                    }
                    previousToken = token.toString();
                    token = new StringBuilder();
                }
            } else {
                if ("SET".equalsIgnoreCase(previousToken)) break;
                token.append(c);
            }
            ++charIndex;
        }
        if (isUpdate && targetTable != null && sqlUpper.charAt(charIndex) == '(') {
            int updateFieldsBegin = charIndex;
            String updateFields = null;
            String select = "";
            String beforePreviousToken = null;
            previousToken = null;
            token = new StringBuilder();
            while (charIndex < sqlLength) {
                char c = sqlUpper.charAt(charIndex);
                if (Character.isWhitespace(c)) {
                    if (token.length() > 0) {
                        String currentToken = token.toString();
                        if ("(".equals(currentToken) || currentToken != null && currentToken.startsWith("(")) {
                            if ((")".equals(beforePreviousToken) || beforePreviousToken != null && beforePreviousToken.endsWith(")")) && "=".equals(previousToken)) {
                                select = sqlStatement.substring(charIndex - currentToken.length());
                                updateFields = sqlStatement.substring(updateFieldsBegin, charIndex);
                                updateFields = updateFields.substring(0, updateFields.lastIndexOf(41));
                                break;
                            }
                            if (")=".equals(previousToken)) {
                                select = sqlStatement.substring(charIndex - currentToken.length());
                                updateFields = sqlStatement.substring(updateFieldsBegin, charIndex);
                                updateFields = updateFields.substring(0, updateFields.lastIndexOf(41));
                                break;
                            }
                            if (previousToken != null && previousToken.endsWith(")=")) {
                                select = sqlStatement.substring(charIndex - currentToken.length());
                                updateFields = sqlStatement.substring(updateFieldsBegin, charIndex);
                                updateFields = updateFields.substring(0, updateFields.lastIndexOf(41));
                                break;
                            }
                        }
                        if (")=(".equals(currentToken)) {
                            select = sqlStatement.substring(charIndex - 1);
                            updateFields = sqlStatement.substring(updateFieldsBegin, charIndex);
                            updateFields = updateFields.substring(0, updateFields.lastIndexOf(41));
                            break;
                        }
                        if (currentToken.endsWith(")=(SELECT")) {
                            select = sqlStatement.substring(charIndex - 7);
                            updateFields = sqlStatement.substring(updateFieldsBegin, charIndex);
                            updateFields = updateFields.substring(0, updateFields.lastIndexOf(41));
                            break;
                        }
                        if (("=(".equals(currentToken) || currentToken != null && currentToken.startsWith("=(")) && (")".equals(previousToken) || previousToken != null && previousToken.endsWith(")"))) {
                            select = sqlStatement.substring(charIndex - currentToken.length());
                            updateFields = sqlStatement.substring(updateFieldsBegin, charIndex);
                            updateFields = updateFields.substring(0, updateFields.lastIndexOf(41));
                            break;
                        }
                        beforePreviousToken = previousToken;
                        previousToken = token.toString();
                        token = new StringBuilder();
                    }
                } else {
                    token.append(c);
                }
                ++charIndex;
            }
            if (updateFields != null && updateFields.startsWith("(")) {
                updateFields = updateFields.substring(1);
            }
            int subQueryEnd = 0;
            int subQueryStart = select.indexOf(40);
            String subWhere = null;
            int open = -1;
            int i = subQueryStart;
            while (i < select.length()) {
                char c = select.charAt(i);
                if (c == '(') {
                    ++open;
                }
                if (c == ')') {
                    --open;
                }
                if (open == -1) {
                    subQueryEnd = i + 1;
                    break;
                }
                ++i;
            }
            String mainWhere = "";
            String otherUpdateFields = "";
            token = new StringBuilder();
            int i2 = subQueryEnd;
            while (i2 < select.length()) {
                char c = select.charAt(i2);
                if (Character.isWhitespace(c)) {
                    if (token.length() > 0) {
                        if ("WHERE".equalsIgnoreCase(token.toString())) {
                            otherUpdateFields = select.substring(subQueryEnd, i2 - 5).trim();
                            mainWhere = select.substring(i2 + 1);
                            break;
                        }
                        token = new StringBuilder();
                    }
                } else {
                    token.append(c);
                }
                ++i2;
            }
            String subQuery = select.substring(subQueryStart, subQueryEnd);
            String joinTable = null;
            String joinAlias = null;
            token = new StringBuilder();
            previousToken = null;
            int joinFieldsBegin = 0;
            String joinFields = null;
            String joinFromClause = null;
            int joinFromClauseStart = 0;
            open = -1;
            int i3 = 0;
            while (i3 < subQuery.length()) {
                char c = subQuery.charAt(i3);
                if (Character.isWhitespace(c)) {
                    if (token.length() > 0 && open < 0) {
                        if ("FROM".equalsIgnoreCase(previousToken)) {
                            joinTable = token.toString();
                        }
                        if ("WHERE".equalsIgnoreCase(token.toString())) {
                            subWhere = subQuery.substring(i3 + 1, subQuery.length() - 1);
                            joinFromClause = subQuery.substring(joinFromClauseStart, i3 - 5).trim();
                            break;
                        }
                        if ("FROM".equalsIgnoreCase(token.toString())) {
                            joinFields = subQuery.substring(joinFieldsBegin, i3 - 4);
                            joinFromClauseStart = i3;
                        }
                        if (previousToken != null && previousToken.equals(joinTable)) {
                            joinAlias = token.toString();
                        }
                        previousToken = token.toString();
                        token = new StringBuilder();
                    }
                } else {
                    if (joinFieldsBegin == 0) {
                        if (token.length() == 0 && ("SELECT".equalsIgnoreCase(previousToken) || previousToken != null && previousToken.toUpperCase().endsWith("SELECT"))) {
                            joinFieldsBegin = i3;
                        }
                    } else if (c == '(') {
                        ++open;
                    } else if (c == ')') {
                        --open;
                    }
                    token.append(c);
                }
                ++i3;
            }
            if (joinFromClause == null) {
                joinFromClause = subQuery.substring(joinFromClauseStart).trim();
            }
            if (joinAlias == null) {
                joinAlias = joinTable;
            }
            StringBuilder Update = new StringBuilder("UPDATE ");
            Update.append(targetTable);
            if (!targetAlias.equals(targetTable)) {
                Update.append(" " + targetAlias);
            }
            Update.append(" SET ");
            int f = updateFields != null ? updateFields.length() : 0;
            int fj = joinFields.length();
            String updateField = null;
            String joinField = null;
            boolean useSubQuery = false;
            if (this.useAggregateFunction(joinFields)) {
                useSubQuery = true;
            }
            while (f > 0) {
                f = Util.findIndexOf((String)updateFields, (char)',');
                if (f < 0) {
                    updateField = updateFields;
                    joinField = joinFields.trim();
                    if (joinField.indexOf(46) < 0 && this.isIdentifier(joinField)) {
                        joinField = String.valueOf(joinAlias) + "." + joinField;
                    }
                    Update.append(updateField.trim());
                    Update.append("=");
                    if (useSubQuery) {
                        Update.append("( SELECT ");
                        Update.append(joinField);
                        Update.append(" FROM ");
                        Update.append(joinFromClause);
                        Update.append(" WHERE ");
                        Update.append(subWhere.trim());
                        Update.append(" ) ");
                        Update.append(otherUpdateFields);
                        if (mainWhere != null) {
                            Update.append(" WHERE ");
                            Update.append(mainWhere);
                        }
                    } else {
                        Update.append(joinField);
                        Update.append(otherUpdateFields);
                        Update.append(" FROM ");
                        Update.append(joinFromClause);
                        Update.append(" WHERE ");
                        subWhere = this.addAliasToIdentifier(subWhere, joinAlias);
                        Update.append(subWhere.trim());
                        mainWhere = mainWhere != null ? " AND " + mainWhere : "";
                        mainWhere = this.addAliasToIdentifier(mainWhere, targetAlias);
                        Update.append(mainWhere);
                    }
                } else {
                    updateField = updateFields.substring(0, f);
                    fj = Util.findIndexOf((String)joinFields, (char)',');
                    String string = joinField = fj > 0 ? joinFields.substring(0, fj).trim() : joinFields.trim();
                    if (joinField.indexOf(46) < 0 && this.isIdentifier(joinField)) {
                        joinField = String.valueOf(joinAlias) + "." + joinField;
                    }
                    Update.append(updateField.trim());
                    Update.append("=");
                    if (useSubQuery) {
                        Update.append("( SELECT ");
                        Update.append(joinField);
                        Update.append(" FROM ");
                        Update.append(joinFromClause);
                        Update.append(" WHERE ");
                        Update.append(subWhere.trim());
                        Update.append(" ) ");
                    } else {
                        Update.append(joinField);
                    }
                    Update.append(",");
                    joinFields = joinFields.substring(fj + 1);
                }
                updateFields = updateFields.substring(f + 1);
            }
            return Update.toString();
        }
        return sqlStatement;
    }

    private boolean useAggregateFunction(String fields) {
        String fieldsUpper = fields.toUpperCase();
        int size = fieldsUpper.length();
        StringBuilder buffer = new StringBuilder();
        String token = null;
        int i = 0;
        while (i < size) {
            char ch = fieldsUpper.charAt(i);
            if (Character.isWhitespace(ch)) {
                if (buffer.length() > 0) {
                    token = buffer.toString();
                    buffer = new StringBuilder();
                }
            } else if (this.isOperator(ch)) {
                if (buffer.length() > 0) {
                    token = buffer.toString();
                    buffer = new StringBuilder();
                } else {
                    token = null;
                }
                if (ch == '(' && token != null && (token.equals("SUM") || token.equals("MAX") || token.equals("MIN") || token.equals("COUNT") || token.equals("AVG"))) {
                    return true;
                }
            } else {
                buffer.append(ch);
            }
            ++i;
        }
        return false;
    }

    private String addAliasToIdentifier(String where, String alias) {
        String sqlkey = "AND,OR,FROM,WHERE,JOIN,BY,GROUP,IN,INTO,SELECT,NOT,SET,UPDATE,DELETE,HAVING,IS,NULL,EXISTS,BETWEEN,LIKE,INNER,OUTER";
        StringTokenizer st = new StringTokenizer(where);
        String result = "";
        String token = "";
        int o = -1;
        do {
            String test;
            String string = test = (token = st.nextToken()).startsWith("(") ? token.substring(1) : token;
            if (sqlkey.indexOf(test) == -1) {
                token = token.trim();
                if (o != -1) {
                    result = String.valueOf(result) + " " + token;
                } else {
                    result = String.valueOf(result) + " ";
                    StringBuilder t = new StringBuilder();
                    int i = 0;
                    while (i < token.length()) {
                        char c = token.charAt(i);
                        if (this.isOperator(c)) {
                            if (t.length() > 0) {
                                result = c == '(' ? String.valueOf(result) + t.toString() : (this.isIdentifier(t.toString()) && t.toString().indexOf(46) == -1 ? String.valueOf(result) + alias + "." + t.toString() : String.valueOf(result) + t.toString());
                                t = new StringBuilder();
                            }
                            result = String.valueOf(result) + c;
                        } else {
                            t.append(c);
                        }
                        ++i;
                    }
                    if (t.length() > 0) {
                        if ("SELECT".equalsIgnoreCase(t.toString().toUpperCase())) {
                            o = 0;
                            result = String.valueOf(result) + t.toString();
                        } else {
                            result = this.isIdentifier(t.toString()) && t.toString().indexOf(46) == -1 ? String.valueOf(result) + alias + "." + t.toString() : String.valueOf(result) + t.toString();
                        }
                    }
                }
                if (o == -1) continue;
                int i = 0;
                while (i < token.length()) {
                    char c = token.charAt(i);
                    if (c == '(') {
                        ++o;
                    }
                    if (c == ')') {
                        --o;
                    }
                    ++i;
                }
            } else {
                result = String.valueOf(result) + " " + token;
                if (!"SELECT".equalsIgnoreCase(test)) continue;
                o = 0;
            }
        } while (st.hasMoreElements());
        return result;
    }

    private boolean isIdentifier(String token) {
        int size = token.length();
        int i = 0;
        while (i < size) {
            char c = token.charAt(i);
            if (this.isOperator(c)) {
                return false;
            }
            ++i;
        }
        if (token.startsWith("'") && token.endsWith("'")) {
            return false;
        }
        try {
            new BigDecimal(token);
            return false;
        }
        catch (NumberFormatException numberFormatException) {
            return !this.isSQLFunctions(token);
        }
    }

    private boolean isSQLFunctions(String token) {
        if (token.equalsIgnoreCase("current_timestamp")) {
            return true;
        }
        if (token.equalsIgnoreCase("current_time")) {
            return true;
        }
        if (token.equalsIgnoreCase("current_date")) {
            return true;
        }
        if (token.equalsIgnoreCase("localtime")) {
            return true;
        }
        return token.equalsIgnoreCase("localtimestamp");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String convertAlias(String sqlStatement) {
        String[] tokens = sqlStatement.split("\\s");
        String table = null;
        String alias = null;
        if ("UPDATE".equalsIgnoreCase(tokens[0])) {
            if ("SET".equalsIgnoreCase(tokens[2])) {
                return sqlStatement;
            }
            table = tokens[1];
            alias = tokens[2];
        } else if ("INSERT".equalsIgnoreCase(tokens[0])) {
            if ("VALUES".equalsIgnoreCase(tokens[3])) return sqlStatement;
            if ("SELECT".equalsIgnoreCase(tokens[3])) {
                return sqlStatement;
            }
            if (tokens[2].indexOf(40) > 0) {
                return sqlStatement;
            }
            if (tokens[3].indexOf(40) >= 0) {
                if (tokens[3].indexOf(40) <= 0) return sqlStatement;
            }
            table = tokens[2];
            alias = tokens[3];
        } else if ("DELETE".equalsIgnoreCase(tokens[0])) {
            if (tokens.length < 4) {
                return sqlStatement;
            }
            if ("WHERE".equalsIgnoreCase(tokens[3])) {
                return sqlStatement;
            }
            table = tokens[2];
            alias = tokens[3];
        }
        if (table == null) return sqlStatement;
        if (alias == null) return sqlStatement;
        if (alias.indexOf(40) > 0) {
            alias = alias.substring(0, alias.indexOf(40));
        }
        String converted = sqlStatement.replaceFirst("\\s" + alias + "\\s", " ");
        converted = converted.replaceAll("\\b" + alias + "\\.", String.valueOf(table) + ".");
        converted = converted.replaceAll("[+]" + alias + "\\.", "+" + table + ".");
        converted = converted.replaceAll("[-]" + alias + "\\.", "-" + table + ".");
        converted = converted.replaceAll("[*]" + alias + "\\.", "*" + table + ".");
        converted = converted.replaceAll("[/]" + alias + "\\.", "/" + table + ".");
        converted = converted.replaceAll("[%]" + alias + "\\.", "%" + table + ".");
        converted = converted.replaceAll("[<]" + alias + "\\.", "<" + table + ".");
        converted = converted.replaceAll("[>]" + alias + "\\.", ">" + table + ".");
        converted = converted.replaceAll("[=]" + alias + "\\.", "=" + table + ".");
        converted = converted.replaceAll("[|]" + alias + "\\.", "|" + table + ".");
        converted = converted.replaceAll("[(]" + alias + "\\.", "(" + table + ".");
        return converted.replaceAll("[)]" + alias + "\\.", ")" + table + ".");
    }

    private String convertDDL(String sqlStatement) {
        if (sqlStatement.toUpperCase().indexOf("ALTER TABLE ") == 0) {
            String action = null;
            int begin_col = -1;
            if (sqlStatement.toUpperCase().indexOf(" MODIFY ") > 0) {
                action = " MODIFY ";
                begin_col = sqlStatement.toUpperCase().indexOf(" MODIFY ") + action.length();
            } else if (sqlStatement.toUpperCase().indexOf(" ADD ") > 0 && sqlStatement.toUpperCase().indexOf(" ADD CONSTRAINT ") < 0 && sqlStatement.toUpperCase().indexOf(" ADD FOREIGN KEY ") < 0) {
                action = " ADD ";
                begin_col = sqlStatement.toUpperCase().indexOf(" ADD ") + action.length();
            }
            if (begin_col < 0) {
                return sqlStatement;
            }
            int end_col = 0;
            int begin_default = -1;
            String column = null;
            String type = null;
            String defaultvalue = null;
            String nullclause = null;
            String DDL = null;
            if (begin_col != -1) {
                column = sqlStatement.substring(begin_col);
                end_col = begin_col + column.indexOf(32);
                column = sqlStatement.substring(begin_col, end_col);
                String rest = sqlStatement.substring(end_col + 1);
                if (action.equals(" ADD ")) {
                    if (rest.toUpperCase().indexOf(" DEFAULT ") != -1) {
                        String beforeDefault = rest.substring(0, rest.toUpperCase().indexOf(" DEFAULT "));
                        begin_default = rest.toUpperCase().indexOf(" DEFAULT ") + 9;
                        defaultvalue = rest.substring(begin_default);
                        int nextspace = defaultvalue.indexOf(32);
                        if (nextspace > -1) {
                            rest = defaultvalue.substring(nextspace);
                            defaultvalue = defaultvalue.substring(0, defaultvalue.indexOf(32));
                        } else {
                            rest = "";
                        }
                        DDL = defaultvalue.equalsIgnoreCase("NULL") || defaultvalue.equalsIgnoreCase("statement_timestamp()") ? String.valueOf(sqlStatement.substring(0, begin_col - action.length())) + " ADD COLUMN " + column + " " + beforeDefault.trim() + " DEFAULT " + defaultvalue.trim() + " " + rest.trim() : (defaultvalue.startsWith("'") && defaultvalue.endsWith("'") ? String.valueOf(sqlStatement.substring(0, begin_col - action.length())) + " ADD COLUMN " + column + " " + beforeDefault.trim() + " DEFAULT " + defaultvalue.trim() + " " + rest.trim() : String.valueOf(sqlStatement.substring(0, begin_col - action.length())) + " ADD COLUMN " + column + " " + beforeDefault.trim() + " DEFAULT '" + defaultvalue.trim() + "' " + rest.trim());
                    } else {
                        DDL = String.valueOf(sqlStatement.substring(0, begin_col - action.length())) + action + "COLUMN " + column + " " + rest.trim();
                    }
                } else if (action.equals(" MODIFY ")) {
                    if ((rest = rest.trim()).toUpperCase().startsWith("NOT ") || rest.toUpperCase().startsWith("NULL ") || rest.toUpperCase().equals("NULL") || rest.toUpperCase().equals("NOT NULL")) {
                        type = null;
                    } else {
                        int typeEnd = rest.indexOf(32);
                        type = typeEnd > 0 ? rest.substring(0, typeEnd).trim() : rest;
                        String string = rest = typeEnd > 0 ? rest.substring(typeEnd) : "";
                    }
                    if (rest.toUpperCase().indexOf(" DEFAULT ") != -1) {
                        begin_default = rest.toUpperCase().indexOf(" DEFAULT ") + 9;
                        defaultvalue = rest.substring(begin_default);
                        int nextspace = defaultvalue.indexOf(32);
                        if (nextspace > -1) {
                            rest = defaultvalue.substring(nextspace);
                            defaultvalue = defaultvalue.substring(0, defaultvalue.indexOf(32));
                        } else {
                            rest = "";
                        }
                        defaultvalue = defaultvalue.trim();
                        if (defaultvalue.startsWith("'") && defaultvalue.endsWith("'")) {
                            defaultvalue = defaultvalue.substring(1, defaultvalue.length() - 1);
                        }
                        if (rest != null && rest.toUpperCase().indexOf("NOT NULL") >= 0) {
                            nullclause = "NOT NULL";
                        } else if (rest != null && rest.toUpperCase().indexOf("NULL") >= 0) {
                            nullclause = "NULL";
                        }
                    } else if (rest != null && rest.toUpperCase().indexOf("NOT NULL") >= 0) {
                        nullclause = "NOT NULL";
                    } else if (rest != null && rest.toUpperCase().indexOf("NULL") >= 0) {
                        nullclause = "NULL";
                    }
                    DDL = "INSERT INTO t_alter_column values('";
                    String tableName = sqlStatement.substring(0, begin_col - action.length());
                    tableName = tableName.toUpperCase().replaceAll("ALTER TABLE", "");
                    tableName = tableName.trim().toLowerCase();
                    DDL = String.valueOf(DDL) + tableName + "','" + column + "',";
                    DDL = type != null ? String.valueOf(DDL) + "'" + type + "'," : String.valueOf(DDL) + "null,";
                    DDL = nullclause != null ? String.valueOf(DDL) + "'" + nullclause + "'," : String.valueOf(DDL) + "null,";
                    DDL = defaultvalue != null ? String.valueOf(DDL) + "'" + defaultvalue + "'" : String.valueOf(DDL) + "null";
                    DDL = String.valueOf(DDL) + ")";
                }
                return DDL;
            }
        }
        return sqlStatement;
    }
}

