/*
 * Decompiled with CFR 0.152.
 */
package jpiere.plugin.webui.adwindow;

import java.util.Properties;
import jpiere.plugin.webui.adwindow.JPiereAbstractADWindowContent;
import jpiere.plugin.webui.adwindow.JPiereCompositeADTabbox;
import jpiere.plugin.webui.adwindow.JPiereIADTabbox;
import jpiere.plugin.webui.adwindow.JPiereIADTabpanel;
import org.adempiere.util.Callback;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.adwindow.BreadCrumb;
import org.adempiere.webui.component.Tabbox;
import org.adempiere.webui.component.Tabpanel;
import org.adempiere.webui.component.ToolBarButton;
import org.adempiere.webui.event.ToolbarListener;
import org.adempiere.webui.panel.IHelpContext;
import org.adempiere.webui.panel.ITabOnCloseHandler;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.model.DataStatusEvent;
import org.compiere.util.CLogger;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.KeyEvent;
import org.zkoss.zk.ui.event.SwipeEvent;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Div;
import org.zkoss.zul.Tab;
import org.zkoss.zul.Vlayout;

public class JPiereADWindowContent
extends JPiereAbstractADWindowContent {
    private static final CLogger logger = CLogger.getCLogger(JPiereADWindowContent.class);
    private Vlayout layout;
    private Div contentArea;
    private boolean isSetOnCloseHandler = false;

    public JPiereADWindowContent(Properties ctx, int windowNo, int adWindowId) {
        super(ctx, windowNo, adWindowId);
    }

    protected Component doCreatePart(Component parent) {
        this.layout = new JPiereADWindowVlayout(this);
        if (parent != null) {
            this.layout.setParent(parent);
            this.layout.setSclass("adwindow-layout");
        } else {
            this.layout.setPage(this.page);
        }
        this.layout.setSpacing("0px");
        Div north = new Div();
        north.setParent((Component)this.layout);
        north.setSclass("adwindow-north");
        Div div = new Div();
        div.setStyle("height: 100%; width: 100%");
        north.appendChild((Component)div);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)north, (String)"0");
        this.toolbar.setParent((Component)div);
        this.toolbar.setWindowNo(this.getWindowNo());
        this.breadCrumb = new BreadCrumb(this.getWindowNo());
        this.breadCrumb.setToolbarListener((ToolbarListener)this);
        this.breadCrumb.setId("breadCrumb");
        div.appendChild((Component)this.breadCrumb);
        div.addEventListener("onSwipe", (EventListener)new EventListener<SwipeEvent>(){

            public void onEvent(SwipeEvent event) throws Exception {
                ToolBarButton detailBtn;
                if ("right".equals(event.getSwipeDirection())) {
                    ToolBarButton nextBtn = JPiereADWindowContent.this.breadCrumb.getNextButton();
                    if (!nextBtn.isDisabled()) {
                        nextBtn.setDisabled(true);
                        String script = "var w=zk.Widget.$('#" + nextBtn.getUuid() + "');" + "w.fire('onClick',null,{toServer:true});";
                        Clients.response((AuResponse)new AuScript(script));
                    }
                } else if ("left".equals(event.getSwipeDirection())) {
                    ToolBarButton previousBtn = JPiereADWindowContent.this.breadCrumb.getPreviousButton();
                    if (!previousBtn.isDisabled()) {
                        previousBtn.setDisabled(true);
                        String script = "var w=zk.Widget.$('#" + previousBtn.getUuid() + "');" + "w.fire('onClick',null,{toServer:true});";
                        Clients.response((AuResponse)new AuScript(script));
                    }
                } else if ("up".equals(event.getSwipeDirection())) {
                    ToolBarButton parentBtn = JPiereADWindowContent.this.toolbar.getButton("ParentRecord");
                    if (!parentBtn.isDisabled()) {
                        parentBtn.setDisabled(true);
                        String script = "var w=zk.Widget.$('#" + parentBtn.getUuid() + "');" + "w.fire('onClick',null,{toServer:true});";
                        Clients.response((AuResponse)new AuScript(script));
                    }
                } else if ("down".equals(event.getSwipeDirection()) && !(detailBtn = JPiereADWindowContent.this.toolbar.getButton("DetailRecord")).isDisabled()) {
                    detailBtn.setDisabled(true);
                    String script = "var w=zk.Widget.$('#" + detailBtn.getUuid() + "');" + "w.fire('onClick',null,{toServer:true});";
                    Clients.response((AuResponse)new AuScript(script));
                }
            }
        });
        div.appendChild((Component)this.statusBar);
        LayoutUtils.addSclass((String)"adwindow-status", (HtmlBasedComponent)this.statusBar);
        this.contentArea = new Div();
        this.contentArea.setParent((Component)this.layout);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.contentArea, (String)"1");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.contentArea, (String)"1");
        this.contentArea.setStyle("overflow: auto;");
        this.adTabbox.createPart(this.contentArea);
        SessionManager.getSessionApplication().getKeylistener().addEventListener("onCtrlKey", (EventListener)this);
        this.layout.addEventListener("onWindowContainerSelectionChanged", (EventListener)this);
        return this.layout;
    }

    @Override
    protected JPiereIADTabbox createADTab() {
        JPiereCompositeADTabbox composite = new JPiereCompositeADTabbox();
        return composite;
    }

    public Vlayout getComponent() {
        return this.layout;
    }

    @Override
    public void onEvent(Event event) {
        if ("onCtrlKey".equals(event.getName())) {
            JPiereIADTabpanel panel;
            KeyEvent keyEvent = (KeyEvent)event;
            if (keyEvent.getKeyCode() == 13 && this.getComponent().getParent().isVisible() && (panel = this.adTabbox.getSelectedTabpanel()) != null && panel.onEnterKey()) {
                keyEvent.stopPropagation();
            }
        } else if (event.getName().equals("onWindowContainerSelectionChanged")) {
            SessionManager.getAppDesktop().updateHelpContext("T", this.adTabbox.getSelectedGridTab().getAD_Tab_ID());
        } else {
            super.onEvent(event);
        }
    }

    protected void closeTab(Tabpanel tabPanel) {
        Tab tab = tabPanel.getLinkedTab();
        tab.close();
        if (this.getWindowNo() > 0) {
            SessionManager.getAppDesktop().unregisterWindow(this.getWindowNo());
        }
    }

    @Override
    protected void switchEditStatus(boolean editStatus) {
        this.layout.setWidgetOverride("isEditting", "'" + String.valueOf(editStatus) + "'");
    }

    private void setOnCloseHandler() {
        Tabbox tabbox;
        org.zkoss.zul.Tabpanel selectedPanel;
        if (this.isSetOnCloseHandler) {
            return;
        }
        Component customForm = this.getADTab().getSelectedTabpanel().getParent().getParent().getParent().getParent();
        if (customForm.getParent() == null) {
            return;
        }
        Component tabboxComponent = customForm.getParent().getParent().getParent();
        if (tabboxComponent instanceof Tabbox && (selectedPanel = (tabbox = (Tabbox)tabboxComponent).getSelectedPanel()) instanceof org.zkoss.zul.Tabpanel) {
            TabOnCloseHanlder handler = new TabOnCloseHanlder();
            ((Tabpanel)selectedPanel).setOnCloseHandler((ITabOnCloseHandler)handler);
            this.isSetOnCloseHandler = true;
        }
    }

    @Override
    public void dataStatusChanged(DataStatusEvent e) {
        super.dataStatusChanged(e);
        this.setOnCloseHandler();
    }

    public static class JPiereADWindowVlayout
    extends Vlayout
    implements IHelpContext {
        private static final long serialVersionUID = 6104341168705201721L;
        private JPiereAbstractADWindowContent content;

        protected JPiereADWindowVlayout(JPiereAbstractADWindowContent content) {
            this.content = content;
        }

        public void onPageDetached(Page page) {
            super.onPageDetached(page);
            try {
                SessionManager.getSessionApplication().getKeylistener().removeEventListener("onCtrlKey", (EventListener)this.content);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class TabOnCloseHanlder
    implements ITabOnCloseHandler,
    Callback<Boolean> {
        private Tabpanel tabPanel;

        TabOnCloseHanlder() {
        }

        public void onClose(Tabpanel tabPanel) {
            this.tabPanel = tabPanel;
            JPiereADWindowContent.this.onExit(this);
        }

        public void onCallback(Boolean result) {
            if (result.booleanValue()) {
                JPiereADWindowContent.this.closeTab(this.tabPanel);
            }
            this.tabPanel = null;
        }
    }
}

