/*
 * Decompiled with CFR 0.152.
 */
package jpiere.plugin.webui.adwindow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import jpiere.plugin.webui.adwindow.JPiereADWindowContent;
import org.adempiere.webui.adwindow.ADWindow;
import org.adempiere.webui.exception.ApplicationException;
import org.adempiere.webui.part.AbstractUIPart;
import org.adempiere.webui.session.SessionManager;
import org.compiere.model.MImage;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.model.MToolBarButton;
import org.compiere.model.MToolBarButtonRestrict;
import org.compiere.model.MWindow;
import org.compiere.model.X_AD_ToolBarButton;
import org.compiere.util.Env;
import org.zkoss.zk.ui.Component;

public class JPiereADWindow
extends AbstractUIPart {
    public static final String AD_WINDOW_ATTRIBUTE_KEY = "jpiere.plugin.webui.JPiereADWindow";
    private JPiereADWindowContent windowContent;
    private Properties ctx;
    private int adWindowId;
    private String _title;
    private int windowNo;
    private MQuery query;
    private Component windowPanelComponent;
    private MImage image;
    private Map<Integer, List<String>> tabToolbarRestricMap = new HashMap<Integer, List<String>>();
    private List<String> windowToolbarRestrictList = null;
    private List<String> windowToolbarAdvancedList = null;
    private String adWindowUUID;

    public JPiereADWindow(Properties ctx, int adWindowId) {
        this(ctx, adWindowId, null);
    }

    public JPiereADWindow(Properties ctx, int adWindowId, MQuery query) {
        if (adWindowId <= 0) {
            throw new IllegalArgumentException("Window Id is invalid");
        }
        this.ctx = ctx;
        this.adWindowId = adWindowId;
        this.adWindowUUID = MWindow.get((Properties)ctx, (int)adWindowId).getAD_Window_UU();
        this.windowNo = SessionManager.getAppDesktop().registerWindow((Object)this);
        this.query = query;
        try {
            this.init();
        }
        catch (Exception e) {
            SessionManager.getAppDesktop().unregisterWindow(this.windowNo);
            throw new ApplicationException(e.getMessage(), e);
        }
    }

    private void init() {
        this.windowContent = new JPiereADWindowContent(this.ctx, this.windowNo, this.adWindowId);
        this.windowContent.setADWindow(this);
        this._title = this.windowContent.getTitle();
        this.image = this.windowContent.getImage();
    }

    public String getTitle() {
        return this._title;
    }

    public MImage getMImage() {
        return this.image;
    }

    protected Component doCreatePart(Component parent) {
        this.windowPanelComponent = this.windowContent.createPart(parent);
        this.windowPanelComponent.setAttribute(AD_WINDOW_ATTRIBUTE_KEY, (Object)this);
        this.windowPanelComponent.setAttribute("desktop.windowno", (Object)this.windowNo);
        if (this.windowContent.initPanel(this.query)) {
            return this.windowPanelComponent;
        }
        this.windowPanelComponent.detach();
        return null;
    }

    public Component getComponent() {
        return this.windowPanelComponent;
    }

    public JPiereADWindowContent getJPiereADWindowContent() {
        return this.windowContent;
    }

    public List<String> getTabToolbarRestrictList(int AD_Tab_ID) {
        List<String> tabRestrictList = this.tabToolbarRestricMap.get(AD_Tab_ID);
        if (tabRestrictList == null) {
            tabRestrictList = new ArrayList<String>();
            this.tabToolbarRestricMap.put(AD_Tab_ID, tabRestrictList);
            int[] restrictionList = MToolBarButtonRestrict.getOfTab((Properties)Env.getCtx(), (int)MRole.getDefault().getAD_Role_ID(), (int)this.adWindowId, (int)AD_Tab_ID, null);
            int i = 0;
            while (i < restrictionList.length) {
                int ToolBarButton_ID = restrictionList[i];
                X_AD_ToolBarButton tbt = new X_AD_ToolBarButton(Env.getCtx(), ToolBarButton_ID, null);
                String restrictName = "Btn" + tbt.getComponentName();
                tabRestrictList.add(restrictName);
                ++i;
            }
        }
        return tabRestrictList;
    }

    public List<String> getWindowToolbarRestrictList() {
        if (this.windowToolbarRestrictList == null) {
            this.windowToolbarRestrictList = new ArrayList<String>();
            int[] restrictionList = MToolBarButtonRestrict.getOfWindow((Properties)Env.getCtx(), (int)MRole.getDefault().getAD_Role_ID(), (int)this.adWindowId, (boolean)false, null);
            int i = 0;
            while (i < restrictionList.length) {
                int ToolBarButton_ID = restrictionList[i];
                X_AD_ToolBarButton tbt = new X_AD_ToolBarButton(Env.getCtx(), ToolBarButton_ID, null);
                String restrictName = "Btn" + tbt.getComponentName();
                this.windowToolbarRestrictList.add(restrictName);
                ++i;
            }
        }
        return this.windowToolbarRestrictList;
    }

    public List<String> getWindowAdvancedButtonList() {
        if (this.windowToolbarAdvancedList == null) {
            this.windowToolbarAdvancedList = new ArrayList<String>();
            MToolBarButton[] buttons = MToolBarButton.getWindowAdvancedButtons();
            int i = 0;
            while (i < buttons.length) {
                String restrictName = "Btn" + buttons[i].getComponentName();
                this.windowToolbarAdvancedList.add(restrictName);
                ++i;
            }
        }
        return this.windowToolbarAdvancedList;
    }

    public int getAD_Window_ID() {
        return this.adWindowId;
    }

    public String getAD_Window_UU() {
        return this.adWindowUUID;
    }

    public static JPiereADWindow get(int windowNo) {
        Object window = SessionManager.getAppDesktop().findWindow(windowNo);
        if (window != null && window instanceof ADWindow) {
            return (JPiereADWindow)((Object)SessionManager.getAppDesktop().findWindow(windowNo));
        }
        return null;
    }

    public static JPiereADWindow findADWindow(Component comp) {
        Component parent = comp.getParent();
        while (parent != null) {
            if (parent.getAttribute(AD_WINDOW_ATTRIBUTE_KEY) != null) {
                JPiereADWindow adwindow = (JPiereADWindow)((Object)parent.getAttribute(AD_WINDOW_ATTRIBUTE_KEY));
                return adwindow;
            }
            parent = parent.getParent();
        }
        return null;
    }
}

