/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.fitnesse.server.fit;

import fit.Fixture;
import fit.FixtureClass;
import fit.FixtureLoader;
import fit.FixtureName;
import fit.exception.CouldNotLoadComponentFitFailureException;
import fit.exception.NoSuchFixtureException;
import java.util.List;
import org.adempiere.base.Service;
import org.idempiere.fitnesse.server.fit.IFitFixtureFactory;

public class OSGiFixtureLoader
extends FixtureLoader {
    public Fixture disgraceThenLoad(String className) throws Throwable {
        FixtureName fixtureName = new FixtureName(className);
        List factories = Service.locator().list(IFitFixtureFactory.class).getServices();
        for (IFitFixtureFactory factory : factories) {
            Object fixture = factory.getFixture(fixtureName);
            if (fixture == null || !(fixture instanceof Fixture)) continue;
            return (Fixture)fixture;
        }
        Fixture fixture = this.instantiateFirstValidFixtureClass(fixtureName);
        return fixture;
    }

    private Fixture instantiateFixture(String fixtureName) throws Throwable {
        Class<?> classForFixture = this.loadFixtureClass(fixtureName);
        FixtureClass fixtureClass = new FixtureClass(classForFixture);
        return fixtureClass.newInstance();
    }

    private Class<?> loadFixtureClass(String fixtureName) {
        try {
            return ((Object)((Object)this)).getClass().getClassLoader().loadClass(fixtureName);
        }
        catch (ClassNotFoundException deadEnd) {
            if (deadEnd.getMessage().equals(fixtureName)) {
                throw new NoSuchFixtureException(fixtureName);
            }
            throw new CouldNotLoadComponentFitFailureException(deadEnd.getMessage(), fixtureName);
        }
    }

    private Fixture instantiateFirstValidFixtureClass(FixtureName fixtureName) throws Throwable {
        for (String each : fixtureName.getPotentialFixtureClassNames(this.fixturePathElements)) {
            try {
                return this.instantiateFixture(each);
            }
            catch (NoSuchFixtureException noSuchFixtureException) {
                // empty catch block
            }
        }
        throw new NoSuchFixtureException(fixtureName.toString());
    }
}

