/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.Converter;
import fitnesse.slim.ConverterSupport;
import fitnesse.slim.FixtureMethodExecutor;
import fitnesse.slim.Library;
import fitnesse.slim.LibraryMethodExecutor;
import fitnesse.slim.MethodExecutionResult;
import fitnesse.slim.MethodExecutionResults;
import fitnesse.slim.MethodExecutor;
import fitnesse.slim.SlimError;
import fitnesse.slim.SlimHelperLibrary;
import fitnesse.slim.StatementExecutorConsumer;
import fitnesse.slim.StatementExecutorInterface;
import fitnesse.slim.SystemUnderTestMethodExecutor;
import fitnesse.slim.VariableStore;
import fitnesse.slim.converters.MapEditor;
import java.beans.PropertyEditorManager;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.adempiere.base.Service;
import org.idempiere.fitnesse.server.slim.ISlimFixtureFactory;

public class StatementExecutor
implements StatementExecutorInterface {
    private static final String SLIM_HELPER_LIBRARY_INSTANCE_NAME = "SlimHelperLibrary";
    private Map<String, Object> instances = new HashMap<String, Object>();
    private List<Library> libraries = new ArrayList<Library>();
    private List<MethodExecutor> executorChain = new ArrayList<MethodExecutor>();
    private VariableStore variables = new VariableStore();
    private List<String> paths = new ArrayList<String>();
    private boolean stopRequested = false;

    public StatementExecutor() {
        PropertyEditorManager.registerEditor(Map.class, MapEditor.class);
        this.executorChain.add((MethodExecutor)new FixtureMethodExecutor(this.instances));
        this.executorChain.add((MethodExecutor)new SystemUnderTestMethodExecutor(this.instances));
        this.executorChain.add((MethodExecutor)new LibraryMethodExecutor(this.libraries));
        this.addSlimHelperLibraryToLibraries();
    }

    private void addSlimHelperLibraryToLibraries() {
        SlimHelperLibrary slimHelperLibrary = new SlimHelperLibrary();
        slimHelperLibrary.setStatementExecutor(this);
        this.libraries.add(new Library(SLIM_HELPER_LIBRARY_INSTANCE_NAME, (Object)slimHelperLibrary));
    }

    public void setVariable(String name, Object value) {
        this.variables.setSymbol(name, new MethodExecutionResult(value, Object.class));
    }

    private void setVariable(String name, MethodExecutionResult value) {
        this.variables.setSymbol(name, value);
    }

    public Object addPath(String path) {
        this.paths.add(path);
        return "OK";
    }

    public Object getInstance(String instanceName) {
        Object instance = this.instances.get(instanceName);
        if (instance != null) {
            return instance;
        }
        for (Library library : this.libraries) {
            if (!library.instanceName.equals(instanceName)) continue;
            return library.instance;
        }
        throw new SlimError(String.format("message:<<NO_INSTANCE %s.>>", instanceName));
    }

    public Converter getConverter(Class<?> k) {
        return ConverterSupport.getConverter(k);
    }

    public Object create(String instanceName, String className, Object[] args) {
        try {
            if (this.hasStoredActor(className)) {
                this.addToInstancesOrLibrary(instanceName, this.getStoredActor(className));
            } else {
                String replacedClassName = this.variables.replaceSymbolsInString(className);
                Object instance = this.createInstanceOfConstructor(replacedClassName, this.replaceSymbols(args));
                this.addToInstancesOrLibrary(instanceName, instance);
            }
            return "OK";
        }
        catch (SlimError e) {
            return this.couldNotInvokeConstructorException(className, args);
        }
        catch (IllegalArgumentException e) {
            return this.couldNotInvokeConstructorException(className, args);
        }
        catch (Throwable e) {
            return this.exceptionToString(e);
        }
    }

    private void addToInstancesOrLibrary(String instanceName, Object instance) {
        if (this.isLibrary(instanceName)) {
            this.libraries.add(new Library(instanceName, instance));
        } else {
            this.setInstance(instanceName, instance);
        }
    }

    public void setInstance(String instanceName, Object instance) {
        this.instances.put(instanceName, instance);
    }

    private boolean hasStoredActor(String nameWithDollar) {
        if (!this.variables.containsValueFor(nameWithDollar)) {
            return false;
        }
        Object potentialActor = this.getStoredActor(nameWithDollar);
        return potentialActor != null && !(potentialActor instanceof String);
    }

    private Object getStoredActor(String nameWithDollar) {
        return this.variables.getStored(nameWithDollar);
    }

    private boolean isLibrary(String instanceName) {
        return instanceName.startsWith("library");
    }

    private String couldNotInvokeConstructorException(String className, Object[] args) {
        return this.exceptionToString(new SlimError(String.format("message:<<COULD_NOT_INVOKE_CONSTRUCTOR %s[%d]>>", className, args.length)));
    }

    private Object createInstanceOfConstructor(String className, Object[] args) throws Exception {
        Object newInstance;
        List factories = Service.locator().list(ISlimFixtureFactory.class).getServices();
        for (ISlimFixtureFactory factory : factories) {
            newInstance = factory.getFixture(className, args);
            if (newInstance == null) continue;
            if (newInstance instanceof StatementExecutorConsumer) {
                ((StatementExecutorConsumer)newInstance).setStatementExecutor(this);
            }
            return newInstance;
        }
        Class<?> k = this.searchPathsForClass(className);
        Constructor<?> constructor = this.getConstructor(k.getConstructors(), args);
        if (constructor == null) {
            throw new SlimError(String.format("message:<<NO_CONSTRUCTOR %s>>", className));
        }
        newInstance = constructor.newInstance(ConverterSupport.convertArgs(args, constructor.getParameterTypes()));
        if (newInstance instanceof StatementExecutorConsumer) {
            ((StatementExecutorConsumer)newInstance).setStatementExecutor(this);
        }
        return newInstance;
    }

    private Class<?> searchPathsForClass(String className) {
        Class<?> k = this.getClass(className);
        if (k != null) {
            return k;
        }
        ArrayList<String> reversedPaths = new ArrayList<String>(this.paths);
        Collections.reverse(reversedPaths);
        for (String path : reversedPaths) {
            k = this.getClass(String.valueOf(path) + "." + className);
            if (k == null) continue;
            return k;
        }
        throw new SlimError(String.format("message:<<NO_CLASS %s>>", className));
    }

    private Class<?> getClass(String className) {
        try {
            return this.getClass().getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private Constructor<?> getConstructor(Constructor<?>[] constructors, Object[] args) {
        Constructor<?>[] constructorArray = constructors;
        int n = constructors.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> constructor = constructorArray[n2];
            Class<?>[] arguments = constructor.getParameterTypes();
            if (arguments.length == args.length) {
                return constructor;
            }
            ++n2;
        }
        return null;
    }

    public Object call(String instanceName, String methodName, Object ... args) {
        try {
            return this.getMethodExecutionResult(instanceName, methodName, args).returnValue();
        }
        catch (Throwable e) {
            return this.exceptionToString(e);
        }
    }

    private MethodExecutionResult getMethodExecutionResult(String instanceName, String methodName, Object ... args) throws Throwable {
        MethodExecutionResults results = new MethodExecutionResults();
        int i = 0;
        while (i < this.executorChain.size()) {
            MethodExecutionResult result = this.executorChain.get(i).execute(instanceName, methodName, this.replaceSymbols(args));
            if (result.hasResult()) {
                return result;
            }
            results.add(result);
            ++i;
        }
        return results.getFirstResult();
    }

    public Object callAndAssign(String variable, String instanceName, String methodName, Object[] args) {
        try {
            MethodExecutionResult result = this.getMethodExecutionResult(instanceName, methodName, args);
            this.setVariable(variable, result);
            return result.returnValue();
        }
        catch (Throwable e) {
            return this.exceptionToString(e);
        }
    }

    private Object[] replaceSymbols(Object[] args) {
        return this.variables.replaceSymbols(args);
    }

    private String exceptionToString(Throwable exception) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter pw = new PrintWriter(stringWriter);
        exception.printStackTrace(pw);
        if (exception.getClass().toString().contains("StopTest")) {
            this.stopRequested = true;
            return "__EXCEPTION__:ABORT_SLIM_TEST:" + stringWriter.toString();
        }
        return "__EXCEPTION__:" + stringWriter.toString();
    }

    public boolean stopHasBeenRequested() {
        return this.stopRequested;
    }

    public void reset() {
        this.stopRequested = false;
    }
}

