/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.traverse.workflow.caller;

import fit.Fixture;
import fit.FixtureName;
import fitlibrary.dynamicVariable.VariableResolver;
import fitlibrary.exception.classes.ConstructorNotVisible;
import fitlibrary.exception.classes.NoNullaryConstructor;
import fitlibrary.log.FitLibraryLogger;
import fitlibrary.runResults.TestResults;
import fitlibrary.table.Row;
import fitlibrary.table.TableFactory;
import fitlibrary.traverse.Evaluator;
import fitlibrary.traverse.workflow.AbstractDoCaller;
import fitlibrary.typed.TypedObject;
import fitlibrary.utility.ClassUtility;
import fitlibraryGeneric.typed.GenericTypedObject;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.adempiere.base.Service;
import org.apache.log4j.Logger;
import org.idempiere.fitnesse.server.fit.IFitFixtureFactory;

public class CreateFromClassNameCaller
extends AbstractDoCaller {
    private static Logger logger = FitLibraryLogger.getLogger(CreateFromClassNameCaller.class);
    private static final ThreadLocal<Set<String>> packages = new ThreadLocal<Set<String>>(){

        @Override
        protected Set<String> initialValue() {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add("fit.");
            return hashSet;
        }
    };
    private String className;
    private Object object = null;
    private Exception exceptionToThrow = null;

    public CreateFromClassNameCaller(Row row, Evaluator evaluator) {
        this.className = this.substituteName(row.text(0, (VariableResolver)evaluator).trim());
        try {
            this.object = this.instantiateObject(this.className);
            if (this.object == null && this.validClassName()) {
                Class<?> determineFullClass = this.determineFullClass();
                this.object = ClassUtility.newInstance(determineFullClass);
            }
            logger.trace((Object)("Created " + this.object));
            if (row.size() > 1 && this.object instanceof Fixture) {
                this.handleArgs((Fixture)this.object, row);
            }
        }
        catch (NoSuchMethodException ex) {
            this.exceptionToThrow = new NoNullaryConstructor(this.className, evaluator.getRuntimeContext());
        }
        catch (NoClassDefFoundError ex) {
            this.exceptionToThrow = new RuntimeException(ex);
        }
        catch (InstantiationException ex) {
            this.exceptionToThrow = new NoNullaryConstructor(this.className, evaluator.getRuntimeContext());
        }
        catch (IllegalAccessException ex) {
            this.exceptionToThrow = new ConstructorNotVisible(this.className, evaluator.getRuntimeContext());
        }
        catch (InvocationTargetException ex) {
            this.exceptionToThrow = ex;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private Object instantiateObject(String className) {
        FixtureName fixtureName = new FixtureName(className);
        List factories = Service.locator().list(IFitFixtureFactory.class).getServices();
        for (IFitFixtureFactory factory : factories) {
            Object fixture = factory.getFixture(fixtureName);
            if (fixture == null) continue;
            return fixture;
        }
        return null;
    }

    private boolean validClassName() {
        return !this.className.isEmpty() && !this.className.contains(" ") && (this.className.contains(".") || Character.isUpperCase(this.className.charAt(0)));
    }

    private String substituteName(String name) {
        if ("Import".equals(name) || "fit.Import".equals(name) || "ImportFixture".equals(name) || "fit.ImportFixture".equals(name)) {
            return "fitlibrary.DefaultPackages";
        }
        return name;
    }

    /*
     * Unable to fully structure code
     */
    private Class<?> determineFullClass() throws ClassNotFoundException {
        loader = this.getClass().getClassLoader();
        try {
            return loader.loadClass(this.className);
        }
        catch (Throwable e) {
            try {
                return loader.loadClass(String.valueOf(this.className) + "Fixture");
            }
            catch (Throwable e1) {
                ** for (s : CreateFromClassNameCaller.packages.get())
            }
        }
lbl-1000:
        // 1 sources

        {
            try {
                return loader.loadClass(String.valueOf(s) + this.className);
            }
            catch (Exception e2) {
                try {
                    return loader.loadClass(String.valueOf(s) + this.className + "Fixture");
                }
                catch (ClassNotFoundException var7_8) {
                }
                catch (NoClassDefFoundError var7_9) {
                    // empty catch block
                }
            }
            continue;
        }
lbl19:
        // 1 sources

        throw new ClassNotFoundException(this.className);
    }

    private void handleArgs(Fixture fixture, Row row) {
        fixture.getArgsForTable(TableFactory.table((Row[])new Row[]{row}).asParse());
    }

    public boolean isValid() {
        return this.object != null || this.exceptionToThrow != null;
    }

    public String ambiguityErrorMessage() {
        return "class " + this.className;
    }

    public TypedObject run(Row row, TestResults testResults) throws Exception {
        if (this.exceptionToThrow != null) {
            throw this.exceptionToThrow;
        }
        return new GenericTypedObject(this.object);
    }

    public static void addDefaultPackage(String name) {
        packages.get().add(String.valueOf(name) + ".");
    }
}

