/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.pipo2.AbstractElementHandler;
import org.adempiere.pipo2.Element;
import org.adempiere.pipo2.PIPOContext;
import org.adempiere.pipo2.POFinder;
import org.adempiere.pipo2.PackIn;
import org.adempiere.pipo2.ReferenceUtils;
import org.compiere.model.MAttachment;
import org.compiere.model.MAttachmentEntry;
import org.compiere.model.MColumn;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.POInfo;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class PoFiller {
    PO po = null;
    private AbstractElementHandler handler;
    private PIPOContext ctx;
    private Element element;

    public PoFiller(PIPOContext ctx, PO po, Element element, AbstractElementHandler handler) {
        this.ctx = ctx;
        this.po = po;
        this.element = element;
        this.handler = handler;
    }

    protected String getStringValue(String columnName) {
        Element e = this.element.properties.get(columnName);
        String value = e != null ? e.contents.toString() : null;
        value = "".equals(value) ? null : value;
        return value;
    }

    protected boolean isBlobOnPackinFile(String columnName) {
        String value = this.getStringValue(columnName);
        if (value == null) {
            return false;
        }
        String[] strParts = value.split("[|]");
        return strParts.length == 2;
    }

    public void setString(String columnName) {
        String value = this.getStringValue(columnName);
        Object oldValue = this.po.get_Value(columnName);
        if (value == null && oldValue == null) {
            return;
        }
        if (oldValue != null && oldValue.toString().equals(value)) {
            return;
        }
        if (this.po instanceof MColumn && "IsToolbarButton".equals(columnName)) {
            if ("true".equals(value)) {
                value = "Y";
            } else if ("false".equals(value)) {
                value = "N";
            }
        }
        this.po.set_ValueNoCheck(columnName, (Object)value);
    }

    public void setBoolean(String columnName) {
        boolean bool;
        Element e = this.element.properties.get(columnName);
        String value = e != null ? e.contents.toString() : null;
        boolean bl = bool = "true".equals(value) || "Y".equals(value);
        if (this.po.get_Value(columnName) != null && this.po.get_ValueAsBoolean(columnName) == bool) {
            return;
        }
        this.po.set_ValueNoCheck(columnName, (Object)bool);
    }

    public void setTimestamp(String qName) {
        String value;
        Element e = this.element.properties.get(qName);
        String string = value = e != null ? e.contents.toString() : null;
        if (value != null && value.trim().length() == 0) {
            value = null;
        }
        Timestamp ts = value != null ? Timestamp.valueOf(value) : null;
        Object oldValue = this.po.get_Value(qName);
        if (oldValue == null && ts == null) {
            return;
        }
        if (oldValue != null && oldValue.equals(ts)) {
            return;
        }
        this.po.set_ValueNoCheck(qName, (Object)ts);
    }

    public void setInteger(String qName) {
        String value;
        Element e = this.element.properties.get(qName);
        String string = value = e != null ? e.contents.toString() : null;
        if (value != null && value.trim().length() == 0) {
            value = null;
        }
        Integer i = value != null ? new Integer(value) : null;
        Object oldValue = this.po.get_Value(qName);
        if (oldValue == null && i == null) {
            return;
        }
        if (oldValue != null && oldValue.equals(i)) {
            return;
        }
        this.po.set_ValueNoCheck(qName, (Object)i);
    }

    public void setBigDecimal(String qName) {
        String value;
        Element e = this.element.properties.get(qName);
        String string = value = e != null ? e.contents.toString() : null;
        if (value != null && value.trim().length() == 0) {
            value = null;
        }
        BigDecimal bd = value != null ? new BigDecimal(value) : null;
        Object oldValue = this.po.get_Value(qName);
        if (oldValue == null && bd == null) {
            return;
        }
        if (oldValue != null && oldValue.equals(bd)) {
            return;
        }
        this.po.set_ValueNoCheck(qName, (Object)bd);
    }

    public int setTableReference(String qName) {
        Element e = this.element.properties.get(qName);
        if (e == null) {
            return 0;
        }
        String value = e.contents.toString();
        String columnName = qName;
        if (value != null && value.trim().length() > 0) {
            int id = ReferenceUtils.resolveReference(this.ctx.ctx, e, this.po.get_TrxName());
            if (columnName.equals("AD_Client_ID") && id > 0 && id != Env.getAD_Client_ID((Properties)this.ctx.ctx)) {
                return -1;
            }
            if (this.po.get_ColumnIndex(columnName) >= 0) {
                MColumn col;
                String refTableName;
                if (id > 0) {
                    if (this.po.get_ValueAsInt(columnName) != id) {
                        this.po.set_ValueNoCheck(columnName, (Object)id);
                    }
                    return id;
                }
                if (id == 0 && (refTableName = (col = MColumn.get((Properties)this.ctx.ctx, (String)this.po.get_TableName(), (String)columnName)).getReferenceTableName()) != null && MTable.isZeroIDTable((String)refTableName)) {
                    this.po.set_ValueNoCheck(columnName, (Object)id);
                    return id;
                }
                return -1;
            }
            return 0;
        }
        this.po.set_ValueNoCheck(columnName, null);
        return 0;
    }

    public List<String> autoFill(List<String> excludes) {
        String sAD_Client_ID;
        POInfo info = POInfo.getPOInfo((Properties)this.po.getCtx(), (int)this.po.get_Table_ID());
        ArrayList<String> notFounds = new ArrayList<String>();
        Element clientElement = this.element.properties.get("AD_Client_ID");
        String string = sAD_Client_ID = clientElement != null ? clientElement.contents.toString() : null;
        if (sAD_Client_ID != null && sAD_Client_ID.equals("0")) {
            if (this.po.getAD_Client_ID() != 0) {
                this.po.set_ValueNoCheck("AD_Client_ID", (Object)0);
            }
            if (this.po.getAD_Org_ID() != 0) {
                this.po.setAD_Org_ID(0);
            }
        } else {
            String sAD_Org_ID;
            Element orgElement = this.element.properties.get("AD_Org_ID");
            String string2 = sAD_Org_ID = orgElement != null ? orgElement.contents.toString() : null;
            if (sAD_Org_ID != null && sAD_Org_ID.equals("0")) {
                if (this.po.getAD_Org_ID() != 0) {
                    this.po.setAD_Org_ID(0);
                }
            } else if (sAD_Org_ID != null && sAD_Org_ID.equals("@AD_Org_ID@")) {
                this.po.setAD_Org_ID(Env.getAD_Org_ID((Properties)this.ctx.ctx));
            } else if (this.setTableReference("AD_Client_ID") >= 0) {
                this.setTableReference("AD_Org_ID");
            }
        }
        for (String qName : this.element.properties.keySet()) {
            Element e;
            if (excludes != null) {
                boolean exclude = false;
                for (String ex : excludes) {
                    if (!ex.equalsIgnoreCase(qName)) continue;
                    exclude = true;
                    break;
                }
                if (exclude) continue;
            }
            if (ReferenceUtils.isLookup(e = this.element.properties.get(qName))) {
                int id = this.setTableReference(qName);
                if (id >= 0) continue;
                notFounds.add(qName);
                continue;
            }
            int index = info.getColumnIndex(qName);
            if (index < 0) continue;
            if (qName.equalsIgnoreCase(String.valueOf(this.po.get_TableName()) + "_ID")) {
                Integer i;
                String value = e != null ? e.contents.toString() : null;
                Integer n = i = !Util.isEmpty((String)value) ? new Integer(value) : null;
                if (i == null || i <= 0 || i > 999999 || this.po.get_ID() == i.intValue()) continue;
                int AD_Client_ID = Env.getAD_Client_ID((Properties)this.ctx.ctx);
                int tmp = DB.getSQLValue((String)this.ctx.trx.getTrxName(), (String)("SELECT AD_Client_ID FROM " + this.po.get_TableName() + " WHERE " + this.po.get_TableName() + "_ID=?"), (int)i);
                if (tmp > 0 && tmp != AD_Client_ID) continue;
                this.setInteger(qName);
                continue;
            }
            if (qName.equals(this.po.getUUIDColumnName())) {
                if (Env.getAD_Client_ID((Properties)this.ctx.ctx) > 0) {
                    String uuid;
                    String string3 = uuid = e != null ? e.contents.toString() : null;
                    if (Util.isEmpty((String)uuid)) continue;
                    uuid = POFinder.getTargetUUID(this.ctx.ctx, this.po.get_TableName(), uuid, this.ctx.trx.getTrxName());
                    this.po.set_ValueNoCheck(qName, (Object)uuid);
                    continue;
                }
                this.setString(qName);
                continue;
            }
            if (info.getColumnClass(index) == Boolean.class) {
                this.setBoolean(qName);
                continue;
            }
            if (info.getColumnClass(index) == BigDecimal.class) {
                this.setBigDecimal(qName);
                continue;
            }
            if (info.getColumnClass(index) == Integer.class) {
                this.setInteger(qName);
                continue;
            }
            if (info.getColumnClass(index) == Timestamp.class) {
                this.setTimestamp(qName);
                continue;
            }
            if (36 == info.getColumnDisplayType(index)) {
                if (this.getStringValue(qName) != null || !this.isBlobOnPackinFile(qName)) {
                    this.setString(qName);
                    continue;
                }
                this.setBlob(qName);
                continue;
            }
            if (DisplayType.isLOB((int)info.getColumnDisplayType(index))) {
                this.setBlob(qName);
                continue;
            }
            this.setString(qName);
        }
        return notFounds;
    }

    private void setBlob(String qName) {
        String value;
        Element pe = this.element.properties.get(qName);
        String string = value = pe != null ? pe.contents.toString() : null;
        if (value != null && value.trim().length() > 0) {
            if (this.po instanceof MAttachment && "BinaryData".equals(qName)) {
                PackIn packIn = this.ctx.packIn;
                String fileName = null;
                String[] component = value.split("[|]");
                if (component.length == 2) {
                    File[] files;
                    fileName = component[0];
                    try {
                        files = packIn.readFilesFromBlob(fileName);
                    }
                    catch (IOException e) {
                        throw new AdempiereException(e.getLocalizedMessage(), (Throwable)e);
                    }
                    MAttachment attach = (MAttachment)this.po;
                    File[] fileArray = files;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file = fileArray[n2];
                        boolean found = false;
                        int index = -1;
                        MAttachmentEntry[] mAttachmentEntryArray = attach.getEntries();
                        int n3 = mAttachmentEntryArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            MAttachmentEntry entry = mAttachmentEntryArray[n4];
                            ++index;
                            if (entry.getName().equals(file.getName())) {
                                found = true;
                                attach.updateEntry(index, file);
                                break;
                            }
                            ++n4;
                        }
                        if (!found) {
                            attach.addEntry(file);
                        }
                        ++n2;
                    }
                    if (!attach.is_Changed()) {
                        attach.set_ValueNoCheck("Updated", (Object)new Timestamp(System.currentTimeMillis()));
                    }
                }
            } else {
                Object data = null;
                byte[] bytes = null;
                String fileName = null;
                String[] component = value.split("[|]");
                if (component.length == 2) {
                    fileName = component[0];
                    String dataType = component[1];
                    PackIn packIn = this.ctx.packIn;
                    try {
                        bytes = packIn.readBlob(fileName);
                        data = "byte[]".equals(dataType) ? bytes : (Object)new String(bytes, "UTF-8");
                    }
                    catch (IOException e) {
                        throw new AdempiereException(e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                this.po.set_ValueNoCheck(qName, data);
            }
        }
    }
}

