/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.adempiere.base.IGridTabExporter;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.pipo2.PackOut;
import org.adempiere.pipo2.PackoutDocument;
import org.adempiere.pipo2.PackoutItem;
import org.compiere.Adempiere;
import org.compiere.model.GridTab;
import org.compiere.model.MUser;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class GridTab2PackExporter
implements IGridTabExporter {
    private static final CLogger logger = CLogger.getCLogger(GridTab2PackExporter.class);

    public void export(GridTab gridTab, List<GridTab> childs, boolean currentRowOnly, File file, int indxDetailSelected) {
        PackoutItem packoutItem;
        String tableName = gridTab.getTableName();
        PackOut packOut = new PackOut();
        packOut.setCtx(Env.getCtx());
        packOut.setExportDictionaryEntity(true);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.putAll(Env.getCtx());
        ArrayList<PackoutItem> packoutItems = new ArrayList<PackoutItem>();
        if (packOut.getHandler(tableName) == null) {
            properties.put("AD_Table_ID", gridTab.getAD_Table_ID());
            StringBuilder sql = new StringBuilder("SELECT * FROM ");
            sql.append(tableName);
            if (currentRowOnly) {
                sql.append(" WHERE ").append(gridTab.getTableModel().getWhereClause(gridTab.getCurrentRow()));
            } else {
                int i = 0;
                while (i < gridTab.getRowCount()) {
                    if (i == 0) {
                        sql.append(" WHERE ((");
                    } else {
                        sql.append(") OR (");
                    }
                    gridTab.navigate(i);
                    sql.append(gridTab.getTableModel().getWhereClause(gridTab.getCurrentRow()));
                    ++i;
                }
                sql.append("))");
            }
            for (GridTab child : childs) {
                if (child.getTableName().toLowerCase().endsWith("_trl")) continue;
                sql = child.getTabLevel() > gridTab.getTabLevel() + 1 ? sql.append(">").append(child.getTableName()) : sql.append(";").append(child.getTableName());
            }
            properties.put("SQLStatement", sql.toString());
            packoutItem = new PackoutItem("table.genericHandler", gridTab.getRecord_ID(), properties);
            packoutItems.add(packoutItem);
        } else if (currentRowOnly) {
            PackoutItem packoutItem2 = new PackoutItem(tableName, gridTab.getRecord_ID(), properties);
            packoutItems.add(packoutItem2);
        } else {
            int i = 0;
            while (i < gridTab.getRowCount()) {
                packoutItem = new PackoutItem(tableName, gridTab.getKeyID(i), properties);
                packoutItems.add(packoutItem);
                ++i;
            }
        }
        MUser user = MUser.get((Properties)Env.getCtx());
        PackoutDocument packoutDocument = new PackoutDocument(tableName, "1.0.0", Adempiere.getVersion(), Adempiere.DB_VERSION, "", "", user.getName(), user.getEMail(), new Date(), new Date());
        if (file == null) {
            try {
                file = File.createTempFile(String.valueOf(tableName) + "_", ".zip");
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        try {
            packOut.export(this.getPackoutDirectory(), file != null ? file.getAbsolutePath() : null, packoutDocument, packoutItems, null);
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
    }

    private String getPackoutDirectory() {
        boolean success;
        String packageDirectory = Adempiere.getAdempiereHome();
        String result = String.valueOf(packageDirectory) + File.separator + "packages";
        File docDir = new File(String.valueOf(result) + File.separator + "doc");
        if (!docDir.exists() && !(success = docDir.mkdirs())) {
            logger.info("Target directory creation failed");
        }
        return String.valueOf(result) + File.separator;
    }

    public String getFileExtension() {
        return "zip";
    }

    public String getFileExtensionLabel() {
        return Msg.getMsg((Properties)Env.getCtx(), (String)"File2PackZip");
    }

    public String getContentType() {
        return "application/zip";
    }

    public String getSuggestedFileName(GridTab gridTab) {
        return String.valueOf(gridTab.getName()) + "." + this.getFileExtension();
    }

    public boolean isExportableTab(GridTab gridTab) {
        return !gridTab.getTableName().toLowerCase().endsWith("_trl");
    }
}

