/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.parser;

import com.itextpdf.awt.geom.Point2D;
import com.itextpdf.text.pdf.parser.BezierCurve;
import com.itextpdf.text.pdf.parser.Line;
import com.itextpdf.text.pdf.parser.Subpath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Path {
    private static final String START_PATH_ERR_MSG = "Path shall start with \"re\" or \"m\" operator";
    private List<Subpath> subpaths = new ArrayList<Subpath>();
    private Point2D currentPoint;

    public Path() {
    }

    public Path(List<? extends Subpath> subpaths) {
        this.addSubpaths(subpaths);
    }

    public List<Subpath> getSubpaths() {
        return this.subpaths;
    }

    public void addSubpath(Subpath subpath) {
        this.subpaths.add(subpath);
        this.currentPoint = subpath.getLastPoint();
    }

    public void addSubpaths(List<? extends Subpath> subpaths) {
        if (subpaths.size() > 0) {
            this.subpaths.addAll(subpaths);
            this.currentPoint = this.subpaths.get(subpaths.size() - 1).getLastPoint();
        }
    }

    public Point2D getCurrentPoint() {
        return this.currentPoint;
    }

    public void moveTo(float x, float y) {
        this.currentPoint = new Point2D.Float(x, y);
        Subpath lastSubpath = this.getLastSubpath();
        if (lastSubpath != null && lastSubpath.isSinglePointOpen()) {
            lastSubpath.setStartPoint(this.currentPoint);
        } else {
            this.subpaths.add(new Subpath(this.currentPoint));
        }
    }

    public void lineTo(float x, float y) {
        if (this.currentPoint == null) {
            throw new RuntimeException(START_PATH_ERR_MSG);
        }
        Point2D.Float targetPoint = new Point2D.Float(x, y);
        this.getLastSubpath().addSegment(new Line(this.currentPoint, targetPoint));
        this.currentPoint = targetPoint;
    }

    public void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        if (this.currentPoint == null) {
            throw new RuntimeException(START_PATH_ERR_MSG);
        }
        Point2D.Float secondPoint = new Point2D.Float(x1, y1);
        Point2D.Float thirdPoint = new Point2D.Float(x2, y2);
        Point2D.Float fourthPoint = new Point2D.Float(x3, y3);
        ArrayList<Point2D> controlPoints = new ArrayList<Point2D>(Arrays.asList(this.currentPoint, secondPoint, thirdPoint, fourthPoint));
        this.getLastSubpath().addSegment(new BezierCurve(controlPoints));
        this.currentPoint = fourthPoint;
    }

    public void curveTo(float x2, float y2, float x3, float y3) {
        if (this.currentPoint == null) {
            throw new RuntimeException(START_PATH_ERR_MSG);
        }
        this.curveTo((float)this.currentPoint.getX(), (float)this.currentPoint.getY(), x2, y2, x3, y3);
    }

    public void curveFromTo(float x1, float y1, float x3, float y3) {
        if (this.currentPoint == null) {
            throw new RuntimeException(START_PATH_ERR_MSG);
        }
        this.curveTo(x1, y1, x3, y3, x3, y3);
    }

    public void rectangle(float x, float y, float w, float h) {
        this.moveTo(x, y);
        this.lineTo(x + w, y);
        this.lineTo(x + w, y + h);
        this.lineTo(x, y + h);
        this.closeSubpath();
    }

    public void closeSubpath() {
        Subpath lastSubpath = this.getLastSubpath();
        lastSubpath.setClosed(true);
        Point2D startPoint = lastSubpath.getStartPoint();
        this.moveTo((float)startPoint.getX(), (float)startPoint.getY());
    }

    public void closeAllSubpaths() {
        for (Subpath subpath : this.subpaths) {
            subpath.setClosed(true);
        }
    }

    public List<Integer> replaceCloseWithLine() {
        ArrayList<Integer> modifiedSubpathsIndices = new ArrayList<Integer>();
        int i = 0;
        for (Subpath subpath : this.subpaths) {
            if (subpath.isClosed()) {
                subpath.setClosed(false);
                subpath.addSegment(new Line(subpath.getLastPoint(), subpath.getStartPoint()));
                modifiedSubpathsIndices.add(i);
            }
            ++i;
        }
        return modifiedSubpathsIndices;
    }

    public boolean isEmpty() {
        return this.subpaths.size() == 0;
    }

    private Subpath getLastSubpath() {
        return this.subpaths.size() > 0 ? this.subpaths.get(this.subpaths.size() - 1) : null;
    }
}

