/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.mapping.loader;

import org.exolab.castor.mapping.CollectionHandler;
import org.exolab.castor.mapping.TypeConvertor;
import org.exolab.castor.mapping.loader.CollectionHandlers;
import org.exolab.castor.mapping.loader.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeInfo<T> {
    private Class<T> fieldType;
    private TypeConvertor convertorTo;
    private TypeConvertor convertorFrom;
    private boolean immutable = false;
    private boolean required = false;
    private Object _default;
    private CollectionHandler<T> _colHandler;

    public TypeInfo(Class<T> fieldType) {
        this(fieldType, null, null, false, null, null, true);
    }

    public TypeInfo(Class<T> fieldType, TypeConvertor convertorTo, TypeConvertor convertorFrom, boolean required, Object defaultValue, CollectionHandler<T> colHandler) {
        this(fieldType, convertorTo, convertorFrom, required, defaultValue, colHandler, true);
    }

    public TypeInfo(Class<T> fieldType, TypeConvertor convertorTo, TypeConvertor convertorFrom, boolean required, Object defaultValue, CollectionHandler<T> colHandler, boolean checkForCollection) {
        if (colHandler == null && checkForCollection) {
            if (fieldType.isArray()) {
                if (fieldType.getComponentType() != Byte.TYPE) {
                    try {
                        colHandler = CollectionHandlers.getHandler(Object[].class);
                    }
                    catch (Exception e) {
                        throw new NullPointerException("Impossible to locate CollectionHandler for array.");
                    }
                }
            } else {
                try {
                    colHandler = CollectionHandlers.getHandler(fieldType);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        this.setFieldType(fieldType);
        this.setConvertorTo(convertorTo);
        this.setConvertorFrom(convertorFrom);
        this.setImmutable(Types.isImmutable(fieldType));
        this.setRequired(required);
        this.setDefault(defaultValue == null ? Types.getDefault(fieldType) : defaultValue);
        this.setColHandler(colHandler);
    }

    public Class<?> getFieldType() {
        return this.fieldType;
    }

    public TypeConvertor getConvertorTo() {
        return this.convertorTo;
    }

    public TypeConvertor getConvertorFrom() {
        return this.convertorFrom;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public boolean isRequired() {
        return this.required;
    }

    public Object getDefaultValue() {
        return this.getDefault();
    }

    public CollectionHandler<T> getCollectionHandler() {
        return this.getColHandler();
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public void setCollectionHandler(CollectionHandler<T> handler) {
        this.setColHandler(handler);
    }

    void setImmutable(boolean immutable) {
        this.immutable = immutable;
    }

    private void setFieldType(Class<T> fieldType) {
        this.fieldType = fieldType;
    }

    private void setConvertorTo(TypeConvertor convertorTo) {
        this.convertorTo = convertorTo;
    }

    private void setConvertorFrom(TypeConvertor convertorFrom) {
        this.convertorFrom = convertorFrom;
    }

    private void setDefault(Object _default) {
        this._default = _default;
    }

    private Object getDefault() {
        return this._default;
    }

    private void setColHandler(CollectionHandler<T> colHandler) {
        this._colHandler = colHandler;
    }

    private CollectionHandler<T> getColHandler() {
        return this._colHandler;
    }
}

