/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkplus.databind;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.zkoss.lang.Objects;
import org.zkoss.zkplus.databind.BindingListModel;
import org.zkoss.zkplus.databind.BindingListModelExt;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.event.ListDataListener;
import org.zkoss.zul.ext.Selectable;
import org.zkoss.zul.ext.SelectionControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingListModelListModel<E>
implements BindingListModel<E>,
Selectable<E>,
Serializable,
BindingListModelExt<E> {
    private static final long serialVersionUID = -4454049848612772393L;
    protected ListModel<E> _model;
    private Selectable<E> _selectable;
    private boolean distinct = true;

    public BindingListModelListModel(ListModel<E> model) {
        this._model = model;
    }

    public BindingListModelListModel(ListModel<E> model, boolean distinct) {
        this._model = model;
        this.distinct = distinct;
        if (model instanceof Set || model instanceof Map) {
            distinct = true;
        }
    }

    @Override
    public int indexOf(Object obj) {
        int j = this.getSize();
        while (j-- > 0) {
            if (!Objects.equals(this.getElementAt(j), (Object)obj)) continue;
            return j;
        }
        return -1;
    }

    public E getElementAt(int index) {
        return (E)this._model.getElementAt(index);
    }

    public int getSize() {
        return this._model.getSize();
    }

    public void addListDataListener(ListDataListener l) {
        this._model.addListDataListener(l);
    }

    public void removeListDataListener(ListDataListener l) {
        this._model.removeListDataListener(l);
    }

    public ListModel<E> getInnerModel() {
        return this._model;
    }

    private Selectable<E> getSelectModel() {
        if (this._model instanceof Selectable) {
            return (Selectable)this._model;
        }
        if (this._selectable == null) {
            this._selectable = new EmptySelectable();
        }
        return this._selectable;
    }

    public void setSelectionControl(SelectionControl ctrl) {
        this.getSelectModel().setSelectionControl(ctrl);
    }

    public SelectionControl getSelectionControl() {
        return this.getSelectModel().getSelectionControl();
    }

    public Set<E> getSelection() {
        return this.getSelectModel().getSelection();
    }

    public void setSelection(Collection<? extends E> selection) {
        this.getSelectModel().setSelection(selection);
    }

    public boolean isSelected(Object obj) {
        return this.getSelectModel().isSelected(obj);
    }

    public boolean isSelectionEmpty() {
        return this.getSelectModel().isSelectionEmpty();
    }

    public boolean addToSelection(E obj) {
        return this.getSelectModel().addToSelection(obj);
    }

    public boolean removeFromSelection(Object obj) {
        return this.getSelectModel().removeFromSelection(obj);
    }

    public void clearSelection() {
        this.getSelectModel().clearSelection();
    }

    public void setMultiple(boolean multiple) {
        this.getSelectModel().setMultiple(multiple);
    }

    public boolean isMultiple() {
        return this.getSelectModel().isMultiple();
    }

    @Override
    public int[] indexesOf(Object elm) {
        if (this.isDistinct()) {
            int[] nArray;
            int idx = this.indexOf(elm);
            if (idx < 0) {
                nArray = new int[]{};
            } else {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = idx;
            }
            return nArray;
        }
        LinkedList<Integer> indexes = new LinkedList<Integer>();
        int ind = this.getSize();
        while (ind-- > 0) {
            if (!Objects.equals((Object)elm, this.getElementAt(ind))) continue;
            indexes.add(ind);
        }
        int j = 0;
        int[] result = new int[indexes.size()];
        j = 0;
        Iterator it = indexes.iterator();
        while (it.hasNext()) {
            int idx;
            result[j] = idx = ((Integer)it.next()).intValue();
            ++j;
        }
        return result;
    }

    @Override
    public boolean isDistinct() {
        return this.distinct;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptySelectable<E>
    implements Selectable<E>,
    Serializable {
        private static final long serialVersionUID = 7942486785062723611L;
        private SelectionControl<E> _ctrl;

        private EmptySelectable() {
        }

        public void setSelectionControl(SelectionControl ctrl) {
            this._ctrl = ctrl;
        }

        public SelectionControl getSelectionControl() {
            return this._ctrl;
        }

        public Set<E> getSelection() {
            return null;
        }

        public void setSelection(Collection<? extends E> selection) {
        }

        public boolean isSelected(Object obj) {
            return false;
        }

        public boolean isSelectionEmpty() {
            return false;
        }

        public boolean addToSelection(E obj) {
            return false;
        }

        public boolean removeFromSelection(Object obj) {
            return false;
        }

        public void clearSelection() {
        }

        public void setMultiple(boolean multiple) {
        }

        public boolean isMultiple() {
            return false;
        }
    }
}

