/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.install;

import java.io.File;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.install.Config;
import org.compiere.install.ConfigurationData;
import org.compiere.util.CLogMgt;

public class ConfigVM
extends Config {
    public ConfigVM(ConfigurationData data) {
        super(data);
    }

    @Override
    public void init() {
        String javaHome = System.getProperty("java.home");
        log.fine(javaHome);
        if (javaHome.endsWith("jre")) {
            javaHome = javaHome.substring(0, javaHome.length() - 4);
        }
        this.p_data.setJavaHome(javaHome);
    }

    @Override
    public String test() {
        File javaHome = new File(this.p_data.getJavaHome());
        boolean pass = javaHome.exists();
        String error = "Not found: Java Home";
        if (this.getPanel() != null) {
            this.signalOK(this.getPanel().okJavaHome, "ErrorJavaHome", pass, true, error);
        }
        if (!pass) {
            return error;
        }
        if (CLogMgt.isLevelFinest()) {
            CLogMgt.printProperties((Properties)System.getProperties(), (String)"System", (boolean)true);
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("OK: JavaHome=" + javaHome.getAbsolutePath());
        }
        this.setProperty("JAVA_HOME", javaHome.getAbsolutePath());
        System.setProperty("JAVA_HOME", javaHome.getAbsolutePath());
        String[] versions = new String[]{"1.7.0", "1.8.0"};
        pass = false;
        String thisJV = System.getProperty("java.version");
        String[] stringArray = versions;
        int n = versions.length;
        int n2 = 0;
        while (n2 < n) {
            String version = stringArray[n2];
            boolean bl = pass = thisJV.indexOf(version) != -1;
            if (pass) {
                if (!log.isLoggable(Level.INFO)) break;
                log.info("OK: Version=" + thisJV);
                break;
            }
            ++n2;
        }
        error = "Wrong Java Version: Should be " + versions[0] + " and above.";
        if (this.getPanel() != null) {
            this.signalOK(this.getPanel().okJavaHome, "ErrorJavaHome", pass, true, error);
        }
        if (!pass) {
            return error;
        }
        return null;
    }
}

