/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.process;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MJournalBatch;
import org.compiere.model.MOrder;
import org.compiere.model.MRecurring;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.DocAction;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;

public class RecurringRun
extends SvrProcess {
    private int p_C_RecurringGroup_ID = 0;
    private Timestamp p_Cut_Date = null;
    private String p_DocAction = null;
    ArrayList<ValueNamePair> prms = new ArrayList();

    protected void prepare() {
        ProcessInfoParameter[] processInfoParameterArray = this.getParameter();
        int n = processInfoParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessInfoParameter para = processInfoParameterArray[n2];
            String name = para.getParameterName();
            if ("C_RecurringGroup_ID".equals(name)) {
                this.p_C_RecurringGroup_ID = para.getParameterAsInt();
            } else if ("Cut_Date".equals(name)) {
                this.p_Cut_Date = para.getParameterAsTimestamp();
            } else if ("DocAction".equals(name)) {
                this.p_DocAction = para.getParameterAsString();
            } else if (name.startsWith("Prm_")) {
                String prm = para.getParameterAsString();
                if (!Util.isEmpty((String)prm, (boolean)true)) {
                    this.prms.add(new ValueNamePair(name, prm));
                }
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++n2;
        }
    }

    protected String doIt() throws Exception {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("C_RecurringGroup_ID=" + this.p_C_RecurringGroup_ID + ", Cut_Date=" + this.p_Cut_Date + ", DocAction=" + this.p_DocAction);
        }
        ArrayList<Comparable<Integer>> parameters = new ArrayList<Comparable<Integer>>();
        StringBuffer whereClause = new StringBuffer("RunsMax>(SELECT COUNT(*) FROM C_Recurring_Run WHERE C_Recurring_Run.C_Recurring_ID=C_Recurring.C_Recurring_ID)");
        if (this.p_C_RecurringGroup_ID > 0) {
            whereClause.append(" AND C_RecurringGroup_ID=?");
            parameters.add(Integer.valueOf(this.p_C_RecurringGroup_ID));
        }
        if (this.p_Cut_Date != null) {
            whereClause.append(" AND DateNextRun<=?");
            parameters.add(this.p_Cut_Date);
        }
        List recs = new Query(this.getCtx(), "C_Recurring", whereClause.toString(), this.get_TrxName()).setOnlyActiveRecords(true).setClient_ID().setParameters(parameters).setOrderBy("Name, C_Recurring_ID").list();
        int cnt = 0;
        for (MRecurring rec : recs) {
            int n;
            int n2;
            MInvoiceLine[] mInvoiceLineArray;
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info(rec.toString());
            }
            int percent = cnt * 100 / recs.size();
            this.statusUpdate(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Processing")) + percent + "% - " + rec.toString());
            Timestamp currdate = rec.getDateNextRun();
            String msg = rec.executeRun();
            PO po = rec.getLastPO();
            if (po == null) continue;
            this.replaceTagsInDescription(po);
            MInvoiceLine[] polines = null;
            if (po instanceof MInvoice) {
                polines = ((MInvoice)po).getLines();
            } else if (po instanceof MOrder) {
                polines = ((MOrder)po).getLines();
            }
            if (polines != null) {
                mInvoiceLineArray = polines;
                n2 = polines.length;
                n = 0;
                while (n < n2) {
                    MInvoiceLine poline = mInvoiceLineArray[n];
                    this.replaceTagsInDescription((PO)poline);
                    ++n;
                }
            }
            if (po instanceof MJournalBatch) {
                mInvoiceLineArray = ((MJournalBatch)po).getJournals(false);
                n2 = mInvoiceLineArray.length;
                n = 0;
                while (n < n2) {
                    MInvoiceLine journal = mInvoiceLineArray[n];
                    polines = journal.getLines(false);
                    if (polines != null) {
                        MInvoiceLine[] mInvoiceLineArray2 = polines;
                        int n3 = polines.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            MInvoiceLine poline = mInvoiceLineArray2[n4];
                            this.replaceTagsInDescription((PO)poline);
                            ++n4;
                        }
                    }
                    ++n;
                }
            }
            if (this.p_DocAction != null && po instanceof DocAction) {
                if (!((DocAction)po).processIt(this.p_DocAction)) {
                    this.log.warning("completePO - failed: " + po);
                    throw new IllegalStateException("PO Process Failed: " + po + " - " + ((DocAction)po).getProcessMsg());
                }
                po.saveEx();
            }
            msg = Msg.parseTranslation((Properties)this.getCtx(), (String)msg);
            this.addBufferLog(po.get_ID(), currdate, null, msg, po.get_Table_ID(), po.get_ID());
        }
        return "@OK@";
    }

    private void replaceTagsInDescription(PO po) {
        if (po.get_ColumnIndex("Description") >= 0) {
            String description;
            String description_org = description = po.get_ValueAsString("Description");
            description = Env.parseVariable((String)description, (PO)po, (String)this.get_TrxName(), (boolean)true);
            if (this.prms.size() > 0) {
                for (ValueNamePair prm : this.prms) {
                    String prmName = prm.getValue();
                    String prmValue = prm.getName();
                    String tag = "@" + prmName + "@";
                    description = description.replaceAll(tag, prmValue);
                }
            }
            if (description_org != null && !description_org.equals(description)) {
                po.set_ValueOfColumn("Description", (Object)description);
                po.saveEx();
            }
        }
    }
}

