/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.compiere.Adempiere;
import org.compiere.model.MRole;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class RoleAccessUpdate
extends SvrProcess {
    private static CLogger s_log = CLogger.getCLogger(RoleAccessUpdate.class);
    private int p_AD_Role_ID = -1;
    private int p_AD_Client_ID = -1;
    private boolean p_IsReset = true;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("AD_Role_ID")) {
                    this.p_AD_Role_ID = para[i].getParameterAsInt();
                } else if (name.equals("AD_Client_ID")) {
                    this.p_AD_Client_ID = para[i].getParameterAsInt();
                } else if (name.equals("ResetAccess")) {
                    this.p_IsReset = "Y".equals(para[i].getParameter());
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("AD_Client_ID=" + this.p_AD_Client_ID + ", AD_Role_ID=" + this.p_AD_Role_ID);
        }
        if (this.p_AD_Role_ID > 0) {
            this.updateRole(new MRole(this.getCtx(), this.p_AD_Role_ID, this.get_TrxName()));
        } else {
            ArrayList<Integer> params = new ArrayList<Integer>();
            StringBuilder whereClause = new StringBuilder("1=1");
            if (this.p_AD_Client_ID > 0) {
                whereClause.append(" AND AD_Client_ID=? ");
                params.add(this.p_AD_Client_ID);
            }
            if (this.p_AD_Role_ID == 0) {
                whereClause.append(" AND AD_Role_ID=?");
                params.add(this.p_AD_Role_ID);
            }
            List roles = new Query(this.getCtx(), "AD_Role", whereClause.toString(), this.get_TrxName()).setOnlyActiveRecords(true).setParameters(params).setOrderBy("AD_Client_ID, Name").list();
            for (MRole role : roles) {
                this.updateRole(role);
            }
        }
        return "";
    }

    private void updateRole(MRole role) {
        StringBuilder msglog = new StringBuilder(role.getName()).append(": ").append(role.updateAccessRecords(this.p_IsReset));
        this.addLog(0, null, null, msglog.toString());
    }

    public static void main(String[] args) {
        Adempiere.startupEnvironment((boolean)false);
        CLogMgt.setLevel((Level)Level.FINE);
        s_log.info("Role Access Update");
        s_log.info("------------------");
        ProcessInfo pi = new ProcessInfo("Role Access Update", 295);
        pi.setAD_Client_ID(0);
        pi.setAD_User_ID(100);
        RoleAccessUpdate rau = new RoleAccessUpdate();
        rau.startProcess(Env.getCtx(), pi, null);
        StringBuilder msgout = new StringBuilder("Process=").append(pi.getTitle()).append(" Error=").append(pi.isError()).append(" Summary=").append(pi.getSummary());
        System.out.println(msgout.toString());
    }
}

