/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MDocType;
import org.compiere.model.MOrder;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;

public class CopyOrder
extends SvrProcess {
    private int p_C_Order_ID = 0;
    private int p_C_DocType_ID = 0;
    private Timestamp p_DateDoc = null;
    private boolean p_IsCloseDocument = false;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("C_Order_ID")) {
                    this.p_C_Order_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("C_DocType_ID")) {
                    this.p_C_DocType_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("DateDoc")) {
                    this.p_DateDoc = (Timestamp)para[i].getParameter();
                } else if (name.equals("IsCloseDocument")) {
                    this.p_IsCloseDocument = "Y".equals(para[i].getParameter());
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("C_Order_ID=" + this.p_C_Order_ID + ", C_DocType_ID=" + this.p_C_DocType_ID + ", CloseDocument=" + this.p_IsCloseDocument);
        }
        if (this.p_C_Order_ID == 0) {
            throw new IllegalArgumentException("No Order");
        }
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.p_C_DocType_ID);
        if (dt.get_ID() == 0) {
            throw new IllegalArgumentException("No DocType");
        }
        if (this.p_DateDoc == null) {
            this.p_DateDoc = new Timestamp(System.currentTimeMillis());
        }
        MOrder from = new MOrder(this.getCtx(), this.p_C_Order_ID, this.get_TrxName());
        MOrder newOrder = MOrder.copyFrom((MOrder)from, (Timestamp)this.p_DateDoc, (int)dt.getC_DocType_ID(), (boolean)dt.isSOTrx(), (boolean)false, (boolean)true, (String)this.get_TrxName());
        newOrder.setC_DocTypeTarget_ID(this.p_C_DocType_ID);
        newOrder.setQuotationOrder_ID(from.getC_Order_ID());
        boolean OK = newOrder.save();
        if (!OK) {
            throw new IllegalStateException("Could not create new Order");
        }
        if (this.p_IsCloseDocument) {
            MOrder original = new MOrder(this.getCtx(), this.p_C_Order_ID, this.get_TrxName());
            original.setDocAction("CO");
            if (!original.processIt("CO")) {
                this.log.warning("Order Process Failed: " + original.getDocumentNo() + " " + original.getProcessMsg());
                throw new IllegalStateException("Order Process Failed: " + original.getDocumentNo() + " " + original.getProcessMsg());
            }
            original.saveEx();
            original.setDocAction("CL");
            if (!original.processIt("CL")) {
                this.log.warning("Order Process Failed: " + original.getDocumentNo() + " " + original.getProcessMsg());
                throw new IllegalStateException("Order Process Failed: " + original.getDocumentNo() + " " + original.getProcessMsg());
            }
            original.saveEx();
        }
        StringBuilder msgreturn = new StringBuilder().append(dt.getName()).append(": ").append(newOrder.getDocumentNo());
        this.addLog(0, null, null, msgreturn.toString(), newOrder.get_Table_ID(), newOrder.getC_Order_ID());
        return "@C_Order_ID@ @Created@";
    }
}

