/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.MColumn;
import org.compiere.model.MTable;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.ValueNamePair;

public class ColumnSync
extends SvrProcess {
    private int p_AD_Column_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
        this.p_AD_Column_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        String string;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("C_Column_ID=" + this.p_AD_Column_ID);
        }
        if (this.p_AD_Column_ID == 0) {
            throw new AdempiereUserError("@No@ @AD_Column_ID@");
        }
        MColumn column = new MColumn(this.getCtx(), this.p_AD_Column_ID, this.get_TrxName());
        if (column.get_ID() == 0) {
            throw new AdempiereUserError("@NotFound@ @AD_Column_ID@ " + this.p_AD_Column_ID);
        }
        MTable table = new MTable(this.getCtx(), column.getAD_Table_ID(), this.get_TrxName());
        if (table.get_ID() == 0) {
            throw new AdempiereUserError("@NotFound@ @AD_Table_ID@ " + column.getAD_Table_ID());
        }
        Connection conn = null;
        ResultSet rs = null;
        try {
            boolean isNoTable;
            conn = DB.getConnectionRO();
            DatabaseMetaData md = conn.getMetaData();
            String catalog = DB.getDatabase().getCatalog();
            String schema = DB.getDatabase().getSchema();
            String tableName = table.getTableName();
            if (md.storesUpperCaseIdentifiers()) {
                tableName = tableName.toUpperCase();
            } else if (md.storesLowerCaseIdentifiers()) {
                tableName = tableName.toLowerCase();
            }
            int noColumns = 0;
            String sql = null;
            rs = md.getColumns(catalog, schema, tableName, null);
            while (rs.next()) {
                ++noColumns;
                String columnName = rs.getString("COLUMN_NAME");
                if (!columnName.equalsIgnoreCase(column.getColumnName())) continue;
                boolean notNull = rs.getInt("NULLABLE") == 0;
                sql = column.getSQLModify(table, column.isMandatory() ^ notNull);
                break;
            }
            DB.close((ResultSet)rs);
            rs = null;
            boolean bl = isNoTable = noColumns == 0;
            if (isNoTable) {
                sql = table.getSQLCreate();
            } else if (sql == null) {
                sql = column.getSQLAdd(table);
            }
            if (isNoTable) {
                MColumn[] cols;
                MColumn[] mColumnArray = cols = table.getColumns(false);
                int n = cols.length;
                int n2 = 0;
                while (n2 < n) {
                    MColumn col = mColumnArray[n2];
                    String fkConstraintSql = MColumn.getForeignKeyConstraintSql((DatabaseMetaData)md, (String)catalog, (String)schema, (String)tableName, (MTable)table, (MColumn)col, (boolean)false);
                    if (fkConstraintSql != null && fkConstraintSql.length() > 0) {
                        sql = String.valueOf(sql) + fkConstraintSql;
                    }
                    ++n2;
                }
            } else {
                String fkConstraintSql = MColumn.getForeignKeyConstraintSql((DatabaseMetaData)md, (String)catalog, (String)schema, (String)tableName, (MTable)table, (MColumn)column, (boolean)false);
                if (fkConstraintSql != null && fkConstraintSql.length() > 0) {
                    sql = String.valueOf(sql) + fkConstraintSql;
                }
            }
            int no = 0;
            if (sql.indexOf("; ") == -1) {
                no = DB.executeUpdate((String)sql, (boolean)false, (String)this.get_TrxName());
                this.addLog(0, null, new BigDecimal(no), sql);
            } else {
                String[] statements = sql.split("; ");
                int i = 0;
                while (i < statements.length) {
                    int count = DB.executeUpdateEx((String)statements[i], (String)this.get_TrxName());
                    this.addLog(0, null, new BigDecimal(count), statements[i]);
                    no += count;
                    ++i;
                }
            }
            if (no == -1) {
                StringBuilder msg = new StringBuilder("@Error@ ");
                ValueNamePair pp = CLogger.retrieveError();
                if (pp != null) {
                    msg = new StringBuilder(pp.getName()).append(" - ");
                }
                msg.append(sql);
                throw new AdempiereUserError(msg.toString());
            }
            string = sql;
        }
        catch (Throwable throwable) {
            DB.close(rs);
            rs = null;
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw throwable;
        }
        DB.close((ResultSet)rs);
        rs = null;
        if (conn != null) {
            try {
                conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }
}

