/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MBOM;
import org.compiere.model.MBOMProduct;
import org.compiere.model.MProduct;
import org.compiere.model.MProductBOM;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class BOMValidate
extends SvrProcess {
    private int p_M_Product_ID = 0;
    private int p_M_Product_Category_ID = 0;
    private boolean p_IsReValidate = false;
    private MProduct m_product = null;
    private ArrayList<MProduct> m_products = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("M_Product_Category_ID")) {
                    this.p_M_Product_Category_ID = para[i].getParameterAsInt();
                } else if (name.equals("IsReValidate")) {
                    this.p_IsReValidate = "Y".equals(para[i].getParameter());
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.p_M_Product_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        int counter;
        block12: {
            if (this.p_M_Product_ID != 0) {
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info("M_Product_ID=" + this.p_M_Product_ID);
                }
                return this.validateProduct(new MProduct(this.getCtx(), this.p_M_Product_ID, this.get_TrxName()));
            }
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("M_Product_Category_ID=" + this.p_M_Product_Category_ID + ", IsReValidate=" + this.p_IsReValidate);
            }
            counter = 0;
            CPreparedStatement pstmt = null;
            String sql = "SELECT * FROM M_Product WHERE IsBOM='Y' AND ";
            sql = this.p_M_Product_Category_ID == 0 ? String.valueOf(sql) + "AD_Client_ID=? " : String.valueOf(sql) + "M_Product_Category_ID=? ";
            if (!this.p_IsReValidate) {
                sql = String.valueOf(sql) + "AND IsVerified<>'Y' ";
            }
            sql = String.valueOf(sql) + "ORDER BY Name";
            int AD_Client_ID = Env.getAD_Client_ID((Properties)this.getCtx());
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                    if (this.p_M_Product_Category_ID == 0) {
                        pstmt.setInt(1, AD_Client_ID);
                    } else {
                        pstmt.setInt(1, this.p_M_Product_Category_ID);
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        String info = this.validateProduct(new MProduct(this.getCtx(), rs.getInt("M_Product_ID"), this.get_TrxName()));
                        this.addBufferLog(0, null, null, info, 208, rs.getInt("M_Product_ID"));
                        ++counter;
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block12;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return "#" + counter;
    }

    private String validateProduct(MProduct product) {
        if (!product.isBOM()) {
            return String.valueOf(product.getName()) + " @NotValid@ @M_BOM_ID@";
        }
        this.m_product = product;
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config(this.m_product.getName());
        }
        this.m_products = new ArrayList();
        if (!this.validateOldProduct(this.m_product)) {
            this.m_product.setIsVerified(false);
            this.m_product.saveEx();
            return String.valueOf(this.m_product.getName()) + " @NotValid@";
        }
        MBOM[] boms = MBOM.getOfProduct((Properties)this.getCtx(), (int)this.p_M_Product_ID, (String)this.get_TrxName(), null);
        int i = 0;
        while (i < boms.length) {
            this.m_products = new ArrayList();
            if (!this.validateBOM(boms[i])) {
                this.m_product.setIsVerified(false);
                this.m_product.saveEx();
                return String.valueOf(this.m_product.getName()) + " " + boms[i].getName() + " @NotValid@";
            }
            ++i;
        }
        this.m_product.setIsVerified(true);
        this.m_product.saveEx();
        return String.valueOf(this.m_product.getName()) + " @IsValid@";
    }

    private boolean validateOldProduct(MProduct product) {
        if (!product.isBOM()) {
            return true;
        }
        if (this.m_products.contains(product)) {
            this.log.warning(String.valueOf(this.m_product.getName()) + " recursively includes " + product.getName());
            return false;
        }
        this.m_products.add(product);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(product.getName());
        }
        MProductBOM[] productsBOMs = MProductBOM.getBOMLines((MProduct)product);
        int i = 0;
        while (i < productsBOMs.length) {
            MProductBOM productsBOM = productsBOMs[i];
            MProduct pp = new MProduct(this.getCtx(), productsBOM.getM_ProductBOM_ID(), this.get_TrxName());
            if (!pp.isBOM()) {
                if (this.log.isLoggable(Level.FINER)) {
                    this.log.finer(pp.getName());
                }
            } else if (!this.validateOldProduct(pp)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean validateBOM(MBOM bom) {
        MBOMProduct[] BOMproducts = MBOMProduct.getOfBOM((MBOM)bom);
        int i = 0;
        while (i < BOMproducts.length) {
            MBOMProduct BOMproduct = BOMproducts[i];
            MProduct pp = new MProduct(this.getCtx(), BOMproduct.getM_BOMProduct_ID(), this.get_TrxName());
            if (pp.isBOM()) {
                return this.validateProduct(pp, bom.getBOMType(), bom.getBOMUse());
            }
            ++i;
        }
        return true;
    }

    private boolean validateProduct(MProduct product, String BOMType, String BOMUse) {
        if (!product.isBOM()) {
            return true;
        }
        String restriction = "BOMType='" + BOMType + "' AND BOMUse='" + BOMUse + "'";
        MBOM[] boms = MBOM.getOfProduct((Properties)this.getCtx(), (int)this.p_M_Product_ID, (String)this.get_TrxName(), (String)restriction);
        if (boms.length != 1) {
            this.log.warning(String.valueOf(restriction) + " - Length=" + boms.length);
            return false;
        }
        if (this.m_products.contains(product)) {
            this.log.warning(String.valueOf(this.m_product.getName()) + " recursively includes " + product.getName());
            return false;
        }
        this.m_products.add(product);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(product.getName());
        }
        MBOM bom = boms[0];
        MBOMProduct[] BOMproducts = MBOMProduct.getOfBOM((MBOM)bom);
        int i = 0;
        while (i < BOMproducts.length) {
            MBOMProduct BOMproduct = BOMproducts[i];
            MProduct pp = new MProduct(this.getCtx(), BOMproduct.getM_BOMProduct_ID(), this.get_TrxName());
            if (pp.isBOM()) {
                return this.validateProduct(pp, bom.getBOMType(), bom.getBOMUse());
            }
            ++i;
        }
        return true;
    }
}

