/*
 * Decompiled with CFR 0.152.
 */
package jpiere.plugin.simpleinputwindow.panel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import jpiere.plugin.simpleinputwindow.form.JPiereSimpleInputWindow;
import org.adempiere.exceptions.DBException;
import org.adempiere.model.MTabCustomization;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Checkbox;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListHead;
import org.adempiere.webui.component.ListHeader;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.SimpleListModel;
import org.adempiere.webui.factory.ButtonFactory;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.window.FDialog;
import org.compiere.model.MField;
import org.compiere.model.MRefList;
import org.compiere.model.MRole;
import org.compiere.model.MTab;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;
import org.compiere.util.ValueNamePair;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuFocus;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.DropEvent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.Hlayout;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.ListitemRenderer;
import org.zkoss.zul.Separator;
import org.zkoss.zul.South;

public class SimpleInputWindowCustomizeGridViewPanel
extends Panel {
    private static final long serialVersionUID = -6300916636341781651L;
    private Map<Integer, String> m_columnsWidth;
    ArrayList<Integer> tableSeqs;
    JPiereSimpleInputWindow gridPanel = null;
    MTabCustomization m_tabcust;
    static CLogger log = CLogger.getCLogger(SimpleInputWindowCustomizeGridViewPanel.class);
    private int m_WindowNo;
    private int m_AD_Tab_ID;
    private int m_AD_User_ID;
    private Label noLabel = new Label();
    private Label yesLabel = new Label();
    private Button bAdd = ButtonFactory.createButton(null, (String)ThemeManager.getThemeResource((String)"images/MoveRight16.png"), null);
    private Button bRemove = ButtonFactory.createButton(null, (String)ThemeManager.getThemeResource((String)"images/MoveLeft16.png"), null);
    private Button bUp = ButtonFactory.createButton(null, (String)ThemeManager.getThemeResource((String)"images/MoveUp16.png"), null);
    private Button bDown = ButtonFactory.createButton(null, (String)ThemeManager.getThemeResource((String)"images/MoveDown16.png"), null);
    private Checkbox chkSaveWidth = new Checkbox();
    private Label lblGridMode = new Label();
    private Listbox lstGridMode = new Listbox();
    SimpleListModel noModel = new SimpleListModel();
    SimpleListModel yesModel = new SimpleListModel();
    Listbox noList = new Listbox();
    Listbox yesList = new Listbox();
    private boolean uiCreated;
    private boolean m_saved = false;
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);

    public SimpleInputWindowCustomizeGridViewPanel(int WindowNo, int AD_Tab_ID, int AD_User_ID, Map<Integer, String> columnsWidth, ArrayList<Integer> gridFieldIds) {
        this.m_WindowNo = WindowNo;
        this.m_AD_Tab_ID = AD_Tab_ID;
        this.m_AD_User_ID = AD_User_ID;
        this.m_columnsWidth = columnsWidth;
        this.tableSeqs = gridFieldIds;
        this.setStyle("position : relative;height: 100%; width:100%; margin: none; border: none; padding: none;");
    }

    private void init() throws Exception {
        Borderlayout layout = new Borderlayout();
        layout.setStyle("position: absolute; width: 100%; height: 100%; border: none; margin: none; padding: none;");
        Center center = new Center();
        this.noLabel.setValue(Msg.getMsg((Properties)Env.getCtx(), (String)"Available"));
        this.yesLabel.setValue(Msg.getMsg((Properties)Env.getCtx(), (String)"Selected"));
        this.yesList.setVflex(true);
        this.noList.setVflex(true);
        EventListener<Event> mouseListener = new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                if ("onDoubleClick".equals(event.getName())) {
                    SimpleInputWindowCustomizeGridViewPanel.this.migrateValueAcrossLists(event);
                }
            }
        };
        this.yesList.addDoubleClickListener((EventListener)mouseListener);
        this.noList.addDoubleClickListener((EventListener)mouseListener);
        Object actionListener = new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                SimpleInputWindowCustomizeGridViewPanel.this.migrateValueAcrossLists(event);
            }
        };
        this.yesModel.setMultiple(true);
        this.noModel.setMultiple(true);
        LayoutUtils.addSclass((String)"btn-small", (HtmlBasedComponent)this.bAdd);
        LayoutUtils.addSclass((String)"btn-sorttab small-img-btn", (HtmlBasedComponent)this.bAdd);
        this.bAdd.addEventListener("onClick", (EventListener)actionListener);
        LayoutUtils.addSclass((String)"btn-small", (HtmlBasedComponent)this.bRemove);
        LayoutUtils.addSclass((String)"btn-sorttab small-img-btn", (HtmlBasedComponent)this.bRemove);
        this.bRemove.addEventListener("onClick", (EventListener)actionListener);
        DragListener crossListMouseListener = new DragListener();
        this.yesList.addOnDropListener((EventListener)crossListMouseListener);
        this.noList.addOnDropListener((EventListener)crossListMouseListener);
        this.yesList.setItemDraggable(true);
        this.noList.setItemDraggable(true);
        actionListener = new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                SimpleInputWindowCustomizeGridViewPanel.this.migrateValueWithinYesList(event);
            }
        };
        LayoutUtils.addSclass((String)"btn-small", (HtmlBasedComponent)this.bUp);
        LayoutUtils.addSclass((String)"btn-sorttab small-img-btn", (HtmlBasedComponent)this.bUp);
        this.bUp.addEventListener("onClick", (EventListener)actionListener);
        LayoutUtils.addSclass((String)"btn-small", (HtmlBasedComponent)this.bDown);
        LayoutUtils.addSclass((String)"btn-sorttab small-img-btn", (HtmlBasedComponent)this.bDown);
        this.bDown.addEventListener("onClick", (EventListener)actionListener);
        ListHead listHead = new ListHead();
        listHead.setParent((Component)this.yesList);
        ListHeader listHeader = new ListHeader();
        listHeader.appendChild((Component)this.yesLabel);
        Hlayout yesButtonLayout = new Hlayout();
        yesButtonLayout.appendChild((Component)this.bUp);
        yesButtonLayout.appendChild((Component)this.bDown);
        listHeader.appendChild((Component)yesButtonLayout);
        yesButtonLayout.setStyle("display: inline-block; float: right;");
        listHeader.setParent((Component)listHead);
        listHead = new ListHead();
        listHead.setParent((Component)this.noList);
        listHeader = new ListHeader();
        listHeader.appendChild((Component)this.noLabel);
        listHeader.setSort("auto");
        listHeader.setSortDirection("ascending");
        this.noList.setAttribute("org.zkoss.zul.listbox.autoSort", (Object)"true");
        Hlayout noButtonLayout = new Hlayout();
        noButtonLayout.appendChild((Component)this.bRemove);
        noButtonLayout.appendChild((Component)this.bAdd);
        listHeader.appendChild((Component)noButtonLayout);
        noButtonLayout.setStyle("display: inline-block; float: right;");
        listHeader.setParent((Component)listHead);
        Hlayout hlayout = new Hlayout();
        hlayout.setVflex("true");
        hlayout.setHflex("true");
        hlayout.setStyle("margin: auto; margin-top: 2px;");
        this.noList.setHflex("1");
        this.noList.setVflex(true);
        hlayout.appendChild((Component)this.noList);
        this.yesList.setVflex(true);
        this.yesList.setHflex("1");
        hlayout.appendChild((Component)this.yesList);
        center.appendChild((Component)hlayout);
        layout.appendChild((Component)center);
        South south = new South();
        south.setStyle("border: none; margin: 0; padding: 0; ");
        Panel southPanel = new Panel();
        Separator sep = new Separator();
        sep.setSpacing("2px");
        southPanel.appendChild((Component)sep);
        southPanel.appendChild((Component)this.chkSaveWidth);
        this.chkSaveWidth.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"SaveColumnWidth"));
        sep = new Separator("vertical");
        sep.setSpacing("200px");
        southPanel.appendChild((Component)sep);
        this.lblGridMode.setValue(Msg.getMsg((Properties)Env.getCtx(), (String)"OpenInGridMode"));
        southPanel.appendChild((Component)this.lblGridMode);
        this.lstGridMode.setMold("select");
        this.lstGridMode.setStyle("margin-left: 2px");
        southPanel.appendChild((Component)this.lstGridMode);
        sep = new Separator();
        sep.setSpacing("2px");
        southPanel.appendChild((Component)sep);
        LayoutUtils.addSclass((String)"dialog-footer", (HtmlBasedComponent)this.confirmPanel);
        EventListener<Event> onClickListener = new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                if (event.getTarget().equals(SimpleInputWindowCustomizeGridViewPanel.this.confirmPanel.getButton("Ok"))) {
                    SimpleInputWindowCustomizeGridViewPanel.this.saveData();
                } else if (event.getTarget().equals(SimpleInputWindowCustomizeGridViewPanel.this.confirmPanel.getButton("Cancel"))) {
                    SimpleInputWindowCustomizeGridViewPanel.this.getParent().detach();
                }
            }
        };
        this.confirmPanel.addActionListener((EventListener)onClickListener);
        southPanel.appendChild((Component)this.confirmPanel);
        south.appendChild((Component)southPanel);
        layout.appendChild((Component)south);
        this.appendChild((Component)layout);
    }

    public void loadData() {
        this.m_tabcust = MTabCustomization.get((Properties)Env.getCtx(), (int)this.m_AD_User_ID, (int)this.m_AD_Tab_ID, null);
        this.yesModel.removeAllElements();
        this.noModel.removeAllElements();
        boolean baseLanguage = Env.isBaseLanguage((Properties)Env.getCtx(), (String)"AD_Field");
        Query query = null;
        query = new Query(Env.getCtx(), "AD_Field", "AD_Tab_ID=? AND (IsDisplayed='Y' OR IsDisplayedGrid='Y') AND IsActive='Y'", null);
        query.setOrderBy("SeqNoGrid, Name, SeqNo");
        query.setParameters(new Object[]{this.m_AD_Tab_ID});
        query.setApplyAccessFilter(true);
        try {
            List lsFieldsOfGrid = query.list();
            HashMap<Integer, ListElement> curTabSel = new HashMap<Integer, ListElement>();
            MTab tab = new MTab(Env.getCtx(), this.m_AD_Tab_ID, null);
            for (MField field : lsFieldsOfGrid) {
                if (!MRole.getDefault((Properties)Env.getCtx(), (boolean)false).isColumnAccess(tab.getAD_Table_ID(), field.getAD_Column_ID(), true)) continue;
                int key = field.get_ID();
                String name = null;
                name = baseLanguage ? field.getName() : field.get_Translation("Name");
                ListElement pp = new ListElement(key, name);
                if (this.tableSeqs != null && this.tableSeqs.size() > 0) {
                    if (this.tableSeqs.contains(key)) {
                        curTabSel.put(key, pp);
                        continue;
                    }
                    this.noModel.addElement((Object)pp);
                    continue;
                }
                this.noModel.addElement((Object)pp);
            }
            if (this.tableSeqs != null) {
                Iterator<Object> iterator = this.tableSeqs.iterator();
                while (iterator.hasNext()) {
                    int key = (Integer)iterator.next();
                    if (curTabSel.get(key) == null) continue;
                    this.yesModel.addElement(curTabSel.get(key));
                }
            }
        }
        catch (DBException e) {
            log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
        }
        this.bAdd.setEnabled(true);
        this.bRemove.setEnabled(true);
        this.bUp.setEnabled(true);
        this.bDown.setEnabled(true);
        this.yesList.setEnabled(true);
        this.noList.setEnabled(true);
        this.yesList.setItemRenderer((ListitemRenderer)this.yesModel);
        this.yesList.setModel((ListModel)this.yesModel);
        this.noList.setItemRenderer((ListitemRenderer)this.noModel);
        this.noList.setModel((ListModel)this.noModel);
        ValueNamePair pp = new ValueNamePair(null, null);
        this.lstGridMode.addItem(pp);
        ValueNamePair[] list = MRefList.getList((Properties)Env.getCtx(), (int)319, (boolean)false);
        int i = 0;
        while (i < list.length) {
            this.lstGridMode.addItem(list[i]);
            if (this.m_tabcust != null && list[i].getValue().equals(this.m_tabcust.getIsDisplayedGrid())) {
                this.lstGridMode.setSelectedValueNamePair(list[i]);
            }
            ++i;
        }
        this.lstGridMode.setValue((Object)"Y");
        this.lstGridMode.setEnabled(false);
        this.chkSaveWidth.setChecked(true);
        this.chkSaveWidth.setEnabled(false);
    }

    void migrateValueAcrossLists(Event event) {
        Component source = event.getTarget();
        if (source instanceof ListItem) {
            source = ((ListItem)source).getListbox();
        }
        Listbox listFrom = source == this.bAdd || source == this.noList ? this.noList : this.yesList;
        Listbox listTo = source == this.bAdd || source == this.noList ? this.yesList : this.noList;
        int endIndex = this.yesList.getIndexOfItem((Listitem)listTo.getSelectedItem());
        if (endIndex < 0) {
            endIndex = 0;
        }
        this.migrateLists(listFrom, listTo, endIndex);
    }

    void migrateLists(Listbox listFrom, Listbox listTo, int endIndex) {
        int index = 0;
        SimpleListModel lmFrom = (SimpleListModel)listFrom.getModel();
        SimpleListModel lmTo = (SimpleListModel)listTo.getModel();
        Set selectedItems = listFrom.getSelectedItems();
        ArrayList<ListElement> selObjects = new ArrayList<ListElement>();
        for (Object obj : selectedItems) {
            ListItem listItem = (ListItem)obj;
            index = listFrom.getIndexOfItem((Listitem)listItem);
            ListElement selObject = (ListElement)((Object)lmFrom.getElementAt(index));
            selObjects.add(selObject);
        }
        for (ListElement selObject : selObjects) {
            if (selObject == null || !selObject.isUpdateable()) continue;
            lmFrom.removeElement((Object)selObject);
            lmTo.add(endIndex, (Object)selObject);
            ++endIndex;
            index = lmTo.indexOf((Object)selObject);
            listTo.setSelectedIndex(index);
        }
    }

    void migrateValueWithinYesList(int endIndex, List<ListElement> selObjects) {
        int iniIndex = 0;
        Arrays.sort(selObjects.toArray());
        ListElement endObject = (ListElement)((Object)this.yesModel.getElementAt(endIndex));
        for (ListElement selected : selObjects) {
            iniIndex = this.yesModel.indexOf((Object)selected);
            ListElement selObject = (ListElement)((Object)this.yesModel.getElementAt(iniIndex));
            this.yesModel.removeElement((Object)selObject);
            endIndex = this.yesModel.indexOf((Object)endObject);
            this.yesModel.add(endIndex, (Object)selObject);
        }
    }

    void migrateValueWithinYesList(Event event) {
        int i;
        Object[] selObjects = this.yesList.getSelectedItems().toArray();
        if (selObjects == null) {
            return;
        }
        int length = selObjects.length;
        if (length == 0) {
            return;
        }
        int[] indices = this.yesList.getSelectedIndices();
        Arrays.sort(indices);
        boolean change = false;
        Component source = event.getTarget();
        if (source == this.bUp) {
            i = 0;
            while (i < length) {
                int index = indices[i];
                if (index == 0) break;
                ListElement selObject = (ListElement)((Object)this.yesModel.getElementAt(index));
                ListElement newObject = (ListElement)((Object)this.yesModel.getElementAt(index - 1));
                if (selObject.isUpdateable() && newObject.isUpdateable()) {
                    this.yesModel.setElementAt((Object)newObject, index);
                    this.yesModel.setElementAt((Object)selObject, index - 1);
                    indices[i] = index - 1;
                    change = true;
                    ++i;
                    continue;
                }
                break;
            }
        } else if (source == this.bDown) {
            i = length - 1;
            while (i >= 0) {
                int index = indices[i];
                if (index >= this.yesModel.getSize() - 1) break;
                ListElement selObject = (ListElement)((Object)this.yesModel.getElementAt(index));
                ListElement newObject = (ListElement)((Object)this.yesModel.getElementAt(index + 1));
                if (selObject.isUpdateable() && newObject.isUpdateable()) {
                    this.yesModel.setElementAt((Object)newObject, index);
                    this.yesModel.setElementAt((Object)selObject, index + 1);
                    this.yesList.setSelectedIndex(index + 1);
                    indices[i] = index + 1;
                    change = true;
                    --i;
                    continue;
                }
                break;
            }
        }
        if (change) {
            this.yesList.setSelectedIndices(indices);
            if (this.yesList.getSelectedItem() != null) {
                AuFocus focus = new AuFocus((Component)this.yesList.getSelectedItem());
                Clients.response((AuResponse)focus);
            }
        }
    }

    public void saveData() {
        ListElement pp;
        log.fine("");
        boolean ok = true;
        StringBuilder custom = new StringBuilder();
        int i = 0;
        while (i < this.yesModel.getSize()) {
            pp = (ListElement)((Object)this.yesModel.getElementAt(i));
            if (pp.isUpdateable()) {
                if (i > 0) {
                    custom.append(",");
                }
                custom.append(pp.getKey());
            }
            ++i;
        }
        if (this.chkSaveWidth.isSelected() && this.m_columnsWidth != null && !this.m_columnsWidth.isEmpty()) {
            i = 0;
            while (i < this.yesModel.getSize()) {
                if (i > 0) {
                    custom.append(",");
                } else {
                    custom.append(";");
                }
                pp = (ListElement)((Object)this.yesModel.getElementAt(i));
                int fieldId = pp.getKey();
                String width = this.m_columnsWidth.get(fieldId);
                if (width == null) {
                    width = "";
                }
                custom.append(width);
                ++i;
            }
        }
        String gridview = null;
        if (this.lstGridMode.getSelectedItem() != null && this.lstGridMode.getSelectedItem().toString().length() > 0) {
            gridview = this.lstGridMode.getSelectedItem().toString();
        }
        if (this.m_tabcust != null && this.m_tabcust.getAD_Tab_Customization_ID() > 0) {
            this.m_tabcust.setCustom(custom.toString());
            this.m_tabcust.setIsDisplayedGrid(gridview);
        } else {
            this.m_tabcust = new MTabCustomization(Env.getCtx(), 0, null);
            this.m_tabcust.setAD_Tab_ID(this.m_AD_Tab_ID);
            this.m_tabcust.set_ValueOfColumn("AD_User_ID", (Object)this.m_AD_User_ID);
            this.m_tabcust.setCustom(custom.toString());
            this.m_tabcust.setIsDisplayedGrid(gridview);
        }
        if (this.m_tabcust.getCustom() == null || this.m_tabcust.getCustom().trim().length() == 0) {
            if (this.m_tabcust.is_new()) {
                this.getParent().detach();
                return;
            }
            ok = this.m_tabcust.delete(true);
        } else {
            ok = this.m_tabcust.save();
        }
        if (ok) {
            this.m_saved = true;
            this.getParent().detach();
            if (this.gridPanel != null) {
                try {
                    this.gridPanel.onEvent(new Event("onCustomizeGrid"));
                }
                catch (Exception exception) {}
            }
        } else {
            FDialog.error((int)this.m_WindowNo, null, (String)"SaveError", (String)custom.toString());
        }
    }

    public void activate(boolean b) {
        if (b && !this.uiCreated) {
            this.createUI();
        }
    }

    public void createUI() {
        if (this.uiCreated) {
            return;
        }
        try {
            this.init();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", (Throwable)e);
        }
        this.uiCreated = true;
    }

    public void query() {
        this.loadData();
    }

    public boolean isSaved() {
        return this.m_saved;
    }

    public void setGridPanel(JPiereSimpleInputWindow gridPanel) {
        this.gridPanel = gridPanel;
    }

    static /* synthetic */ ConfirmPanel access$0(SimpleInputWindowCustomizeGridViewPanel simpleInputWindowCustomizeGridViewPanel) {
        return simpleInputWindowCustomizeGridViewPanel.confirmPanel;
    }

    private class DragListener
    implements EventListener<Event> {
        public void onEvent(Event event) throws Exception {
            if (event instanceof DropEvent) {
                int endIndex = 0;
                DropEvent me = (DropEvent)event;
                ListItem endItem = (ListItem)me.getTarget();
                ListItem startItem = (ListItem)me.getDragged();
                if (!startItem.isSelected()) {
                    startItem.setSelected(true);
                }
                if (startItem.getListbox() != endItem.getListbox()) {
                    Listbox listFrom = (Listbox)startItem.getListbox();
                    Listbox listTo = (Listbox)endItem.getListbox();
                    endIndex = SimpleInputWindowCustomizeGridViewPanel.this.yesList.getIndexOfItem((Listitem)endItem);
                    SimpleInputWindowCustomizeGridViewPanel.this.migrateLists(listFrom, listTo, endIndex);
                } else if (startItem.getListbox() == endItem.getListbox() && startItem.getListbox() == SimpleInputWindowCustomizeGridViewPanel.this.yesList) {
                    ArrayList<ListElement> selObjects = new ArrayList<ListElement>();
                    endIndex = SimpleInputWindowCustomizeGridViewPanel.this.yesList.getIndexOfItem((Listitem)endItem);
                    for (Object obj : SimpleInputWindowCustomizeGridViewPanel.this.yesList.getSelectedItems()) {
                        ListItem listItem = (ListItem)obj;
                        int index = SimpleInputWindowCustomizeGridViewPanel.this.yesList.getIndexOfItem((Listitem)listItem);
                        ListElement selObject = (ListElement)((Object)SimpleInputWindowCustomizeGridViewPanel.this.yesModel.getElementAt(index));
                        selObjects.add(selObject);
                    }
                    SimpleInputWindowCustomizeGridViewPanel.this.migrateValueWithinYesList(endIndex, selObjects);
                    SimpleInputWindowCustomizeGridViewPanel.this.yesList.clearSelection();
                }
            }
        }
    }

    private static class ListElement
    extends NamePair {
        private static final long serialVersionUID = -1717531470895073281L;
        private int m_key;
        private boolean m_updateable;

        public ListElement(int key, String name) {
            super(name);
            this.m_key = key;
            this.m_updateable = true;
        }

        public int getKey() {
            return this.m_key;
        }

        public boolean isUpdateable() {
            return this.m_updateable;
        }

        public String getID() {
            return this.m_key != -1 ? String.valueOf(this.m_key) : null;
        }

        public int hashCode() {
            return this.m_key;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ListElement) {
                ListElement li = (ListElement)((Object)obj);
                return li.getKey() == this.m_key && li.getName() != null && li.getName().equals(this.getName());
            }
            return false;
        }

        public String toString() {
            String s = super.toString();
            if (s == null || s.trim().length() == 0) {
                s = "<" + this.getKey() + ">";
            }
            return s;
        }
    }
}

